/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.xceptance.xlt.api.engine.NetworkData;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.CachingHttpWebConnection;
import com.xceptance.xlt.engine.PageStatistics;
import com.xceptance.xlt.engine.RequestExecutionContext;
import com.xceptance.xlt.engine.RequestStack;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.XltWebClient;
import com.xceptance.xlt.engine.dns.DnsInfo;
import com.xceptance.xlt.engine.socket.SocketStatistics;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.engine.util.UrlUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.log4j.Logger;

public class XltHttpWebConnection
extends CachingHttpWebConnection {
    private static final byte[] EMPTY_RESPONSE_BODY = new byte[0];
    private static final List<NameValuePair> EMPTY_RESPONSE_HEADER_LIST = new ArrayList<NameValuePair>();
    private static final boolean requestIdActive;
    private static final int requestIdLength;
    private static final String requestIdHeader;
    private static final boolean requestIdAppendToUserAgent;
    private static final boolean responseIdActive;
    private static final String responseIdHeader;
    private static final boolean logEventOnRequestFailure;
    private final XltWebClient webClient;

    public XltHttpWebConnection(XltWebClient webClient, WebConnection webConnection) {
        super(webConnection);
        this.webClient = webClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResponse getResponse(WebRequest webRequest) throws IOException {
        URL url = webRequest.getUrl();
        RequestStack requestStack = RequestStack.getCurrent();
        requestStack.setTimerName(this.webClient.getTimerName());
        requestStack.pushRequest();
        try {
            WebResponse webResponse = null;
            if (this.webClient.isAcceptedUrl(url)) {
                webResponse = super.getResponse(webRequest);
                PageStatistics.getPageStatistics().addToTotalBytes(webResponse.getRawSize());
            } else {
                Logger logger = XltLogger.runTimeLogger;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping download of URL: " + url));
                }
                WebResponseData webResponseData = new WebResponseData(EMPTY_RESPONSE_BODY, 200, EnglishReasonPhraseCatalog.INSTANCE.getReason(200, null), EMPTY_RESPONSE_HEADER_LIST);
                webResponse = new WebResponse(webResponseData, url, webRequest.getHttpMethod(), 0L);
            }
            WebResponse webResponse2 = webResponse;
            return webResponse2;
        }
        finally {
            requestStack.popRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected WebResponse getResponse(WebRequest webRequest, String lastModifiedHeader, String etag) throws IOException {
        Map<String, String> originalRequestHeaders = webRequest.getAdditionalHeaders();
        RequestData requestData = null;
        WebResponse response = null;
        RequestStack requestStack = RequestStack.getCurrent();
        String timerName = requestStack.getHierarchicalTimerName();
        String requestName = requestStack.getHierarchicalRequestName(webRequest.getUrl());
        try {
            requestData = new RequestData(timerName);
            requestData.setUrl(webRequest.getUrl().toString());
            XltHttpWebConnection.putAdditionalRequestData(requestData, webRequest);
            long startTime = TimerUtils.getTime();
            String requestId = null;
            if (requestIdActive) {
                requestId = RandomStringUtils.randomAlphanumeric((int)requestIdLength);
                webRequest.setAdditionalHeader(requestIdHeader, requestId);
                if (requestIdAppendToUserAgent) {
                    String currentUserAgent = webRequest.getAdditionalHeader("User-Agent");
                    if (currentUserAgent == null) {
                        currentUserAgent = this.webClient.getBrowserVersion().getUserAgent();
                    }
                    String newUserAgent = currentUserAgent + " " + requestId;
                    webRequest.setAdditionalHeader("User-Agent", newUserAgent);
                }
            }
            String responseId = null;
            try {
                RequestExecutionContext.getCurrent().reset();
                response = super.getResponse(webRequest, lastModifiedHeader, etag);
                if (responseIdActive) {
                    responseId = response.getResponseHeaderValue(responseIdHeader);
                }
            }
            catch (IOException e) {
                requestData.setFailed(true);
                throw e;
            }
            finally {
                long runTime = TimerUtils.getTime() - startTime;
                requestData.setRunTime(runTime);
                requestData.setRequestId(requestId);
                requestData.setResponseId(responseId);
            }
            Logger logger = XltLogger.runTimeLogger;
            if (logger.isInfoEnabled()) {
                long runTime;
                logger.info((Object)(response.getWebRequest().getHttpMethod().name() + " - " + response.getStatusCode() + " - " + runTime + " ms - " + response.getWebRequest().getUrl() + " " + response.getWebRequest().getRequestParameters()));
            }
            requestData.setResponseCode(response.getStatusCode());
            requestData.setFailed(response.getStatusCode() >= 500);
            requestData.setContentType(response.getContentType());
            WebResponse webResponse = response = this.webClient.processResponse(response);
            return webResponse;
        }
        finally {
            WebRequest clonedWebRequest = this.cloneWebRequest(webRequest);
            webRequest.setAdditionalHeaders(originalRequestHeaders);
            SocketStatistics socketStats = RequestExecutionContext.getCurrent().getSocketMonitor().getSocketStatistics();
            requestData.setBytesSent(socketStats.getBytesSent());
            requestData.setBytesReceived(socketStats.getBytesReceived());
            requestData.setConnectTime(socketStats.getConnectTime());
            requestData.setSendTime(socketStats.getSendTime());
            requestData.setServerBusyTime(socketStats.getServerBusyTime());
            requestData.setReceiveTime(socketStats.getReceiveTime());
            requestData.setTimeToFirstBytes(socketStats.getTimeToFirstBytes());
            requestData.setTimeToLastBytes(socketStats.getTimeToLastBytes());
            requestData.setDnsTime(socketStats.getDnsLookupTime());
            DnsInfo dnsInfo = RequestExecutionContext.getCurrent().getDnsMonitor().getDnsInfo();
            requestData.setIpAddresses(dnsInfo.getIpAddresses());
            SessionImpl session = (SessionImpl)Session.getCurrent();
            session.getDataManager().logDataRecord(requestData);
            session.getRequestHistory().add(requestName, clonedWebRequest, response, requestData);
            session.getNetworkDataManager().addData(new NetworkData(clonedWebRequest, response));
            this.logEventIfNecessary(clonedWebRequest, response);
            PageStatistics.getPageStatistics().addToBytes(requestData.getBytesReceived());
            if (response != null) {
                response.setRawSize(requestData.getBytesReceived());
            }
        }
    }

    protected WebRequest cloneWebRequest(WebRequest webRequest) {
        WebRequest newWebRequestSettings = new WebRequest(webRequest.getUrl());
        newWebRequestSettings.setAdditionalHeaders(webRequest.getAdditionalHeaders());
        newWebRequestSettings.setCharset(webRequest.getCharset());
        newWebRequestSettings.setCredentials(webRequest.getCredentials());
        newWebRequestSettings.setEncodingType(webRequest.getEncodingType());
        newWebRequestSettings.setHttpMethod(webRequest.getHttpMethod());
        newWebRequestSettings.setProxyHost(webRequest.getProxyHost());
        newWebRequestSettings.setProxyPort(webRequest.getProxyPort());
        newWebRequestSettings.setOriginalURL(webRequest.getOriginalURL());
        if (webRequest.getRequestBody() != null) {
            newWebRequestSettings.setRequestBody(webRequest.getRequestBody());
        } else {
            newWebRequestSettings.setRequestParameters(webRequest.getRequestParameters());
        }
        return newWebRequestSettings;
    }

    protected void logEventIfNecessary(WebRequest request, WebResponse response) {
        URL url;
        int statusCode;
        if (!logEventOnRequestFailure) {
            return;
        }
        if (response == null) {
            statusCode = 0;
            url = request.getUrl();
        } else {
            statusCode = response.getStatusCode();
            url = response.getWebRequest().getUrl();
        }
        if (statusCode == 0 || statusCode >= 400) {
            String eventName = "Failed to download resource";
            String message = String.format("[%d] %s", statusCode, url);
            Session.getCurrent().getDataManager().logEvent("Failed to download resource", message);
        }
    }

    protected static void putAdditionalRequestData(RequestData requestData, WebRequest webRequest) {
        if (SessionImpl.COLLECT_ADDITIONAL_REQUEST_DATA) {
            HttpMethod method = webRequest.getHttpMethod();
            requestData.setHttpMethod(method.toString());
            if (method == HttpMethod.POST) {
                FormEncodingType encodingType = webRequest.getEncodingType();
                requestData.setFormDataEncoding(encodingType.getName());
                if (encodingType == FormEncodingType.URL_ENCODED) {
                    String formData = webRequest.getRequestBody();
                    if (formData == null) {
                        formData = UrlUtils.getUrlEncodedParameters(webRequest.getRequestParameters());
                    }
                    requestData.setFormData(formData);
                }
            }
        }
    }

    static {
        EMPTY_RESPONSE_HEADER_LIST.add(new NameValuePair("Content-Type", "text/html; charset=UTF-8"));
        XltProperties props = XltProperties.getInstance();
        String requestIdPropertyPrefix = "com.xceptance.xlt.http.requestId.";
        requestIdActive = props.getProperty("com.xceptance.xlt.http.requestId.enabled", false);
        requestIdLength = props.getProperty("com.xceptance.xlt.http.requestId.length", 15);
        requestIdHeader = props.getProperty("com.xceptance.xlt.http.requestId.headerName", "X-XLT-RequestId");
        requestIdAppendToUserAgent = props.getProperty("com.xceptance.xlt.http.requestId.appendToUserAgent", false);
        String responseIdPropertyPrefix = "com.xceptance.xlt.http.responseId.";
        responseIdActive = props.getProperty("com.xceptance.xlt.http.responseId.enabled", false);
        responseIdHeader = props.getProperty("com.xceptance.xlt.http.responseId.headerName", "X-XLT-ResponseId");
        logEventOnRequestFailure = props.getProperty("com.xceptance.xlt.http.requestFailure.logEvent", true);
    }
}

