/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.data;

import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.data.DataSetProvider;
import com.xceptance.xlt.api.data.DataSetProviderException;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.data.CsvDataSetProvider;
import com.xceptance.xlt.engine.data.DomXmlDataSetProvider;
import com.xceptance.xlt.engine.data.JdbcDataSetProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class DataSetProviderFactory {
    private final Map<String, Class<? extends DataSetProvider>> providers = new LinkedHashMap<String, Class<? extends DataSetProvider>>();

    public static DataSetProviderFactory getInstance() {
        return SingletonHolder.factory;
    }

    private DataSetProviderFactory() {
        this.registerDataSetProvider("csv", CsvDataSetProvider.class);
        this.registerDataSetProvider("xml", DomXmlDataSetProvider.class);
        this.registerDataSetProvider("sql", JdbcDataSetProvider.class);
        AbstractConfiguration config = new AbstractConfiguration();
        config.addProperties(XltProperties.getInstance().getProperties());
        Set<String> extensions = config.getPropertyKeyFragment("com.xceptance.xlt.data.dataSetProviders.");
        for (String extension : extensions) {
            Class<?> clazz = config.getClassProperty("com.xceptance.xlt.data.dataSetProviders." + extension, null);
            if (clazz == null) continue;
            if (DataSetProvider.class.isAssignableFrom(clazz)) {
                this.registerDataSetProvider(extension, clazz);
                continue;
            }
            if (!XltLogger.runTimeLogger.isEnabledFor((Priority)Level.ERROR)) continue;
            XltLogger.runTimeLogger.error((Object)String.format("Data set provider class '%s' registered for file extension '%s' does not implement interface '%s'", clazz.getName(), extension, DataSetProvider.class.getName()));
        }
    }

    public void registerDataSetProvider(String fileExtension, Class<? extends DataSetProvider> dataSetProviderClass) {
        ParameterCheckUtils.isNonEmptyString(fileExtension, "fileExtension");
        if (XltLogger.runTimeLogger.isDebugEnabled()) {
            XltLogger.runTimeLogger.debug((Object)String.format("Registering data set provider '%s' for file extension '%s'", dataSetProviderClass.getName(), fileExtension));
        }
        this.providers.put(fileExtension, dataSetProviderClass);
    }

    public void unregisterDataSetProvider(String fileExtension) {
        ParameterCheckUtils.isNonEmptyString(fileExtension, "fileExtension");
        this.providers.remove(fileExtension);
    }

    public Set<String> getRegisteredFileExtensions() {
        return this.providers.keySet();
    }

    public DataSetProvider createDataSetProvider(String fileExtension) throws DataSetProviderException {
        ParameterCheckUtils.isNonEmptyString(fileExtension, "fileExtension");
        Class<? extends DataSetProvider> dataSetProviderClass = this.providers.get(fileExtension);
        if (dataSetProviderClass == null) {
            throw new DataSetProviderException("No data set provider registered for file extension: " + fileExtension);
        }
        try {
            return dataSetProviderClass.newInstance();
        }
        catch (Exception e) {
            throw new DataSetProviderException("Failed to instantiate data set provider", e);
        }
    }

    private static class SingletonHolder {
        private static final DataSetProviderFactory factory = new DataSetProviderFactory();

        private SingletonHolder() {
        }
    }
}

