/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.htmlunit.okhttp3;

import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.util.Cookie;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;

class CookieJarImpl
implements CookieJar {
    private final CookieManager cookieManager;

    public CookieJarImpl(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public void saveFromResponse(HttpUrl url, List<okhttp3.Cookie> okHttpCookies) {
        for (okhttp3.Cookie okHttpCookie : okHttpCookies) {
            this.cookieManager.addCookie(CookieJarImpl.toHtmlUnitCookie(okHttpCookie));
        }
    }

    public List<okhttp3.Cookie> loadForRequest(HttpUrl url) {
        this.cookieManager.clearExpired(new Date());
        return this.cookieManager.getCookies().stream().map(CookieJarImpl::toOkHttpCookie).filter(okHttpCookie -> okHttpCookie.matches(url)).collect(Collectors.toList());
    }

    private static Cookie toHtmlUnitCookie(okhttp3.Cookie okHttpCookie) {
        String domain = okHttpCookie.hostOnly() ? okHttpCookie.domain() : "." + okHttpCookie.domain();
        return new Cookie(domain, okHttpCookie.name(), okHttpCookie.value(), okHttpCookie.path(), new Date(okHttpCookie.expiresAt()), okHttpCookie.secure(), okHttpCookie.httpOnly());
    }

    private static okhttp3.Cookie toOkHttpCookie(Cookie htmlUnitCookie) {
        Cookie.Builder builder = new Cookie.Builder();
        builder.name(htmlUnitCookie.getName()).value(htmlUnitCookie.getValue()).path(htmlUnitCookie.getPath()).expiresAt(htmlUnitCookie.getExpires().getTime());
        String domain = htmlUnitCookie.getDomain();
        if (domain.startsWith(".")) {
            builder.domain(StringUtils.stripStart((String)domain, (String)"."));
        } else {
            builder.hostOnlyDomain(domain);
        }
        if (htmlUnitCookie.isSecure()) {
            builder.secure();
        }
        if (htmlUnitCookie.isHttpOnly()) {
            builder.httpOnly();
        }
        return builder.build();
    }
}

