/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.junit;

import com.xceptance.xlt.api.data.DataSetProvider;
import com.xceptance.xlt.api.data.DataSetProviderException;
import com.xceptance.xlt.api.engine.DataSetIndex;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.tests.AbstractTestCase;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.util.XltRandom;
import com.xceptance.xlt.engine.data.DataSetProviderFactory;
import com.xceptance.xlt.engine.util.XltTestRunner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public abstract class AbstractTestCaseRunner
extends XltTestRunner {
    private static final Map<String, String> EMPTY_DATA_SET;
    protected static final File CURRENT_DIR;
    protected static final File DATA_SETS_DIR;
    private final List<FrameworkMethod> methods = new ArrayList<FrameworkMethod>();

    protected AbstractTestCaseRunner(Class<?> testCaseClass, String testCaseName, String defaultTestMethodName, List<File> dataSetFileDirs) throws Throwable {
        super(testCaseClass);
        String shortTestCaseName = StringUtils.contains((CharSequence)testCaseName, (int)46) ? StringUtils.substringAfterLast((String)testCaseName, (String)".") : testCaseName;
        List<Map<String, String>> dataSets = this.getDataSets(testCaseClass, testCaseName, shortTestCaseName, dataSetFileDirs);
        for (FrameworkMethod frameworkMethod : this.getTestClass().getAnnotatedMethods(Test.class)) {
            Method testMethod = frameworkMethod.getMethod();
            String testMethodName = defaultTestMethodName == null ? testMethod.getName() : defaultTestMethodName;
            this.addParameterizedFrameworkMethods(testCaseClass, testMethod, testMethodName, dataSets);
        }
    }

    private void addParameterizedFrameworkMethods(Class<?> testCaseClass, Method testMethod, String testMethodName, List<Map<String, String>> dataSets) {
        if (dataSets == null || dataSets.isEmpty()) {
            this.methods.add(new ParameterizedFrameworkMethod(testMethod, testMethodName, -1, EMPTY_DATA_SET));
        } else {
            Annotation[] annotations;
            int dSIndex = -1;
            for (Annotation annotation : annotations = testCaseClass.getAnnotations()) {
                if (!(annotation instanceof DataSetIndex)) continue;
                dSIndex = ((DataSetIndex)annotation).value();
            }
            if (Session.getCurrent().isLoadTest() && dSIndex <= -1) {
                dSIndex = XltProperties.getInstance().getProperty("com.xceptance.xlt.data.dataSets.loadtest.pickRandomDataSet", false) ? XltRandom.nextInt(dataSets.size()) : 0;
            }
            if (dSIndex >= dataSets.size()) {
                throw new IllegalArgumentException("Selected data set can not be found. Please check your test case setup.");
            }
            int i = 0;
            for (Map<String, String> dataSet : dataSets) {
                if (dSIndex <= -1 || dSIndex == i) {
                    this.methods.add(new ParameterizedFrameworkMethod(testMethod, testMethodName, i, dataSet));
                }
                ++i;
            }
        }
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription((Class)this.getTestClass().getJavaClass());
        for (FrameworkMethod frameworkMethod : this.getChildren()) {
            description.addChild(Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)frameworkMethod.getName()));
        }
        return description;
    }

    protected List<FrameworkMethod> getChildren() {
        return this.methods;
    }

    @Override
    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        this.setUpTest(method, test);
        return super.methodInvoker(method, test);
    }

    protected void setUpTest(FrameworkMethod method, Object test) {
        if (test instanceof AbstractTestCase) {
            AbstractTestCase abstractTestCase = (AbstractTestCase)test;
            ParameterizedFrameworkMethod frameworkMethod = (ParameterizedFrameworkMethod)method;
            if (abstractTestCase.getTestDataSet() == null) {
                abstractTestCase.setTestDataSet(frameworkMethod.dataSet);
            }
        }
    }

    private List<Map<String, String>> getDataSets(Class<?> testClass, String fullTestCaseName, String shortTestCaseName, List<File> dataSetFileDirs) throws DataSetProviderException, FileNotFoundException, IOException {
        boolean enabled = XltProperties.getInstance().getProperty("com.xceptance.xlt.data.dataDrivenTests.enabled", true);
        if (!enabled) {
            return null;
        }
        String specificFileNameKey1 = testClass.getName() + ".dataSetsFile";
        String specificFileName = XltProperties.getInstance().getProperty(specificFileNameKey1, "");
        if (specificFileName.length() == 0) {
            String specificFileNameKey2 = fullTestCaseName + ".dataSetsFile";
            specificFileName = XltProperties.getInstance().getProperty(specificFileNameKey2, "");
        }
        if (specificFileName.length() != 0) {
            File batchDataFile = new File(specificFileName);
            if (batchDataFile.isAbsolute()) {
                return this.readDataSets(batchDataFile);
            }
            for (File directory : dataSetFileDirs) {
                batchDataFile = new File(directory, specificFileName);
                if (!batchDataFile.isFile()) continue;
                return this.readDataSets(batchDataFile);
            }
            throw new FileNotFoundException("Specific test data set file name configured, but file could not be found: " + specificFileName);
        }
        LinkedHashSet<String> fileNames = new LinkedHashSet<String>();
        String dottedName = fullTestCaseName;
        String slashedName = dottedName.replace('.', '/');
        DataSetProviderFactory dataSetProviderFactory = DataSetProviderFactory.getInstance();
        for (String fileExtension : dataSetProviderFactory.getRegisteredFileExtensions()) {
            String suffix = "_datasets." + fileExtension;
            fileNames.add(slashedName + suffix);
            fileNames.add(dottedName + suffix);
        }
        return this.getDataSets(dataSetFileDirs, fileNames, testClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> getDataSets(List<File> dataSetFileDirs, Set<String> fileNames, Class<?> testClass) throws IOException {
        File batchDataFile;
        for (File directory : dataSetFileDirs) {
            for (String fileName : fileNames) {
                batchDataFile = new File(directory, fileName);
                if (!batchDataFile.isFile()) continue;
                return this.readDataSets(batchDataFile);
            }
        }
        for (String fileName : fileNames) {
            List<Map<String, String>> list;
            InputStream input = testClass.getResourceAsStream("/" + fileName);
            if (input == null) continue;
            FileOutputStream output = null;
            batchDataFile = null;
            try {
                String extension = "." + FilenameUtils.getExtension((String)fileName);
                batchDataFile = File.createTempFile("dataSets_", extension);
                output = new FileOutputStream(batchDataFile);
                IOUtils.copy((InputStream)input, (OutputStream)output);
                output.flush();
                list = this.readDataSets(batchDataFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)input);
                IOUtils.closeQuietly(output);
                FileUtils.deleteQuietly((File)batchDataFile);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
            FileUtils.deleteQuietly((File)batchDataFile);
            return list;
        }
        return null;
    }

    private List<Map<String, String>> readDataSets(File dataSetsFile) throws DataSetProviderException {
        if (XltLogger.runTimeLogger.isDebugEnabled()) {
            XltLogger.runTimeLogger.debug((Object)("Test data set file used: " + dataSetsFile.getAbsolutePath()));
        }
        DataSetProviderFactory dataSetProviderFactory = DataSetProviderFactory.getInstance();
        String fileExtension = FilenameUtils.getExtension((String)dataSetsFile.getName());
        DataSetProvider dataSetProvider = dataSetProviderFactory.createDataSetProvider(fileExtension);
        return dataSetProvider.getAllDataSets(dataSetsFile);
    }

    static {
        File dir;
        EMPTY_DATA_SET = Collections.emptyMap();
        CURRENT_DIR = new File(".");
        String dataSetFileDirectoryName = XltProperties.getInstance().getProperty("com.xceptance.xlt.data.dataSets.dir", "");
        DATA_SETS_DIR = dataSetFileDirectoryName.length() > 0 ? ((dir = new File(dataSetFileDirectoryName)).isDirectory() ? dir : null) : null;
    }

    private static class ParameterizedFrameworkMethod
    extends FrameworkMethod {
        private final Map<String, String> dataSet;
        private final String name;

        public ParameterizedFrameworkMethod(Method method, String testMethodName, int index, Map<String, String> dataSet) {
            super(method);
            this.dataSet = dataSet;
            this.name = index == -1 ? testMethodName : String.format("%s[%d] - %s", testMethodName, index, dataSet);
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }
}

