/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.metrics;

import com.xceptance.xlt.agent.JvmResourceUsageData;
import com.xceptance.xlt.api.engine.ActionData;
import com.xceptance.xlt.api.engine.CustomData;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.EventData;
import com.xceptance.xlt.api.engine.PageLoadTimingData;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.metrics.CounterMetric;
import com.xceptance.xlt.engine.metrics.Metric;
import com.xceptance.xlt.engine.metrics.RateMetric;
import com.xceptance.xlt.engine.metrics.ValueMetric;
import com.xceptance.xlt.engine.metrics.graphite.GraphiteReporter;
import com.xceptance.xlt.engine.metrics.graphite.PlainTextCarbonClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Metrics {
    private static final int ONE_SEC = 1000;
    private static final int ONE_HOUR = 3600000;
    private static final String PROP_REP_PREFIX = "xlt.reporting.";
    private static final String PROP_REP_ENABLED = "xlt.reporting.enabled";
    private static final String PROP_REP_INTERVAL = "xlt.reporting.interval";
    private static final String PROP_REP_METRIC_NAME_PREFIX = "xlt.reporting.metricNamePrefix";
    private static final String PROP_REP_PREFIX_GRAPHITE = "xlt.reporting.graphite.";
    private static final String PROP_REP_GRAPHITE_SERVER = "xlt.reporting.graphite.host";
    private static final String PROP_REP_GRAPHITE_PORT = "xlt.reporting.graphite.port";
    private static final Log log = LogFactory.getLog(Metrics.class);
    private final Map<String, Metric> metricsRegistry = new ConcurrentHashMap<String, Metric>();
    private final boolean enabled;
    private final int reportingInterval;
    private final String sanitizedAgentId;

    public static Metrics getInstance() {
        return LazySingletonHolder.metrics;
    }

    protected Metrics() {
        XltProperties props = XltProperties.getInstance();
        this.enabled = props.getProperty(PROP_REP_ENABLED, false);
        this.reportingInterval = props.getProperty(PROP_REP_INTERVAL, 5) * 1000;
        String host = props.getProperty(PROP_REP_GRAPHITE_SERVER, "localhost");
        int port = props.getProperty(PROP_REP_GRAPHITE_PORT, 2003);
        String metricsNamePrefix = props.getProperty(PROP_REP_METRIC_NAME_PREFIX, "");
        metricsNamePrefix = this.sanitizeFullMetricName(metricsNamePrefix);
        if (!metricsNamePrefix.endsWith(".")) {
            metricsNamePrefix = metricsNamePrefix + ".";
        }
        this.sanitizedAgentId = this.sanitizeMetricNamePart(Session.getCurrent().getAgentID());
        if (this.enabled && Session.getCurrent().isLoadTest()) {
            try {
                PlainTextCarbonClient carbonClient = new PlainTextCarbonClient(host, port);
                GraphiteReporter reporter = new GraphiteReporter(carbonClient, this.metricsRegistry, metricsNamePrefix, this.reportingInterval);
                reporter.start();
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Started reporting metrics to Graphite server %s:%d every %d ms", host, port, this.reportingInterval));
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to start Graphite reporter", (Throwable)e);
            }
        }
    }

    public void updateMetrics(Data data) {
        if (this.enabled) {
            if (data instanceof RequestData) {
                this.updateRequestMetrics((RequestData)data);
            } else if (data instanceof ActionData) {
                this.updateActionMetrics((ActionData)data);
            } else if (data instanceof TransactionData) {
                this.updateTransactionMetrics((TransactionData)data);
            } else if (data instanceof PageLoadTimingData) {
                this.updatePageLoadTimingMetrics((PageLoadTimingData)data);
            } else if (data instanceof CustomData) {
                this.updateCustomTimerMetrics((CustomData)data);
            } else if (data instanceof EventData) {
                this.updateEventMetrics((EventData)data);
            } else if (data instanceof JvmResourceUsageData) {
                this.updateJvmMetrics((JvmResourceUsageData)data);
            }
        }
    }

    private void updateTransactionMetrics(TransactionData transactionData) {
        String sanitizedName = this.sanitizeMetricNamePart(transactionData.getName());
        String metricPrefix = this.sanitizedAgentId + ".transactions." + sanitizedName + ".";
        this.updateValueMetric(metricPrefix + "runtime", (int)transactionData.getRunTime());
        this.updateCounterMetric(metricPrefix + "errors", transactionData.hasFailed() ? 1 : 0);
        this.updateRateMetric(metricPrefix + "arrivals_1h", 1, 3600000, this.reportingInterval);
        String summaryMetricPrefix = this.sanitizedAgentId + ".summary.transactions.";
        this.updateValueMetric(summaryMetricPrefix + "runtime", (int)transactionData.getRunTime());
        this.updateCounterMetric(summaryMetricPrefix + "count", 1);
        this.updateCounterMetric(summaryMetricPrefix + "errors", transactionData.hasFailed() ? 1 : 0);
        this.updateRateMetric(summaryMetricPrefix + "arrivals_1h", 1, 3600000, this.reportingInterval);
    }

    private void updateActionMetrics(ActionData actionData) {
        String sanitizedName = this.sanitizeMetricNamePart(actionData.getName());
        String metricPrefix = this.sanitizedAgentId + ".actions." + sanitizedName + ".";
        this.updateValueMetric(metricPrefix + "runtime", (int)actionData.getRunTime());
        this.updateCounterMetric(metricPrefix + "errors", actionData.hasFailed() ? 1 : 0);
        String summaryMetricPrefix = this.sanitizedAgentId + ".summary.actions.";
        this.updateValueMetric(summaryMetricPrefix + "runtime", (int)actionData.getRunTime());
        this.updateCounterMetric(summaryMetricPrefix + "count", 1);
        this.updateCounterMetric(summaryMetricPrefix + "errors", actionData.hasFailed() ? 1 : 0);
    }

    private void updateRequestMetrics(RequestData requestData) {
        String strippedRequestName = StringUtils.substringBefore((String)requestData.getName(), (String)".");
        String sanitizedName = this.sanitizeMetricNamePart(strippedRequestName);
        String metricPrefix = this.sanitizedAgentId + ".requests." + sanitizedName + ".";
        this.updateValueMetric(metricPrefix + "runtime", (int)requestData.getRunTime());
        this.updateCounterMetric(metricPrefix + "errors", requestData.hasFailed() ? 1 : 0);
        String summaryMetricPrefix = this.sanitizedAgentId + ".summary.requests.";
        this.updateValueMetric(summaryMetricPrefix + "runtime", (int)requestData.getRunTime());
        this.updateCounterMetric(summaryMetricPrefix + "count", 1);
        this.updateCounterMetric(summaryMetricPrefix + "errors", requestData.hasFailed() ? 1 : 0);
        this.updateRateMetric(summaryMetricPrefix + "bytesSent_1s", requestData.getBytesSent(), 1000, this.reportingInterval);
        this.updateRateMetric(summaryMetricPrefix + "bytesReceived_1s", requestData.getBytesReceived(), 1000, this.reportingInterval);
    }

    private void updatePageLoadTimingMetrics(PageLoadTimingData pageLoadTimingData) {
        String sanitizedName = this.sanitizeMetricNamePart(pageLoadTimingData.getName());
        String metricPrefix = this.sanitizedAgentId + ".pageLoadTimings." + sanitizedName + ".";
        this.updateValueMetric(metricPrefix + "runtime", (int)pageLoadTimingData.getRunTime());
        this.updateCounterMetric(metricPrefix + "errors", pageLoadTimingData.hasFailed() ? 1 : 0);
        String summaryMetricPrefix = this.sanitizedAgentId + ".summary.pageLoadTimings.";
        this.updateValueMetric(summaryMetricPrefix + "runtime", (int)pageLoadTimingData.getRunTime());
        this.updateCounterMetric(summaryMetricPrefix + "count", 1);
        this.updateCounterMetric(summaryMetricPrefix + "errors", pageLoadTimingData.hasFailed() ? 1 : 0);
    }

    private void updateCustomTimerMetrics(CustomData customData) {
        String sanitizedName = this.sanitizeMetricNamePart(customData.getName());
        String metricPrefix = this.sanitizedAgentId + ".custom." + sanitizedName + ".";
        this.updateValueMetric(metricPrefix + "runtime", (int)customData.getRunTime());
        this.updateCounterMetric(metricPrefix + "errors", customData.hasFailed() ? 1 : 0);
        String summaryMetricPrefix = this.sanitizedAgentId + ".summary.custom.";
        this.updateValueMetric(summaryMetricPrefix + "runtime", (int)customData.getRunTime());
        this.updateCounterMetric(summaryMetricPrefix + "count", 1);
        this.updateCounterMetric(summaryMetricPrefix + "errors", customData.hasFailed() ? 1 : 0);
    }

    private void updateEventMetrics(EventData eventData) {
        String summaryMetricPrefix = this.sanitizedAgentId + ".summary.events.";
        this.updateCounterMetric(summaryMetricPrefix + "count", 1);
    }

    private void updateJvmMetrics(JvmResourceUsageData jvmData) {
        String metricPrefix = this.sanitizedAgentId + ".agent.";
        this.updateValueMetric(metricPrefix + "heapUsage", (int)jvmData.getHeapUsage());
        this.updateValueMetric(metricPrefix + "totalCpuUsage", (int)jvmData.getTotalCpuUsage());
    }

    private void updateCounterMetric(String metricName, int value) {
        Metric metric = this.metricsRegistry.get(metricName);
        if (metric == null) {
            metric = this.getExistingOrAddNewMetric(metricName, new CounterMetric());
        }
        metric.update(value);
    }

    private void updateRateMetric(String metricName, int value, int rateInterval, int reportingInterval) {
        Metric metric = this.metricsRegistry.get(metricName);
        if (metric == null) {
            metric = this.getExistingOrAddNewMetric(metricName, new RateMetric(rateInterval, reportingInterval));
        }
        metric.update(value);
    }

    private void updateValueMetric(String metricName, int value) {
        Metric metric = this.metricsRegistry.get(metricName);
        if (metric == null) {
            metric = this.getExistingOrAddNewMetric(metricName, new ValueMetric());
        }
        metric.update(value);
    }

    private synchronized Metric getExistingOrAddNewMetric(String metricName, Metric newMetric) {
        Metric metric = this.metricsRegistry.get(metricName);
        if (metric == null) {
            metric = newMetric;
            this.metricsRegistry.put(metricName, metric);
        }
        return metric;
    }

    private String sanitizeFullMetricName(String metricName) {
        return this.sanitizeMetricName(metricName, true);
    }

    private String sanitizeMetricNamePart(String metricNamePart) {
        return this.sanitizeMetricName(metricNamePart, false);
    }

    private String sanitizeMetricName(String metricName, boolean dotsAllowed) {
        char[] chars = metricName.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean isValidChar;
            char c = chars[i];
            boolean bl = isValidChar = CharUtils.isAsciiAlphanumeric((char)c) || c == '_' || c == '-' || c == '.' && dotsAllowed;
            if (isValidChar) continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    public static class LazySingletonHolder {
        private static final Metrics metrics = new Metrics();
    }
}

