/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.metrics;

import com.xceptance.xlt.engine.metrics.Metric;

public class RateMetric
implements Metric {
    private long sum;
    private long time;
    private final long rateInterval;
    private final long reportingInterval;
    private boolean hasData;

    public RateMetric(long rateInterval, long reportingInterval) {
        this.rateInterval = rateInterval;
        this.reportingInterval = reportingInterval;
    }

    @Override
    public synchronized void update(int value) {
        this.sum += (long)value;
        this.hasData = true;
    }

    public synchronized Double getRateAndClear() {
        Double rate;
        if (this.hasData) {
            long now = System.nanoTime() / 1000000L;
            double duration = this.time == 0L ? (double)this.reportingInterval : (double)(now - this.time);
            rate = (double)this.sum * (double)this.rateInterval / duration;
            this.sum = 0L;
            this.time = now;
            this.hasData = false;
        } else {
            rate = null;
        }
        return rate;
    }
}

