/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.metrics.graphite;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlainTextCarbonClient {
    private static final Log log = LogFactory.getLog(PlainTextCarbonClient.class);
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private final InetSocketAddress address;
    private Socket socket;
    private Writer writer;

    public PlainTextCarbonClient(String host, int port) throws UnknownHostException, IllegalArgumentException {
        this.address = new InetSocketAddress(host, port);
        if (this.address.isUnresolved()) {
            throw new UnknownHostException(host);
        }
    }

    public void connect() throws IllegalStateException, IOException {
        if (this.socket != null) {
            throw new IllegalStateException("Already connected");
        }
        this.socket = SocketFactory.getDefault().createSocket(this.address.getAddress(), this.address.getPort());
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), US_ASCII));
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.writer.flush();
                this.socket.close();
                this.socket = null;
                this.writer = null;
            }
            catch (IOException e) {
                log.debug((Object)"Failed to close connection to Graphite server", (Throwable)e);
            }
        }
    }

    public void send(String name, String value, long timestamp) throws IOException {
        String line = name + ' ' + value + ' ' + timestamp + '\n';
        this.writer.write(line);
    }
}

