/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.xceptance.common.collection.ConcurrentLRUCache;
import com.xceptance.common.collection.LRUList;
import com.xceptance.common.lang.ThrowableUtils;
import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.common.util.ParseUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.resultbrowser.ActionInfo;
import com.xceptance.xlt.engine.resultbrowser.DumpMgr;
import com.xceptance.xlt.engine.resultbrowser.Page;
import com.xceptance.xlt.engine.resultbrowser.Request;
import com.xceptance.xlt.engine.util.TimedCounter;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class RequestHistory {
    public static final String OUTPUT2DISK_PROPERTY = "com.xceptance.xlt.output2disk";
    private static final String OUTPUT2DISK_WRITEHAR_PROPERTY = "com.xceptance.xlt.output2disk.writeHarFile";
    private static final String OUTPUT2DISK_SIZE_PROPERTY = "com.xceptance.xlt.output2disk.size";
    public static final String OUTPUT2DISK_ERROR_PROPERTY = "com.xceptance.xlt.output2disk.onError";
    public static final String LIMITER_PROPERTY = "com.xceptance.xlt.output2disk.onError.limiter";
    private static final String MAX_DUMP_COUNT_PROPERTY = "com.xceptance.xlt.output2disk.onError.limiter.maxDumps";
    private static final String COUNTER_RESET_INTERVAL_PROPERTY = "com.xceptance.xlt.output2disk.onError.limiter.resetInterval";
    private static final String MAX_DIFFERENT_ERRORS_PROPERTY = "com.xceptance.xlt.output2disk.onError.limiter.maxDifferentErrors";
    private static final int MAX_DIFFERENT_ERRORS_DEFAULT = 1000;
    private static final long COUNTER_RESET_INTERVAL = RequestHistory.getConfiguredCounterResetInterval();
    private static final ConcurrentLRUCache<String, TimedCounter> DUMP_COUNT = RequestHistory.getDumpCounter();
    private final LRUList<Page> pages;
    private final List<Request> pendingRequests;
    private DumpMode dumpMode;
    private DumpMgr dumpMgr;
    private final int maxDumpCount;

    private static long getConfiguredCounterResetInterval() {
        String intervalString = XltProperties.getInstance().getProperty(COUNTER_RESET_INTERVAL_PROPERTY, "0");
        long tmpInterval = 0L;
        try {
            tmpInterval = ParseUtils.parseTimePeriod(intervalString);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("The value '%s' of property '%s' cannot be resolved to a %s.", intervalString, COUNTER_RESET_INTERVAL_PROPERTY, "time period"));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("The value '%s' of property '%s' cannot be resolved to a %s.", intervalString, COUNTER_RESET_INTERVAL_PROPERTY, "time period"));
        }
        return tmpInterval * 1000L;
    }

    private static ConcurrentLRUCache<String, TimedCounter> getDumpCounter() {
        int maxDiffErrors = XltProperties.getInstance().getProperty(MAX_DIFFERENT_ERRORS_PROPERTY, 1000);
        if (maxDiffErrors < 10) {
            maxDiffErrors = 10;
        }
        return new ConcurrentLRUCache<String, TimedCounter>(maxDiffErrors * 3);
    }

    public RequestHistory() {
        int historySize = XltProperties.getInstance().getProperty(OUTPUT2DISK_SIZE_PROPERTY, 3);
        if (historySize < 1) {
            XltLogger.runTimeLogger.warn((Object)"com.xceptance.xlt.output2disk.size must be larger than 1, setting 3 as default now.");
            historySize = 3;
        }
        this.pages = new LRUList(historySize);
        this.pendingRequests = new LinkedList<Request>();
        String dumpModeValue = XltProperties.getInstance().getProperty(OUTPUT2DISK_PROPERTY, "onError");
        this.dumpMode = DumpMode.valueFrom(dumpModeValue);
        this.dumpMgr = new DumpMgr();
        this.dumpMgr.setHarExportEnabled(XltProperties.getInstance().getProperty(OUTPUT2DISK_WRITEHAR_PROPERTY, false));
        this.maxDumpCount = XltProperties.getInstance().getProperty(MAX_DUMP_COUNT_PROPERTY, -1);
    }

    public synchronized void add(String name, WebRequest webRequest, WebResponse webResponse, RequestData requestData) {
        ParameterCheckUtils.isNotNull(name, "name");
        ParameterCheckUtils.isNotNull(webRequest, "webRequestSettings");
        if (this.dumpMode != DumpMode.NEVER) {
            if (this.dumpMode == DumpMode.ON_ERROR) {
                this.pendingRequests.add(new Request(name, webRequest, webResponse, requestData));
            } else if (this.dumpMode == DumpMode.ALWAYS) {
                this.dumpMgr.dump(new Request(name, webRequest, webResponse, requestData));
            }
        }
    }

    public void add(LightWeightPage lwPage) {
        Page page = new Page(lwPage.getTimerName(), lwPage);
        this.add(page);
    }

    public void add(String name, HtmlPage htmlPage) {
        ParameterCheckUtils.isNotNull(name, "name");
        Page page = new Page(name, htmlPage);
        this.add(page);
    }

    public void add(ActionInfo actionInfo, byte[] image) {
        ParameterCheckUtils.isNotNull(actionInfo.name, "name");
        Page page = new Page(actionInfo, image);
        this.add(page);
    }

    public void add(String name) {
        ParameterCheckUtils.isNotNull(name, "name");
        Page page = new Page(name);
        this.add(page);
    }

    private synchronized void add(Page page) {
        if (this.dumpMode != DumpMode.NEVER) {
            if (this.dumpMode == DumpMode.ON_ERROR) {
                this.pages.add(page);
                page.getRequests().addAll(this.pendingRequests);
                this.pendingRequests.clear();
            } else if (this.dumpMode == DumpMode.ALWAYS) {
                this.dumpMgr.dump(page);
            }
        }
    }

    public void dumpToDisk() {
        if (this.requestDumpPermission()) {
            this.dump();
        }
    }

    private boolean requestDumpPermission() {
        boolean permissionGranted = false;
        switch (this.dumpMode) {
            case ALWAYS: {
                permissionGranted = true;
                break;
            }
            case ON_ERROR: {
                if (!Session.getCurrent().hasFailed()) break;
                if (this.maxDumpCount < 0) {
                    permissionGranted = true;
                    break;
                }
                if (this.maxDumpCount == 0) {
                    XltLogger.runTimeLogger.warn((Object)("Dump mode is " + (Object)((Object)this.dumpMode) + " but maximum dump count is 0."));
                    break;
                }
                String key = RequestHistory.getErrorKey();
                TimedCounter count = RequestHistory.getErrorCount(key);
                if (count.get() >= this.maxDumpCount) break;
                count.increment();
                permissionGranted = true;
                break;
            }
        }
        return permissionGranted;
    }

    private static String getErrorKey() {
        SessionImpl session = (SessionImpl)Session.getCurrent();
        Throwable t = session.getFailReason();
        String key = t != null ? ThrowableUtils.getMinifiedStackTrace(t) : "";
        key = RegExUtils.removeAll(key, " \\(user: '(.+)', output: '([0-9]+)'\\)");
        key = session.getUserName() + "|" + key;
        key = DigestUtils.md5Hex((String)key);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimedCounter getErrorCount(String key) {
        TimedCounter count = DUMP_COUNT.get(key);
        if (count == null) {
            ConcurrentLRUCache<String, TimedCounter> concurrentLRUCache = DUMP_COUNT;
            synchronized (concurrentLRUCache) {
                count = DUMP_COUNT.get(key);
                if (count == null) {
                    count = new TimedCounter(COUNTER_RESET_INTERVAL);
                    DUMP_COUNT.put(key, count);
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        LinkedList<Request> requestsCopy;
        LinkedList<Page> pagesCopy;
        RequestHistory requestHistory = this;
        synchronized (requestHistory) {
            pagesCopy = new LinkedList<Page>(this.pages);
            requestsCopy = new LinkedList<Request>(this.pendingRequests);
            this.pages.clear();
            this.pendingRequests.clear();
        }
        this.dumpMgr.dumpToDisk(pagesCopy, requestsCopy);
    }

    public synchronized void clear() {
        this.pages.clear();
        this.pendingRequests.clear();
        this.dumpMgr.clear();
    }

    public DumpMode getDumpMode() {
        return this.dumpMode;
    }

    public void setDumpMode(DumpMode dumpMode) {
        this.dumpMode = dumpMode;
    }

    public void setDumpManager(DumpMgr dumpManager) {
        if (dumpManager != null) {
            this.dumpMgr = dumpManager;
        }
    }

    public DumpMgr getDumpManager() {
        return this.dumpMgr;
    }

    public static enum DumpMode {
        NEVER,
        ON_ERROR,
        ALWAYS;


        public static DumpMode valueFrom(String propertyValue) {
            if ("never".equals(propertyValue)) {
                return NEVER;
            }
            if ("onError".equals(propertyValue) || "onErrors".equals(propertyValue)) {
                return ON_ERROR;
            }
            return ALWAYS;
        }
    }
}

