/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.util;

import com.xceptance.common.lang.ThrowableUtils;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.engine.scripting.ScriptCommands;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.scripting.TestContext;
import com.xceptance.xlt.engine.scripting.util.ReplayUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class CommandsInvocationHandler<T>
implements InvocationHandler {
    private static final HashSet<String> SCRIPT_COMMAND_NAMES = CommandsInvocationHandler.determineScriptCommandNames();
    private final Log logger;
    private final T commands;

    public CommandsInvocationHandler(T commands, Log logger) {
        this.commands = commands;
        this.logger = logger;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        SessionImpl.getCurrent().checkState();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof String)) continue;
                args[i] = TestContext.getCurrent().resolve((String)args[i]);
            }
        }
        String commandString = this.getCommandString(method, args);
        boolean isCommand = SCRIPT_COMMAND_NAMES.contains(method.getName());
        try {
            if (isCommand && this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Executing command: " + commandString));
            }
            return this.doInvokeMethod(this.commands, method, args);
        }
        catch (Throwable t) {
            Session.getCurrent().setFailed(true);
            if (isCommand) {
                ThrowableUtils.prefixMessage(t, String.format("Command failed: %s -> ", commandString));
            }
            t.setStackTrace(new Exception().getStackTrace());
            throw t;
        }
    }

    private String getCommandString(Method method, Object[] args) {
        String target = null;
        String value = null;
        if (args != null && args.length > 0) {
            boolean isValueOnly = ReplayUtils.isValueOnlyCommand(method.getName());
            if (args[0] != null) {
                if (isValueOnly) {
                    value = args[0].toString();
                } else {
                    target = args[0].toString();
                }
                if (args.length > 1 && args[1] != null) {
                    value = args[1].toString();
                }
            }
        }
        return String.format("%s target=\"%s\" value=\"%s\"", method.getName(), StringUtils.defaultString(target), StringUtils.defaultString(value));
    }

    protected Object doInvokeMethod(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.commands, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static HashSet<String> determineScriptCommandNames() {
        HashSet<String> names = new HashSet<String>();
        for (Method m : ScriptCommands.class.getDeclaredMethods()) {
            names.add(m.getName());
        }
        return names;
    }

    public T getCommands() {
        return this.commands;
    }

    public Log getLogger() {
        return this.logger;
    }
}

