/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.util;

import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.util.XltLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class ReplayUtils {
    private static final String[] VALUE_ONLY_COMMANDS = new String[]{"assertLoadTime", "assertNotTextPresent", "assertNotTitle", "assertPageSize", "assertTextPresent", "assertTitle", "echo", "open", "pause", "setTimeout", "storeTitle", "waitForTextPresent", "waitForTitle", "waitForNotTextPresent", "waitForNotTitle"};
    private static final String INDEX = "index";
    private static final Pattern INDEX_PATTERN = Pattern.compile(".*?index=(\\d+).*?");
    private static final String INDEX_PREVALUE = "index=";
    private static final String INDEX_REGEX = "index=(\\d+)";
    private static final String NAME = "name";
    private static final Pattern NAME_PATTERN = Pattern.compile("^(\\S+).*?");
    private static final String VALUE = "value";
    private static final Pattern VALUE_PATTERN = Pattern.compile(".*?(value=)?(.*?)");
    private static final Pattern STYLE_ATT_SEMICOLON_REGEXP = Pattern.compile("[;]+(?=(?:(?:[^\"]*\"){2})*[^\"]*$)(?=(?:(?:[^']*'){2})*[^']*$)(?=(?:[^()]*\\([^()]*\\))*[^()]*$)");

    private ReplayUtils() {
    }

    public static String getStandardizedStyle(String styleText) {
        String[] parts = STYLE_ATT_SEMICOLON_REGEXP.split(styleText);
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            int idx = part.indexOf(58);
            if (idx <= 0) continue;
            sb.append(part.substring(0, idx).toLowerCase()).append(':').append(part.substring(idx + 1)).append(';');
        }
        String s = sb.toString();
        if (!s.endsWith(";")) {
            s = s + ";";
        }
        return s;
    }

    public static AttributeLocatorInfo parseAttributeLocator(String attributeLocator) {
        int idx = attributeLocator.lastIndexOf(64);
        String attributeName = null;
        while (RegExUtils.isMatching(attributeName = attributeLocator.substring(idx + 1), "^\\{\\S+\\}")) {
            idx = attributeLocator.lastIndexOf(64, idx - 1);
        }
        return new AttributeLocatorInfo(attributeLocator.substring(0, idx), attributeName.toLowerCase());
    }

    public static Map<String, String> parseAttributes(String input) {
        String value;
        HashMap<String, String> results = new HashMap<String, String>();
        boolean emptyValueExpected = false;
        Matcher m = NAME_PATTERN.matcher(input);
        if (m.matches()) {
            value = m.group(1);
            results.put(NAME, value);
            if (input.length() > value.length()) {
                input = input.substring(value.length() + 1);
                emptyValueExpected = true;
            } else {
                input = input.substring(value.length());
            }
        }
        if ((m = INDEX_PATTERN.matcher(input)).matches()) {
            boolean leadingIndex = false;
            if (input.startsWith(INDEX_PREVALUE)) {
                leadingIndex = true;
                emptyValueExpected = false;
            }
            String value2 = m.group(1);
            results.put(INDEX, value2);
            input = input.replaceFirst(INDEX_REGEX, "");
            if (input.length() > 0) {
                if (leadingIndex) {
                    input = input.substring(1);
                    emptyValueExpected = true;
                } else {
                    input = input.substring(0, input.length() - 1);
                }
            }
        }
        if (input.length() > 0) {
            m = VALUE_PATTERN.matcher(input);
            if (m.matches()) {
                value = m.group(2);
                results.put(VALUE, value);
            }
        } else if (emptyValueExpected) {
            results.put(VALUE, input);
        }
        return results;
    }

    public static Map<String, String> parseStyleString(String style) {
        HashMap<String, String> cssProperties = new HashMap<String, String>();
        String[] parts = STYLE_ATT_SEMICOLON_REGEXP.split(style);
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            int idx = part.indexOf(58);
            if (idx <= 0 || idx >= part.length() - 1) continue;
            cssProperties.put(part.substring(0, idx).toLowerCase(), part.substring(idx + 1).trim());
        }
        return cssProperties;
    }

    public static int[] parseCoordinates(String coordinates) {
        String[] parts;
        if (StringUtils.isNotBlank((CharSequence)coordinates) && (parts = coordinates.split(",")).length == 2) {
            try {
                int x = Integer.parseInt(parts[0].trim());
                int y = Integer.parseInt(parts[1].trim());
                return new int[]{x, y};
            }
            catch (NumberFormatException nfe) {
                XltLogger.runTimeLogger.error((Object)nfe);
            }
        }
        return null;
    }

    public static boolean isValueOnlyCommand(String name) {
        for (String s : VALUE_ONLY_COMMANDS) {
            if (!name.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static class AttributeLocatorInfo {
        private final String elementLocator;
        private final String attributeName;

        private AttributeLocatorInfo(String elementLocator, String attributeName) {
            this.attributeName = attributeName;
            this.elementLocator = elementLocator;
        }

        public String getElementLocator() {
            return this.elementLocator;
        }

        public String getAttributeName() {
            return this.attributeName;
        }
    }
}

