/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.util;

import com.xceptance.xlt.engine.scripting.util.ExactTextMatchingStrategy;
import com.xceptance.xlt.engine.scripting.util.GlobTextMatchingStrategy;
import com.xceptance.xlt.engine.scripting.util.RegExTextMatchingStrategy;
import com.xceptance.xlt.engine.scripting.util.TextMatchingStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextMatchingUtils {
    private static final Pattern NORMALIZE_WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern TEXT_MATCHING_STRATEGY_AND_VALUE_PATTERN = Pattern.compile("^(\\p{Alpha}+):(.*)", 32);
    private static final TextMatchingStrategy DEFAULT_TEXT_MATCHING_STRATEGY = new GlobTextMatchingStrategy();
    private static final Map<String, TextMatchingStrategy> textMatchingStrategies = new HashMap<String, TextMatchingStrategy>();

    public static boolean isAMatch(String text, String pattern, boolean strict, boolean normalizeWhitespace) {
        pattern = normalizeWhitespace ? pattern.trim() : pattern;
        TextMatchingStrategy strategy = null;
        String use = null;
        Matcher matcher = TEXT_MATCHING_STRATEGY_AND_VALUE_PATTERN.matcher(pattern);
        if (matcher.matches()) {
            String strategyName = matcher.group(1);
            use = matcher.group(2);
            strategy = textMatchingStrategies.get(strategyName);
        }
        if (strategy == null) {
            strategy = DEFAULT_TEXT_MATCHING_STRATEGY;
            use = pattern;
        }
        if (normalizeWhitespace) {
            use = TextMatchingUtils.normalizeWhitespace(use);
            text = TextMatchingUtils.normalizeWhitespace(text);
        }
        return strategy.isAMatch(use, text, strict);
    }

    private static String normalizeWhitespace(String s) {
        s = s.replace('\u00a0', ' ');
        s = s.trim();
        return NORMALIZE_WHITESPACE_PATTERN.matcher(s).replaceAll(" ");
    }

    private TextMatchingUtils() {
    }

    static {
        textMatchingStrategies.put("glob", DEFAULT_TEXT_MATCHING_STRATEGY);
        textMatchingStrategies.put("regexp", new RegExTextMatchingStrategy());
        textMatchingStrategies.put("regexpi", new RegExTextMatchingStrategy(true));
        textMatchingStrategies.put("exact", new ExactTextMatchingStrategy());
    }
}

