/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import com.xceptance.common.util.ParseUtils;
import com.xceptance.common.util.PropertiesUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

public final class IncludedFilesResolver {
    static final String PROP_INCLUDE_NAME_PREFIX = "com.xceptance.xlt.propertiesInclude";

    private IncludedFilesResolver() {
    }

    public static List<String> resolveIncludePropertyFiles(List<FileObject> roots, FileObject rootDirectory, boolean ignoreMissing) {
        ArrayList<String> alreadyMarked = new ArrayList<String>();
        ArrayList<String> returnValue = new ArrayList<String>();
        for (int i = 0; i < roots.size(); ++i) {
            FileObject current = roots.get(i);
            IncludedFilesResolver.processFile(current, alreadyMarked, ignoreMissing);
            returnValue.addAll(alreadyMarked);
            alreadyMarked.clear();
        }
        for (String path : returnValue) {
            IncludedFilesResolver.checkPath(path, rootDirectory);
        }
        return returnValue;
    }

    private static void checkPath(String path, FileObject rootDirectory) {
        boolean valid = false;
        try {
            FileObject file;
            FileObject tmp = file = rootDirectory.resolveFile(path);
            while ((tmp = tmp.getParent()) != null) {
                if (!tmp.equals(rootDirectory)) continue;
                valid = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!valid) {
            throw new IllegalStateException("Resolved property file '" + path + "' is located outside of '" + rootDirectory + "'");
        }
    }

    private static void processFile(FileObject file, List<String> alreadyMarked, boolean ignoreMissing) {
        List<FileObject> orderedIncludes;
        IncludedFilesResolver.checkForCyclicInclude(alreadyMarked, file);
        try {
            orderedIncludes = IncludedFilesResolver.getResolvedIncludes(file);
        }
        catch (IllegalStateException ise) {
            if (!ignoreMissing) {
                throw ise;
            }
            return;
        }
        IncludedFilesResolver.add(alreadyMarked, file);
        for (FileObject f : orderedIncludes) {
            IncludedFilesResolver.processFile(f, alreadyMarked, ignoreMissing);
        }
    }

    private static List<FileObject> getResolvedIncludes(FileObject file) {
        FileObject baseDir;
        try {
            if (file.isFolder()) {
                return IncludedFilesResolver.getFilesOrderedByName(file);
            }
        }
        catch (FileSystemException fse) {
            throw new IllegalStateException("Failed to determine type of file: " + file.getName().getPath());
        }
        Properties p = IncludedFilesResolver.getPropertiesFromFile(file);
        ArrayList<FileObject> orderedIncludes = new ArrayList<FileObject>();
        try {
            baseDir = file.getParent();
        }
        catch (FileSystemException fse) {
            throw new IllegalStateException("Failed to retrieve parent of file: " + file.getName().getPath());
        }
        for (String path : IncludedFilesResolver.getOrderedIncludes(p)) {
            try {
                orderedIncludes.add(baseDir.resolveFile(path));
            }
            catch (FileSystemException fse) {
                throw new IllegalStateException(String.format("Failed to resolve '%s' using base directory '%s'", path, file.getName().getPath()));
            }
        }
        return orderedIncludes;
    }

    private static void add(List<String> paths, FileObject file) {
        try {
            FileType type = file.getType();
            if (!type.equals((Object)FileType.FOLDER)) {
                if (!file.getName().getBaseName().endsWith(".properties")) {
                    throw new IllegalStateException("Only files having their name ending with \".properties\" can be included!");
                }
                paths.add(file.getName().getPath());
            }
        }
        catch (FileSystemException fse) {
            throw new IllegalStateException("Failed to determine type of file '" + file.getName().getPath() + "'");
        }
    }

    private static List<FileObject> getFilesOrderedByName(FileObject current) {
        FileObject[] files;
        TreeSet<FileObject> orderedIncludes = new TreeSet<FileObject>();
        try {
            files = current.getChildren();
        }
        catch (FileSystemException fse) {
            throw new IllegalStateException("Failed to get children of directory '" + current.getName().getPath() + "'");
        }
        if (files != null) {
            for (FileObject child : files) {
                try {
                    if (child.isFolder() || !child.getName().getExtension().equals("properties")) continue;
                    orderedIncludes.add(child);
                }
                catch (FileSystemException fse) {
                    throw new IllegalStateException("Failed to determine type of file '" + child.getName().getPath() + "'");
                }
            }
        }
        return new ArrayList<FileObject>(orderedIncludes);
    }

    private static void checkForCyclicInclude(List<String> alreadyMarked, FileObject current) {
        String path = current.getName().getPath();
        if (alreadyMarked.contains(path)) {
            String message = "Cycle for / duplicate included property file detected! Having read files\n" + alreadyMarked + "\nand attempting to reread \"" + path + "\"!";
            throw new RuntimeException(message);
        }
    }

    private static Properties getPropertiesFromFile(FileObject current) throws IllegalStateException {
        try {
            return PropertiesUtils.loadProperties(current);
        }
        catch (IOException e) {
            throw new IllegalStateException("An error occurred while reading file \"" + current.getName().getPath() + "\"! Message: " + e.getMessage());
        }
    }

    private static List<String> getOrderedIncludes(Properties properties) {
        Map<String, String> unsortedIncludes = PropertiesUtils.getPropertiesForKey(PROP_INCLUDE_NAME_PREFIX, properties);
        TreeMap<Integer, String> sortedIncludes = new TreeMap<Integer, String>();
        for (Map.Entry<String, String> entry : unsortedIncludes.entrySet()) {
            int index;
            String key = entry.getKey();
            try {
                index = ParseUtils.parseInt(key);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Failed to parse the suffix '%s' of property '%s' as an integer", key, "com.xceptance.xlt.propertiesInclude." + key));
            }
            sortedIncludes.put(index, entry.getValue());
        }
        return new ArrayList<String>(sortedIncludes.values());
    }
}

