/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.engine.util.CssUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class LWPageUtilities {
    private static final String SCRIPT_PATTERN = "<script\\b[^<>]*?\\ssrc=\\s*?[\"']([^\"']+?)[\"']";
    private static final String LINK_PATTERN = "<link\\b[^<>]*?\\shref=\\s*?[\"']([^\"']+?)[\"']";
    private static final String LINK_ATTRIBUTE_PATTERN = "<link\\b\\s([^<>]+?)>";
    private static final String IMG_PATTERN = "<img\\b[^<>]*?\\ssrc=\\s*?[\"']([^\"']+?)[\"']";
    private static final String IMAGE_INPUT_PATTERN = "<input\\b[^<>]*?\\ssrc=\"([^\"]+?)\"";
    private static final String ANCHOR_PATTERN = "<a\\b[^<>]*?\\shref=\\s*?[\"']([^\"']+?)[\"']";
    private static final String INLINE_CSS_PATTERN = "<[A-Za-z]+?\\b[^<>]*?\\sstyle=\"([^\"]+?)\"";
    private static final String BASE_PATTERN = "<base\\b[^<>]*?\\shref=\"([^\"]+?)\"";
    private static final String FRAME_PATTERN = "<i?frame\\s([^<>]+?)>";
    private static final String STYLE_CONTENT_PATTERN = "<style\\b[^>]*?>((?!</style).*?)</style>";
    private static final String SCRIPT_TAG_PATTERN = "<script\\b.*?(/>|</script>)";
    private static final String BASE_TAG_PATTERN = "<base\\b.*?(></base>|/>|>)";
    private static final String HTML_COMMENT_PATTERN = "(?-m)<!--.*?(-->|$)";

    private LWPageUtilities() {
    }

    public static List<String> getAllInlineCssStatements(String page) {
        return LWPageUtilities.getAllMatches(page, INLINE_CSS_PATTERN, 1);
    }

    public static List<String> getAllBaseLinks(String page) {
        return LWPageUtilities.getAllMatches(page, BASE_PATTERN, 1);
    }

    public static Set<String> getAllInlineCssResourceUrls(String page) {
        return CssUtils.getUrlStrings(StringUtils.join(LWPageUtilities.getAllInlineCssStatements(page), (String)" ") + StringUtils.join(LWPageUtilities.getAllStyleContents(page), (String)" "));
    }

    public static List<String> getAllAnchorLinks(String page) {
        return LWPageUtilities.getAllMatches(page, ANCHOR_PATTERN, 1);
    }

    public static List<String> getAllImageLinks(String page) {
        return LWPageUtilities.getAllMatches(page, IMG_PATTERN, 1);
    }

    public static List<String> getAllImageInputLinks(String page) {
        return LWPageUtilities.getAllMatches(page, IMAGE_INPUT_PATTERN, 1);
    }

    public static List<String> getAllLinkLinks(String page) {
        return LWPageUtilities.getAllMatches(page, LINK_PATTERN, 1);
    }

    public static List<String> getAllLinkAttributes(String page) {
        return LWPageUtilities.getAllMatches(page, LINK_ATTRIBUTE_PATTERN, 1);
    }

    public static List<String> getAllScriptLinks(String page) {
        return LWPageUtilities.getAllMatches(page, SCRIPT_PATTERN, 1);
    }

    public static List<String> getAllFrameAttributes(String page) {
        return LWPageUtilities.getAllMatches(page, FRAME_PATTERN, 1);
    }

    public static String getAttributeValue(String attributes, String attributeName) {
        if (attributes == null || attributeName == null || attributes.length() == 0 || attributeName.length() == 0) {
            return null;
        }
        String attributeValue = RegExUtils.getFirstMatch(attributes, "(?i)" + attributeName + "=\"([^\"]+)\"", 1);
        return attributeValue != null ? attributeValue.trim() : attributeValue;
    }

    public static List<String> getAllStyleContents(String page) {
        return LWPageUtilities.getAllMatches(page, STYLE_CONTENT_PATTERN, 1);
    }

    public static String removeAllBaseTags(String page) {
        return LWPageUtilities.removeAllTags(page, BASE_TAG_PATTERN);
    }

    public static String removeAllScriptTags(String page) {
        return LWPageUtilities.removeAllTags(page, SCRIPT_TAG_PATTERN);
    }

    private static String removeAllTags(String page, String pattern) {
        if (page == null || page.length() == 0) {
            return null;
        }
        return RegExUtils.replaceAll(page, "(?i)" + pattern, "");
    }

    private static List<String> getAllMatches(String page, String pattern, int group) {
        if (page == null || page.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> trimmedMatches = new ArrayList<String>();
        List<String> matches = RegExUtils.getAllMatches(page, "(?is)" + pattern, group);
        for (int i = 0; i < matches.size(); ++i) {
            String s = matches.get(i);
            String trimmed = s.trim();
            if (trimmed.length() <= 0) continue;
            trimmedMatches.add(trimmed);
        }
        return trimmedMatches;
    }

    public static String removeHtmlComments(String page) {
        return RegExUtils.removeAll(page, HTML_COMMENT_PATTERN);
    }
}

