/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeJavaObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.openqa.selenium.ScriptTimeoutException;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriverException;

class AsyncScriptExecutor {
    private final HtmlPage page;
    private final long timeoutMillis;
    private AsyncScriptResult asyncResult;

    AsyncScriptExecutor(HtmlPage page, long timeoutMillis) {
        this.page = page;
        this.timeoutMillis = timeoutMillis;
    }

    void alertTriggered(String message) {
        this.asyncResult.alert(message);
    }

    public Object execute(String scriptBody, Object[] parameters) {
        try {
            this.asyncResult = new AsyncScriptResult();
            Function function = this.createInjectedScriptFunction(scriptBody, this.asyncResult);
            try {
                this.page.executeJavaScriptFunction((Object)function, function, parameters, (DomNode)this.page.getDocumentElement());
            }
            catch (ScriptException e) {
                throw new WebDriverException((Throwable)e);
            }
            try {
                Object e = this.asyncResult.waitForResult(this.timeoutMillis);
                return e;
            }
            catch (InterruptedException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        finally {
            this.asyncResult = null;
        }
    }

    private Function createInjectedScriptFunction(String userScript, AsyncScriptResult asyncResult) {
        String script = "(function() { return function() {  var self = this, timeoutId;  var cleanUp = function() {    window.clearTimeout(timeoutId);    if (window.detachEvent) {      window.detachEvent('onunload', catchUnload);    } else {      window.removeEventListener('unload', catchUnload, false);    }  };  var self = this, timeoutId, catchUnload = function() {    cleanUp();    self.host.unload();  };  arguments = Array.prototype.slice.call(arguments, 0);  arguments.push(function(value) {    cleanUp();    self.host.callback(typeof value == 'undefined' ? null : value);  });  if (window.attachEvent) {    window.attachEvent('onunload', catchUnload);  } else {    window.addEventListener('unload', catchUnload, false);  }  (function() {" + userScript + "}).apply(null, arguments);  timeoutId = window.setTimeout(function() {    self.host.timeout();  }, " + this.timeoutMillis + ");}})();";
        ScriptResult result = this.page.executeJavaScript(script);
        Function function = (Function)result.getJavaScriptResult();
        function.put("host", (Scriptable)function, (Object)new NativeJavaObject((Scriptable)function, (Object)asyncResult, null));
        return function;
    }

    public static class AsyncScriptResult {
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile Object value;
        private volatile boolean isTimeout;
        private volatile String alertMessage;
        private volatile boolean unloadDetected;

        Object waitForResult(long timeoutMillis) throws InterruptedException {
            long startTimeNanos = System.nanoTime();
            this.latch.await();
            if (this.isTimeout) {
                long elapsedTimeNanos = System.nanoTime() - startTimeNanos;
                long elapsedTimeMillis = TimeUnit.NANOSECONDS.toMillis(elapsedTimeNanos);
                throw new ScriptTimeoutException("Timed out waiting for async script result after " + elapsedTimeMillis + "ms");
            }
            if (this.alertMessage != null) {
                throw new UnhandledAlertException("Alert found", this.alertMessage);
            }
            if (this.unloadDetected) {
                throw new WebDriverException("Detected a page unload event; executeAsyncScript does not work across page loads");
            }
            return this.value;
        }

        public void callback(Object callbackValue) {
            if (this.latch.getCount() > 0L) {
                this.value = callbackValue;
                this.latch.countDown();
            }
        }

        public void timeout() {
            if (this.latch.getCount() > 0L) {
                this.isTimeout = true;
                this.latch.countDown();
            }
        }

        private void alert(String message) {
            if (this.latch.getCount() > 0L) {
                this.alertMessage = message;
                this.latch.countDown();
            }
        }

        public void unload() {
            if (this.latch.getCount() > 0L) {
                this.unloadDetected = true;
                this.latch.countDown();
            }
        }
    }
}

