/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver.logging;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConsole;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.Logs;

public class HtmlUnitLogs
implements Logs {
    final HtmlUnitDriverLogger logger = new HtmlUnitDriverLogger();

    public HtmlUnitLogs(WebClient webClient) {
        webClient.getWebConsole().setLogger(this.logger);
    }

    public LogEntries get(String logType) {
        if (logType == "browser") {
            return new LogEntries((Iterable)this.logger.getContentAndFlush());
        }
        return new LogEntries(Collections.emptyList());
    }

    public Set<String> getAvailableLogTypes() {
        return Collections.EMPTY_SET;
    }

    private static class HtmlUnitDriverLogger
    implements WebConsole.Logger {
        private static final int BUFFER_SIZE = 1000;
        private LogEntry[] buffer = new LogEntry[1000];
        private int insertPos = 0;
        private boolean isFull = false;

        private HtmlUnitDriverLogger() {
        }

        private void append(LogEntry entry) {
            this.buffer[this.insertPos] = entry;
            ++this.insertPos;
            if (this.insertPos == 1000) {
                this.insertPos = 0;
                this.isFull = true;
            }
        }

        private List<LogEntry> getContentAndFlush() {
            int i;
            ArrayList<LogEntry> result;
            if (this.isFull) {
                result = new ArrayList<LogEntry>(1000);
                for (i = this.insertPos; i < 1000; ++i) {
                    result.add(this.buffer[i]);
                }
            } else {
                result = new ArrayList(this.insertPos);
            }
            for (i = 0; i < this.insertPos; ++i) {
                result.add(this.buffer[i]);
            }
            this.insertPos = 0;
            this.isFull = false;
            return result;
        }

        @Override
        public void warn(Object message) {
            this.append(new LogEntry(Level.WARNING, System.currentTimeMillis(), message == null ? "" : message.toString()));
        }

        @Override
        public void trace(Object message) {
            this.append(new LogEntry(Level.FINEST, System.currentTimeMillis(), message == null ? "" : message.toString()));
        }

        @Override
        public void info(Object message) {
            this.append(new LogEntry(Level.INFO, System.currentTimeMillis(), message == null ? "" : message.toString()));
        }

        @Override
        public void error(Object message) {
            this.append(new LogEntry(Level.SEVERE, System.currentTimeMillis(), message == null ? "" : message.toString()));
        }

        @Override
        public void debug(Object message) {
            this.append(new LogEntry(Level.FINE, System.currentTimeMillis(), message == null ? "" : message.toString()));
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public boolean isWarnEnabled() {
            return true;
        }

        @Override
        public boolean isErrorEnabled() {
            return true;
        }
    }
}

