/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.agentcontroller.AgentStatus;
import com.xceptance.xlt.agentcontroller.TestResultAmount;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.mastercontroller.AgentControllerStatus;
import com.xceptance.xlt.mastercontroller.AgentControllerUpdate;
import com.xceptance.xlt.mastercontroller.AgentControllersInformation;
import com.xceptance.xlt.mastercontroller.MasterControllerConfiguration;
import com.xceptance.xlt.mastercontroller.MasterControllerUI;
import com.xceptance.xlt.mastercontroller.PingResult;
import com.xceptance.xlt.mastercontroller.ReportCreationType;
import com.xceptance.xlt.mastercontroller.ResultDownloader;
import com.xceptance.xlt.mastercontroller.TestCaseLoadProfileConfiguration;
import com.xceptance.xlt.mastercontroller.TestDeployer;
import com.xceptance.xlt.mastercontroller.TestDeployment;
import com.xceptance.xlt.mastercontroller.TestLoadProfileConfiguration;
import com.xceptance.xlt.report.ReportGenerator;
import com.xceptance.xlt.util.AgentControllerException;
import com.xceptance.xlt.util.ConcurrencyUtils;
import com.xceptance.xlt.util.FailedAgentControllerCollection;
import com.xceptance.xlt.util.FileReplicationIndex;
import com.xceptance.xlt.util.FileReplicationUtils;
import com.xceptance.xlt.util.ProgressBar;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;

public class MasterController {
    private static final Log LOG = LogFactory.getLog(MasterController.class);
    private final Map<String, AgentController> agentControllerMap;
    private final File agentFilesDirectory;
    private TestLoadProfileConfiguration currentLoadProfile;
    private String currentTestCaseName;
    private File currentTestResultsDir;
    private final TestDeployer testDeployer;
    private final File tempDirectory;
    private MasterControllerUI userInterface;
    private String testComment;
    private final String propertiesFileName;
    private final boolean isAgentControllerConnectionRelaxed;
    private final String reportTimezoneId;
    private final boolean isEmbedded;
    private final ThreadPoolExecutor commonExecutor;
    private final ThreadPoolExecutor defaultCommunicationExecutor;
    private final ThreadPoolExecutor uploadExecutor;
    private final ThreadPoolExecutor downloadExecutor;
    private final Map<String, AgentControllerStatus> statuses = new ConcurrentHashMap<String, AgentControllerStatus>();
    private final AtomicBoolean isStatusRequesting = new AtomicBoolean(false);
    private final File testResultsRootDirectory;
    private final File resultOutputDirectory;
    private boolean stoppedByUser = false;
    private boolean compressedTimerFiles = false;

    public MasterController(Map<String, AgentController> agentControllerMap, MasterControllerConfiguration config, String testPropertyFileName, boolean isAgentControllerConnectionRelaxed, String reportTimezoneId) {
        this.agentControllerMap = agentControllerMap;
        this.testDeployer = new TestDeployer(agentControllerMap);
        this.agentFilesDirectory = config.getAgentFilesDirectory();
        this.tempDirectory = config.getTempDirectory();
        this.propertiesFileName = testPropertyFileName;
        this.isAgentControllerConnectionRelaxed = isAgentControllerConnectionRelaxed;
        this.reportTimezoneId = reportTimezoneId;
        int parallelCommunicationLimit = config.getParallelCommunicationLimit();
        int parallelUploadLimit = config.getParallelUploadLimit();
        int parallelDownloadLimit = config.getParallelDownloadLimit();
        this.commonExecutor = ConcurrencyUtils.getNewThreadPoolExecutor("MC-pool");
        this.defaultCommunicationExecutor = ConcurrencyUtils.getNewThreadPoolExecutor("AC-communication-default-pool", parallelCommunicationLimit);
        this.uploadExecutor = ConcurrencyUtils.getNewThreadPoolExecutor("AC-communication-upload-pool", parallelUploadLimit);
        this.downloadExecutor = ConcurrencyUtils.getNewThreadPoolExecutor("AC-communication-download-pool", parallelDownloadLimit);
        this.testResultsRootDirectory = config.getTestResultsRootDirectory();
        this.resultOutputDirectory = config.getResultOutputDirectory();
        this.isEmbedded = config.isEmbedded();
        this.compressedTimerFiles = config.isCompressedTimerFiles();
        this.checkTestPropertiesFileName();
    }

    private void checkTestPropertiesFileName() {
        if (StringUtils.isBlank((CharSequence)this.propertiesFileName)) {
            return;
        }
        if (new File(this.propertiesFileName).isAbsolute()) {
            String msg = "Parameter '%s' is invalid, because its value is not a relative path -> [%s]";
            throw new IllegalArgumentException(String.format("Parameter '%s' is invalid, because its value is not a relative path -> [%s]", "testPropertiesFile", this.propertiesFileName));
        }
        File agentConfDir = new File(this.agentFilesDirectory, "config");
        File testPropFile = new File(agentConfDir, this.propertiesFileName);
        ParameterCheckUtils.isReadableFile(testPropFile, "testPropertiesFile");
        boolean valid = false;
        try {
            valid = FileUtils.directoryContains((File)agentConfDir, (File)testPropFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!valid) {
            String msg = "Parameter '%s' is invalid, because its value does not point to a file inside directory '%s' -> [%s]";
            throw new IllegalArgumentException(String.format("Parameter '%s' is invalid, because its value does not point to a file inside directory '%s' -> [%s]", "testPropertiesFile", agentConfDir.getAbsolutePath(), this.propertiesFileName));
        }
    }

    public boolean downloadTestResults(TestResultAmount testResultAmount) {
        ArrayList<AgentController> agentControllers;
        int agentControllerSize;
        this.currentTestResultsDir = this.resultOutputDirectory;
        if (this.currentTestResultsDir == null) {
            this.currentTestResultsDir = this.getTestResultsDirectory(this.testResultsRootDirectory, this.currentTestCaseName);
        }
        if (!this.stoppedByUser && this.isAnyAgentRunning_SAFE()) {
            String intermediateResultsPath = this.currentTestResultsDir.getPath() + "-intermediate";
            this.currentTestResultsDir = new File(intermediateResultsPath);
        }
        ProgressBar progress = this.startNewProgressBar((agentControllerSize = (agentControllers = new ArrayList<AgentController>(this.agentControllerMap.values())).size()) > 0 ? 7 * agentControllerSize + 4 : 0);
        ResultDownloader resultDownloader = new ResultDownloader(this.downloadExecutor, this.currentTestResultsDir, this.tempDirectory, agentControllers, progress);
        boolean downloadSuccess = resultDownloader.download(testResultAmount, this.compressedTimerFiles);
        FailedAgentControllerCollection failedAgentControllers = resultDownloader.getFailedAgentControllerCollection();
        this.userInterface.testResultsDownloaded(failedAgentControllers);
        return downloadSuccess && (failedAgentControllers.isEmpty() || this.isAgentControllerConnectionRelaxed && failedAgentControllers.getMap().size() < agentControllerSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean generateReport(ReportCreationType reportCreationType) {
        boolean result = false;
        if (this.currentTestResultsDir != null) {
            TimeZone systemTZ = TimeZone.getDefault();
            TimeZone tz = this.reportTimezoneId != null ? TimeZone.getTimeZone(this.reportTimezoneId) : systemTZ;
            boolean overrideTZ = !systemTZ.equals(tz);
            try {
                if (overrideTZ) {
                    TimeZone.setDefault(tz);
                }
                FileObject testResultDir = VFS.getManager().resolveFile(this.currentTestResultsDir.toURI().toString());
                ReportGenerator reportGenerator = new ReportGenerator(testResultDir, null, false);
                if (reportCreationType.equals((Object)ReportCreationType.ALL)) {
                    reportGenerator.generateReport(false);
                    result = true;
                    return result;
                }
                if (!reportCreationType.equals((Object)ReportCreationType.NO_RAMPUP)) return result;
                reportGenerator.generateReport(true);
                result = true;
                return result;
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to generate report from the results in " + this.currentTestResultsDir), (Throwable)ex);
                return result;
            }
            finally {
                if (overrideTZ) {
                    TimeZone.setDefault(systemTZ);
                }
            }
        } else {
            LOG.error((Object)"There are no downloaded results to generate a report from.");
        }
        return result;
    }

    public Map<String, PingResult> pingAgentControllers() {
        final Map<String, PingResult> pingResults = Collections.synchronizedMap(new TreeMap());
        final CountDownLatch latch = new CountDownLatch(this.agentControllerMap.size());
        for (final AgentController agentcontroller : this.agentControllerMap.values()) {
            this.defaultCommunicationExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    PingResult pingResult;
                    try {
                        TimerUtils.setUseHighPrecisionTimer(true);
                        long pingStartTime = TimerUtils.getTime();
                        agentcontroller.ping();
                        long pingTime = TimerUtils.getTime() - pingStartTime;
                        pingResult = new PingResult(pingTime);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to ping agent controller: " + agentcontroller), (Throwable)e);
                        pingResult = new PingResult(e);
                    }
                    pingResults.put(agentcontroller.toString(), pingResult);
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Waiting for ping results to complete has failed", (Throwable)e);
        }
        return pingResults;
    }

    public AgentControllersInformation getAgentControllerInformation() {
        return new AgentControllersInformation(this.agentControllerMap.values(), this.defaultCommunicationExecutor);
    }

    public Set<String> getActiveTestCaseNames() {
        if (this.currentLoadProfile == null) {
            return Collections.emptySet();
        }
        return this.currentLoadProfile.getActiveTestCaseNames();
    }

    public void startAgentStatusList() {
        this.userInterface.receivingAgentStatus();
        this.isStatusRequesting.set(true);
        final HashMap<String, AtomicBoolean> acRequestingStatus = this.getNewAgentControllerRequestingStatusMap();
        this.commonExecutor.execute(new Runnable(){

            @Override
            public void run() {
                while (MasterController.this.isStatusRequesting.get()) {
                    for (final AgentController agentController : MasterController.this.agentControllerMap.values()) {
                        final AtomicBoolean isStillRequesting = (AtomicBoolean)acRequestingStatus.get(agentController.getName());
                        if (isStillRequesting.get()) continue;
                        isStillRequesting.set(true);
                        MasterController.this.defaultCommunicationExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (Thread.currentThread().isInterrupted()) {
                                    return;
                                }
                                try {
                                    LOG.debug((Object)("Getting agent status from " + agentController));
                                    Set<AgentStatus> agentStatuses = agentController.getAgentStatus();
                                    AgentControllerStatus agentControllerStatus = new AgentControllerStatus(agentStatuses);
                                    MasterController.this.statuses.put(agentController.getName(), agentControllerStatus);
                                }
                                catch (Exception e) {
                                    LOG.error((Object)("Failed getting agent status from " + agentController), (Throwable)e);
                                    AgentControllerStatus agentControllerStatus = (AgentControllerStatus)MasterController.this.statuses.get(agentController.getName());
                                    if (agentControllerStatus == null) {
                                        MasterController.this.statuses.put(agentController.getName(), new AgentControllerStatus(e));
                                        agentControllerStatus = (AgentControllerStatus)MasterController.this.statuses.get(agentController.getName());
                                    }
                                    agentControllerStatus.setException(e);
                                }
                                isStillRequesting.set(false);
                            }
                        });
                    }
                    try {
                        Thread.sleep(MasterController.this.userInterface.getStatusListUpdateInterval() * 1000);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
    }

    public TestLoadProfileConfiguration getCurrentLoadProfile() {
        return this.currentLoadProfile;
    }

    private HashMap<String, AtomicBoolean> getNewAgentControllerRequestingStatusMap() {
        HashMap<String, AtomicBoolean> acRequestingStatus = new HashMap<String, AtomicBoolean>();
        for (AgentController agentController : this.agentControllerMap.values()) {
            acRequestingStatus.put(agentController.getName(), new AtomicBoolean(false));
        }
        return acRequestingStatus;
    }

    public void stopAgentStatusList() {
        this.isStatusRequesting.set(false);
    }

    public Set<AgentStatus> getAgentStatusList() {
        ConcurrentLinkedQueue<AgentStatus> allAgentStatuses = new ConcurrentLinkedQueue<AgentStatus>();
        FailedAgentControllerCollection failedAgentcontrollers = new FailedAgentControllerCollection();
        this.userInterface.receivingAgentStatus();
        for (AgentController agentController : this.agentControllerMap.values()) {
            Set<AgentStatus> agentStatuses;
            AgentControllerStatus agentControllerStatus = this.statuses.get(agentController.getName());
            Exception e = agentControllerStatus.getException();
            if (e != null) {
                failedAgentcontrollers.add(agentController, e);
            }
            if ((agentStatuses = agentControllerStatus.getAgentStatuses()) == null) continue;
            for (AgentStatus stat : agentStatuses) {
                allAgentStatuses.add(stat);
            }
        }
        this.userInterface.agentStatusReceived(failedAgentcontrollers);
        return new HashSet<AgentStatus>(allAgentStatuses);
    }

    private TestDeployment getTestDeployment(TestLoadProfileConfiguration loadProfile, String testCaseName) {
        if (testCaseName != null) {
            loadProfile = loadProfile.getTestLoadProfileConfiguration(testCaseName);
        }
        TestDeployment testDeployment = this.testDeployer.createTestDeployment(loadProfile);
        return testDeployment;
    }

    private File getTestResultsDirectory(File testResultsRootDir, String testCaseName) {
        String dirName = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        if (testCaseName != null) {
            dirName = dirName + "-" + testCaseName;
        }
        return new File(testResultsRootDir, dirName);
    }

    public MasterControllerUI getUserInterface() {
        return this.userInterface;
    }

    public void checkAlive() throws AgentControllerException {
        LOG.debug((Object)"Check if agents are alive");
        Map<AgentController, Future<Boolean>> agentFutures = this.getAgentRunningState();
        FailedAgentControllerCollection failed = new FailedAgentControllerCollection();
        for (Map.Entry<AgentController, Future<Boolean>> agentFuture : agentFutures.entrySet()) {
            try {
                agentFuture.getValue().get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                failed.add(agentFuture.getKey(), e);
                LOG.error((Object)("Agentcontroller is not alive: " + agentFuture.getKey()));
            }
        }
        this.checkSuccess(failed, true);
    }

    private Map<AgentController, Future<Boolean>> getAgentRunningState() {
        final CountDownLatch latch = new CountDownLatch(this.agentControllerMap.size());
        HashMap<AgentController, Future<Boolean>> agentFutures = new HashMap<AgentController, Future<Boolean>>();
        for (final AgentController agentcontroller : this.agentControllerMap.values()) {
            agentFutures.put(agentcontroller, this.defaultCommunicationExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    boolean hasRunningAgent;
                    try {
                        hasRunningAgent = agentcontroller.hasRunningAgent();
                    }
                    finally {
                        latch.countDown();
                    }
                    return hasRunningAgent;
                }
            }));
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Waiting for agents running check to complete has failed", (Throwable)e);
        }
        return agentFutures;
    }

    public boolean isAnyAgentRunning() throws AgentControllerException {
        FailedAgentControllerCollection failedAgentControllers = new FailedAgentControllerCollection();
        Map<AgentController, Future<Boolean>> agentFutures = this.getAgentRunningState();
        AtomicBoolean result = new AtomicBoolean();
        for (Map.Entry<AgentController, Future<Boolean>> agentFuture : agentFutures.entrySet()) {
            try {
                if (!agentFuture.getValue().get().booleanValue()) continue;
                result.set(true);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                failedAgentControllers.add(agentFuture.getKey(), e);
            }
        }
        this.checkSuccess(failedAgentControllers, true);
        return result.get();
    }

    public boolean isAnyAgentRunning_SAFE() {
        Map<AgentController, Future<Boolean>> agentFutures = this.getAgentRunningState();
        for (Map.Entry<AgentController, Future<Boolean>> agentFuture : agentFutures.entrySet()) {
            try {
                if (!agentFuture.getValue().get().booleanValue()) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public boolean areAgentsInSync() {
        return this.currentLoadProfile != null && this.currentLoadProfile.getActiveTestCaseNames().size() > 0;
    }

    public void setUserInterface(MasterControllerUI userInterface) {
        this.userInterface = userInterface;
    }

    public boolean startAgents(String testCaseName) throws AgentControllerException {
        boolean operationCompleted;
        if (this.currentLoadProfile == null) {
            LOG.error((Object)"No files have been uploaded yet.");
            return false;
        }
        this.resetAgentStatuses();
        this.currentTestCaseName = testCaseName;
        final TestDeployment testDeployment = this.getTestDeployment(this.currentLoadProfile, this.currentTestCaseName);
        final FailedAgentControllerCollection failedAgentcontrollers = new FailedAgentControllerCollection();
        int agentControllerSize = this.agentControllerMap.size();
        final CountDownLatch latch = new CountDownLatch(agentControllerSize);
        final ProgressBar progress = this.startNewProgressBar(agentControllerSize);
        for (final AgentController agentController : this.agentControllerMap.values()) {
            this.defaultCommunicationExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Map<String, List<TestUserConfiguration>> agentControllerLoadProfile = testDeployment.getAgentsUserList(agentController);
                        if (agentControllerLoadProfile == null || agentControllerLoadProfile.isEmpty()) {
                            LOG.info((Object)("No need to start agents at " + agentController));
                        } else {
                            agentController.setReferenceTime(System.currentTimeMillis());
                            LOG.info((Object)("Starting agents at " + agentController));
                            agentController.startAgents(agentControllerLoadProfile);
                        }
                    }
                    catch (Exception ex) {
                        failedAgentcontrollers.add(agentController, ex);
                        LOG.error((Object)("Failed starting agents at " + agentController), (Throwable)ex);
                    }
                    progress.increaseCount();
                    latch.countDown();
                }
            });
        }
        boolean finished = true;
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Waiting for agent to start failed", (Throwable)e);
            finished = false;
        }
        this.checkSuccess(failedAgentcontrollers, true);
        this.userInterface.agentsStarted();
        boolean bl = operationCompleted = finished && (failedAgentcontrollers.isEmpty() || this.isAgentControllerConnectionRelaxed && failedAgentcontrollers.getMap().size() < agentControllerSize);
        if (operationCompleted) {
            this.stoppedByUser = false;
        }
        return operationCompleted;
    }

    public boolean stopAgents() throws AgentControllerException {
        boolean operationCompleted;
        final FailedAgentControllerCollection failedAgentcontrollers = new FailedAgentControllerCollection();
        int agentControllerSize = this.agentControllerMap.size();
        final CountDownLatch latch = new CountDownLatch(agentControllerSize);
        final ProgressBar progress = this.startNewProgressBar(agentControllerSize);
        for (final AgentController agentController : this.agentControllerMap.values()) {
            this.defaultCommunicationExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    LOG.info((Object)("Stopping agents at " + agentController));
                    try {
                        agentController.stopAgents();
                    }
                    catch (Exception ex) {
                        failedAgentcontrollers.add(agentController, ex);
                        LOG.error((Object)("Failed stopping agent at " + agentController), (Throwable)ex);
                    }
                    progress.increaseCount();
                    latch.countDown();
                }
            });
        }
        boolean finished = true;
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            finished = false;
        }
        this.checkSuccess(failedAgentcontrollers, false);
        this.userInterface.agentsStopped();
        boolean bl = operationCompleted = finished && (failedAgentcontrollers.isEmpty() || this.isAgentControllerConnectionRelaxed && failedAgentcontrollers.getMap().size() < agentControllerSize);
        if (operationCompleted) {
            this.stoppedByUser = true;
        }
        return operationCompleted;
    }

    public void updateAgentFiles() throws AgentControllerException, IOException, IllegalStateException {
        System.out.print("    Preparing:");
        ProgressBar progressPrepare = this.startNewProgressBar(this.agentControllerMap.size() + 7);
        LOG.info((Object)"Cleanup");
        this.resetAgentStatuses();
        progressPrepare.increaseCount();
        LOG.info((Object)"Read target test suite");
        FileFilter fileFilter = this.getFileFilter();
        File workDir = this.setUpWorkDir(fileFilter);
        progressPrepare.increaseCount();
        File agentTemplateConfigDir = new File(workDir, "config");
        this.currentLoadProfile = this.getTestProfile(agentTemplateConfigDir);
        progressPrepare.increaseCount();
        progressPrepare.increaseCount();
        if (this.currentLoadProfile.getActiveTestCaseNames().size() <= 0) {
            String msg = "No test case configured.";
            XltLogger.runTimeLogger.warn((Object)"No test case configured.");
            throw new IllegalStateException("No test case configured.");
        }
        progressPrepare.increaseCount();
        LOG.info((Object)("Considering files in '" + workDir + "' for upload ..."));
        FileReplicationIndex localIndex = FileReplicationUtils.getIndex(workDir, fileFilter);
        progressPrepare.increaseCount();
        AgentControllerUpdate updater = new AgentControllerUpdate(this.agentControllerMap.values(), this.uploadExecutor, this.downloadExecutor, this.tempDirectory);
        updater.prepare(progressPrepare);
        System.out.println("- OK");
        System.out.print("    Uploading:");
        ProgressBar progressUpload = this.startNewProgressBar(4 * this.agentControllerMap.size() + 1);
        updater.update(workDir, localIndex, progressUpload);
        LOG.info((Object)"Clean up");
        if (workDir != this.agentFilesDirectory) {
            FileUtils.deleteQuietly((File)workDir);
        }
        progressUpload.increaseCount();
        this.checkSuccess(updater.getFailedAgentControllers(), true);
        this.userInterface.agentFilesUploaded();
    }

    private File setUpWorkDir(FileFilter fileFilter) {
        File workDir;
        if (StringUtils.isBlank((CharSequence)this.propertiesFileName)) {
            workDir = this.agentFilesDirectory;
        } else {
            try {
                workDir = File.createTempFile("xlt-", "", this.tempDirectory);
                FileUtils.forceDelete((File)workDir);
                FileUtils.forceMkdir((File)workDir);
                FileUtils.copyDirectory((File)this.agentFilesDirectory, (File)workDir, (FileFilter)fileFilter);
                File projectPropertiesFile = new File(new File(workDir, "config"), "project.properties");
                PropertiesConfiguration config = new PropertiesConfiguration();
                config.setIOFactory((PropertiesConfiguration.IOFactory)new PropertiesConfiguration.JupIOFactory());
                FileHandler fileHandler = new FileHandler((FileBased)config);
                fileHandler.load(projectPropertiesFile);
                config.setProperty("com.xceptance.xlt.testPropertiesFile", (Object)this.propertiesFileName);
                fileHandler.save(projectPropertiesFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to make a copy of the agent files", e);
            }
        }
        return workDir;
    }

    private FileFilter getFileFilter() {
        IOFileFilter visibleFiles = HiddenFileFilter.VISIBLE;
        IOFileFilter notResults = FileFilterUtils.notFileFilter((IOFileFilter)new NameFileFilter("results"));
        return FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{visibleFiles, notResults});
    }

    private TestLoadProfileConfiguration getTestProfile(File agentTemplateConfigDir) throws IOException {
        FileObject testPropertiesFile;
        TestLoadProfileConfiguration testConfig;
        try {
            testConfig = new TestLoadProfileConfiguration(agentTemplateConfigDir.getParentFile(), agentTemplateConfigDir);
            this.postProcessLoadProfile(testConfig);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Load profile configuration failed using directory: '" + agentTemplateConfigDir + "'. " + MasterController.getDetailedMessage(ex), ex);
        }
        String testPropertiesFileName = testConfig.getProperties().getProperty("com.xceptance.xlt.testPropertiesFile");
        if (!(!StringUtils.isNotBlank((CharSequence)testPropertiesFileName) || (testPropertiesFile = VFS.getManager().resolveFile(agentTemplateConfigDir, testPropertiesFileName)).exists() && testPropertiesFile.isFile() && testPropertiesFile.isReadable())) {
            throw new IOException("Unable to load test properties file.");
        }
        return testConfig;
    }

    protected static String getDetailedMessage(Throwable throwable) {
        LinkedList<String> messages = new LinkedList<String>();
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            String msg = t.getMessage();
            if (msg == null) continue;
            messages.add(msg);
        }
        return StringUtils.join(messages, (String)" :: ");
    }

    void setTestComment(String comment) {
        this.testComment = comment != null ? comment.trim() : null;
        LOG.debug((Object)("Test comment set to: " + StringUtils.defaultString((String)comment, (String)"<NULL>")));
    }

    File getCurrentTestResultsDirectory() {
        return this.currentTestResultsDir;
    }

    public String getTestComment() {
        return this.testComment;
    }

    void setTestComment4DownloadedResults() {
        if (StringUtils.isBlank((CharSequence)this.getTestComment())) {
            return;
        }
        File testPropFile = MasterController.getTestPropertyFile(this.currentTestResultsDir);
        List lines = null;
        try {
            if (testPropFile != null && testPropFile.exists()) {
                lines = FileUtils.readLines((File)testPropFile, (Charset)StandardCharsets.ISO_8859_1);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to read content of file '" + testPropFile.getAbsolutePath() + "'."), (Throwable)ex);
        }
        if (lines == null) {
            return;
        }
        ArrayList<String> outLines = new ArrayList<String>();
        for (Object o : lines) {
            String s = (String)o;
            outLines.add(s);
        }
        outLines.add("");
        outLines.add("# Command line comment (AUTOMATICALLY INSERTED)");
        outLines.add("com.xceptance.xlt.loadtests.comment.commandLine = " + this.getTestComment());
        try {
            FileUtils.writeLines((File)testPropFile, outLines);
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to write content to file '" + testPropFile.getAbsolutePath() + "'."), (Throwable)ex);
        }
    }

    public String getTestCommentPropertyValue() {
        try {
            FileSystemManager fsMgr = VFS.getManager();
            XltPropertiesImpl props = new XltPropertiesImpl(fsMgr.resolveFile(this.currentTestResultsDir.getAbsolutePath()), fsMgr.resolveFile(MasterController.getConfigDir(this.currentTestResultsDir).getAbsolutePath()), true);
            String testCommentPropValue = ((XltProperties)props).getProperty("com.xceptance.xlt.loadtests.comment");
            return testCommentPropValue;
        }
        catch (FileSystemException fse) {
            LOG.error((Object)("Failed to read/parse test configuration from '" + this.currentTestResultsDir + "'"));
            return null;
        }
    }

    public static File getTestPropertyFile(File testResultsDir) {
        try {
            FileSystemManager fsMgr = VFS.getManager();
            File confDir = MasterController.getConfigDir(testResultsDir);
            XltPropertiesImpl props = new XltPropertiesImpl(fsMgr.resolveFile(testResultsDir.getAbsolutePath()), fsMgr.resolveFile(confDir.getAbsolutePath()), true);
            String testPropFileName = ((XltProperties)props).getProperty("com.xceptance.xlt.testPropertiesFile", "test.properties");
            return new File(confDir, testPropFileName);
        }
        catch (FileSystemException fse) {
            LOG.error((Object)("Failed to read/parse test configuration from '" + testResultsDir + "'"));
            return null;
        }
    }

    public void shutdown() {
        this.defaultCommunicationExecutor.shutdownNow();
        this.uploadExecutor.shutdownNow();
        this.downloadExecutor.shutdownNow();
    }

    public void init() {
        for (AgentController agentController : this.agentControllerMap.values()) {
            this.statuses.put(agentController.getName(), new AgentControllerStatus((Exception)null));
        }
    }

    private ProgressBar startNewProgressBar(int total) {
        ProgressBar progress = new ProgressBar(total);
        System.out.print("    ");
        progress.start();
        return progress;
    }

    private void resetAgentStatuses() throws AgentControllerException {
        final FailedAgentControllerCollection failedAgentControllers = new FailedAgentControllerCollection();
        final CountDownLatch latch = new CountDownLatch(this.agentControllerMap.size());
        for (final AgentController agentController : this.agentControllerMap.values()) {
            this.defaultCommunicationExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Exception ex = null;
                    try {
                        agentController.resetAgentsStatus();
                    }
                    catch (Exception e) {
                        ex = e;
                        failedAgentControllers.add(agentController, e);
                    }
                    MasterController.this.statuses.put(agentController.getName(), new AgentControllerStatus(ex));
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Waiting for resetting agent status to complete has failed");
        }
        this.checkSuccess(failedAgentControllers, true);
    }

    private void checkSuccess(FailedAgentControllerCollection failedAgentControllers, boolean keepLivingAgentControllersOnly) throws AgentControllerException {
        if (failedAgentControllers != null && !failedAgentControllers.isEmpty()) {
            if (this.isAgentControllerConnectionRelaxed) {
                this.userInterface.skipAgentControllerConnections(failedAgentControllers);
                if (keepLivingAgentControllersOnly) {
                    for (AgentController ac : failedAgentControllers.getAgentControllers()) {
                        this.agentControllerMap.remove(ac.getName());
                    }
                }
                if (this.agentControllerMap.isEmpty()) {
                    throw new IllegalStateException("No living AgentController left.");
                }
            } else {
                throw new AgentControllerException(failedAgentControllers);
            }
        }
    }

    private static File getConfigDir(File inputDir) {
        File configDir = new File(inputDir, "config");
        if (configDir != null && configDir.exists() && configDir.canRead() && configDir.isDirectory()) {
            return configDir;
        }
        return inputDir;
    }

    private void postProcessLoadProfile(TestLoadProfileConfiguration loadProfile) {
        boolean haveCPTests = false;
        boolean haveLoadTests = false;
        for (TestCaseLoadProfileConfiguration testConfig : loadProfile.getLoadTestConfiguration()) {
            haveCPTests = haveCPTests || testConfig.isCPTest();
            boolean bl = haveLoadTests = haveLoadTests || !testConfig.isCPTest();
            if (!this.isEmbedded) continue;
            testConfig.setCPTest(false);
        }
        if (!this.isEmbedded) {
            boolean haveLoadAC;
            int acCount = this.agentControllerMap.size();
            int nbCPACs = 0;
            for (AgentController ac : this.agentControllerMap.values()) {
                if (!ac.runsClientPerformanceTests()) continue;
                ++nbCPACs;
            }
            int diff = acCount - nbCPACs;
            boolean haveCPAC = diff != acCount;
            boolean bl = haveLoadAC = diff > 0;
            if (haveCPTests && !haveCPAC) {
                throw new IllegalArgumentException("There is at least one client-performance test configured but no agent controller capable to run client-performance tests could be found.");
            }
            if (haveLoadTests && !haveLoadAC) {
                throw new IllegalArgumentException("There is at least one load/performance test configured but no agent controller capable to run load/performance tests could be found.");
            }
        }
    }
}

