/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestDeployment {
    private final Map<String, List<TestUserConfiguration>> testDeployment = new HashMap<String, List<TestUserConfiguration>>();

    public TestDeployment(Collection<String> agentIDs) {
        for (String agentID : agentIDs) {
            this.testDeployment.put(agentID, new ArrayList());
        }
    }

    public List<TestUserConfiguration> getUserList(String agentID) {
        return this.testDeployment.get(agentID);
    }

    public Map<String, List<TestUserConfiguration>> getAgentsUserList(AgentController agentController) {
        HashMap<String, List<TestUserConfiguration>> result = new HashMap<String, List<TestUserConfiguration>>();
        if (agentController != null) {
            Set<String> agentIDs = agentController.getAgentIDs();
            for (String agentID : agentIDs) {
                List<TestUserConfiguration> agentUserList = this.testDeployment.get(agentID);
                result.put(agentID, agentUserList);
            }
        }
        return result;
    }

    public Collection<List<TestUserConfiguration>> getAllUserLists() {
        return this.testDeployment.values();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (String agentID : this.testDeployment.keySet()) {
            buf.append(agentID).append('\n');
            List<TestUserConfiguration> userList = this.testDeployment.get(agentID);
            for (TestUserConfiguration user : userList) {
                buf.append("- ").append(user).append('\n');
            }
        }
        return buf.toString();
    }

    public Set<String> getAgentIDs() {
        return this.testDeployment.keySet();
    }
}

