/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.ReportProvider;
import com.xceptance.xlt.report.Dispatcher;
import com.xceptance.xlt.report.LogReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DataRecordProcessor
implements Runnable {
    private static final Log LOG = LogFactory.getLog(LogReader.class);
    private final Dispatcher dispatcher;
    private long maximumTime;
    private long minimumTime;
    private final ReportProvider[] reportProviders;

    public DataRecordProcessor(List<ReportProvider> reportProviders, Dispatcher dispatcher) {
        this.reportProviders = reportProviders.toArray(new ReportProvider[0]);
        this.dispatcher = dispatcher;
        this.maximumTime = 0L;
        this.minimumTime = Long.MAX_VALUE;
    }

    public final long getMaximumTime() {
        return this.maximumTime;
    }

    public final long getMinimumTime() {
        return this.minimumTime == Long.MAX_VALUE ? 0L : this.minimumTime;
    }

    @Override
    public void run() {
        ForkJoinPool pool = new ForkJoinPool(4);
        try {
            while (true) {
                List<Data> dataRecords = this.dispatcher.getNextParsedDataRecordChunk();
                ArrayList<Future> tasks = new ArrayList<Future>(this.reportProviders.length);
                for (int i = 0; i < this.reportProviders.length; ++i) {
                    ReportProvider reportProvider = this.reportProviders[i];
                    Future task = pool.submit(() -> this.processDataRecords(reportProvider, dataRecords));
                    tasks.add(task);
                }
                this.maintainStatistics(dataRecords);
                tasks.forEach(t -> t.quietlyJoin());
                this.dispatcher.finishedProcessing();
            }
        }
        catch (InterruptedException e) {
            pool.shutdown();
            try {
                pool.awaitTermination(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    private void processDataRecords(ReportProvider reportProvider, List<Data> data) {
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            try {
                reportProvider.processDataRecord(data.get(i));
                continue;
            }
            catch (Throwable t) {
                LOG.warn((Object)"Failed to process data record", t);
                System.err.println("\nFailed to process data record: " + t);
            }
        }
    }

    private void maintainStatistics(List<Data> data) {
        long min = this.minimumTime;
        long max = this.maximumTime;
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            long time = data.get(i).getTime();
            min = Math.min(min, time);
            max = Math.max(max, time);
        }
        this.minimumTime = Math.min(this.minimumTime, min);
        this.maximumTime = Math.max(this.maximumTime, max);
    }
}

