/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.common.util.StringMatcher;
import com.xceptance.common.util.concurrent.DaemonThreadFactory;
import com.xceptance.xlt.api.report.ReportProvider;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.report.DataRecordFactory;
import com.xceptance.xlt.report.DataRecordParser;
import com.xceptance.xlt.report.DataRecordProcessor;
import com.xceptance.xlt.report.DataRecordReader;
import com.xceptance.xlt.report.Dispatcher;
import com.xceptance.xlt.report.mergerules.RequestProcessingRule;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;

public class LogReader {
    private static final Log LOG = LogFactory.getLog(LogReader.class);
    private final ExecutorService dataRecordParserExecutor;
    private final DataRecordProcessor dataRecordProcessor;
    private final Thread dataRecordProcessorThread;
    private final ExecutorService dataRecordReaderExecutor;
    private final Dispatcher dispatcher;
    private final FileObject inputDir;
    private final AtomicInteger totalLinesCounter;
    private final StringMatcher testCaseFilter;
    private final StringMatcher agentFilter;

    public LogReader(FileObject inputDir, DataRecordFactory dataRecordFactory, long fromTime, long toTime, List<ReportProvider> reportProviders, List<RequestProcessingRule> requestMergeRules, int maxThreadCount, String testCaseIncludePatternList, String testCaseExcludePatternList, String agentIncludePatternList, String agentExcludePatternList, boolean removeIndexesFromRequestNames) {
        int maxActiveThreadCount;
        int parserThreadCount;
        this.inputDir = inputDir;
        this.totalLinesCounter = new AtomicInteger();
        this.testCaseFilter = new StringMatcher(testCaseIncludePatternList, testCaseExcludePatternList, true);
        this.agentFilter = new StringMatcher(agentIncludePatternList, agentExcludePatternList, true);
        int cpuCount = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        int readerThreadCount = 2;
        if (maxThreadCount < cpuCount) {
            parserThreadCount = maxThreadCount;
            maxActiveThreadCount = maxThreadCount;
        } else {
            parserThreadCount = cpuCount;
            maxActiveThreadCount = cpuCount + 2;
        }
        this.dispatcher = new Dispatcher(maxActiveThreadCount);
        this.dataRecordReaderExecutor = Executors.newFixedThreadPool(2, new DaemonThreadFactory("DataRecordReader-"));
        this.dataRecordParserExecutor = Executors.newFixedThreadPool(parserThreadCount, new DaemonThreadFactory("DataRecordParser-"));
        for (int i = 0; i < parserThreadCount; ++i) {
            this.dataRecordParserExecutor.execute(new DataRecordParser(dataRecordFactory, fromTime, toTime, requestMergeRules, this.dispatcher, removeIndexesFromRequestNames));
        }
        this.dataRecordProcessor = new DataRecordProcessor(reportProviders, this.dispatcher);
        this.dataRecordProcessorThread = new Thread((Runnable)this.dataRecordProcessor, "DataRecordProcessor");
        this.dataRecordProcessorThread.setDaemon(true);
        this.dataRecordProcessorThread.start();
    }

    public final long getMaximumTime() {
        return this.dataRecordProcessor.getMaximumTime();
    }

    public final long getMinimumTime() {
        return this.dataRecordProcessor.getMinimumTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDataRecords() {
        try {
            long start = TimerUtils.getTime();
            for (FileObject file : this.inputDir.getChildren()) {
                String directoryName;
                if (file.getType() != FileType.FOLDER || !this.agentFilter.isAccepted(directoryName = file.getName().getBaseName())) continue;
                this.readDataRecordsFromAgentDir(file);
            }
            this.dispatcher.waitForDataRecordProcessingToComplete();
            System.out.printf("Data records read: %,d (%,d ms)\n", this.totalLinesCounter.get(), TimerUtils.getTime() - start);
        }
        catch (Exception e) {
            System.out.println("Failed to read data records: " + e.getMessage());
            LOG.error((Object)"Failed to read data records", (Throwable)e);
        }
        finally {
            this.dataRecordProcessorThread.interrupt();
            this.dataRecordParserExecutor.shutdownNow();
            this.dataRecordReaderExecutor.shutdownNow();
        }
    }

    private void readDataRecordsFromAgentDir(FileObject agentDir) throws Exception {
        for (FileObject file : agentDir.getChildren()) {
            String directoryName;
            if (file.getType() != FileType.FOLDER || !this.isSpecialDirectory(directoryName = file.getName().getBaseName()) && !this.testCaseFilter.isAccepted(directoryName)) continue;
            this.readDataRecordsFromTestCaseDir(file, agentDir.getName().getBaseName());
        }
    }

    private void readDataRecordsFromTestCaseDir(FileObject testCaseDir, String agentName) throws Exception {
        String testCaseName = testCaseDir.getName().getBaseName();
        for (FileObject file : testCaseDir.getChildren()) {
            if (file.getType() != FileType.FOLDER) continue;
            this.readDataRecordsFromTestUserDir(file, agentName, testCaseName);
        }
    }

    private void readDataRecordsFromTestUserDir(FileObject testUserDir, String agentName, String testCaseName) throws Exception {
        this.dispatcher.addDirectory();
        String userNumber = testUserDir.getName().getBaseName();
        DataRecordReader reader = new DataRecordReader(testUserDir, agentName, testCaseName, userNumber, this.totalLinesCounter, this.dispatcher);
        this.dataRecordReaderExecutor.execute(reader);
    }

    private boolean isSpecialDirectory(String directoryName) {
        return "CustomSampler".equals(directoryName) || "Agent-JVM-Monitor".equals(directoryName);
    }
}

