/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.common.util.ProductInformation;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.ReportProvider;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.mastercontroller.TestLoadProfileConfiguration;
import com.xceptance.xlt.report.DataRecordFactory;
import com.xceptance.xlt.report.LogReader;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.ReportTransformer;
import com.xceptance.xlt.report.XmlReportGenerator;
import com.xceptance.xlt.report.external.ExternalReportGenerator;
import com.xceptance.xlt.report.util.ConcurrentUsersTable;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.ReportUtils;
import com.xceptance.xlt.report.util.TaskManager;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;

public class ReportGenerator {
    private final ReportGeneratorConfiguration config;
    private final FileObject inputDir;
    private final File outputDir;
    private final List<ReportProvider> reportProviders;
    private final ExternalReportGenerator repGen;
    private final String testCaseIncludePatternList;
    private final String testCaseExcludePatternList;
    private final String agentIncludePatternList;
    private final String agentExcludePatternList;
    private final List<String> resolvedPropertyFiles;

    public ReportGenerator(FileObject inputDir, File outputDir, boolean noCharts) throws Exception {
        this(inputDir, outputDir, noCharts, false, null, null, null, null, null, null);
    }

    public ReportGenerator(FileObject inputDir, File outputDir, boolean noCharts, boolean noAgentCharts, File overridePropertyFile, Properties commandLineProperties, String testCaseIncludePatternList, String testCaseExcludePatternList, String agentIncludePatternList, String agentExcludePatternList) throws Exception {
        XltPropertiesImpl props;
        FileObject configDir = inputDir.resolveFile("config");
        try {
            props = new XltPropertiesImpl(inputDir, configDir, false);
        }
        catch (Exception e) {
            System.err.println("\n  WARNING: One or more configuration files seem to be missing or corrupt!\n");
            props = new XltPropertiesImpl(inputDir, configDir, true);
        }
        this.config = new ReportGeneratorConfiguration(props.getProperties(), overridePropertyFile, commandLineProperties);
        this.resolvedPropertyFiles = new ArrayList<String>(props.getResolvedPropertyFiles());
        this.testCaseIncludePatternList = testCaseIncludePatternList;
        this.testCaseExcludePatternList = testCaseExcludePatternList;
        this.agentIncludePatternList = agentIncludePatternList;
        this.agentExcludePatternList = agentExcludePatternList;
        if (noCharts) {
            this.config.disableChartsGeneration();
        }
        if (noAgentCharts) {
            this.config.disableAgentCharts();
        }
        this.inputDir = inputDir;
        this.config.setResultsDirectory(this.inputDir);
        String resultsDirectoryName = this.getResultsDirName(inputDir);
        this.config.setResultsDirectoryName(resultsDirectoryName);
        this.outputDir = outputDir == null ? new File(this.config.getTestReportsRootDirectory(), resultsDirectoryName) : outputDir;
        this.config.setReportDirectory(this.outputDir);
        TaskManager.getInstance().setMaximumThreadCount(this.config.getThreadCount());
        JFreeChartUtils.setPngCompressionLevel(this.config.getChartCompressionLevel());
        this.reportProviders = new ArrayList<ReportProvider>();
        for (Class<? extends ReportProvider> c : this.config.getReportProviderClasses()) {
            try {
                ReportProvider processor = c.newInstance();
                processor.setConfiguration(this.config);
                this.reportProviders.add(processor);
            }
            catch (Throwable t) {
                String message = String.format("Failed to instantiate and initialize report provider instance of class '%s': %s'", c.getCanonicalName(), t.getMessage());
                XltLogger.runTimeLogger.error((Object)message, t);
                System.err.println(message);
            }
        }
        this.repGen = new ExternalReportGenerator();
    }

    public void generateReport(boolean noRampUp) throws Exception {
        this.generateReport(0L, Long.MAX_VALUE, -1L, noRampUp, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(long fromTime, long toTime, long duration, boolean noRampUp, boolean fromTimeRel, boolean toTimeRel) throws Exception {
        try {
            FileUtils.forceMkdir((File)this.outputDir);
            FileUtils.cleanDirectory((File)this.outputDir);
            System.out.printf("Reading files from input directory '%s' ...%n", this.inputDir);
            this.readLogs(fromTime, toTime, duration, noRampUp, fromTimeRel, toTimeRel);
            System.out.printf("%nCreating report artifacts ...%n", new Object[0]);
            File xmlReport = this.createReport(this.outputDir);
            System.out.printf("Transforming XML data file '%s' ...%n", xmlReport);
            this.transformReport(xmlReport, this.outputDir);
            File reportFile = new File(this.outputDir, "index.html");
            String reportPath = ReportUtils.toString(reportFile);
            System.out.println("\nReport: " + reportPath);
        }
        finally {
            ConcurrentUsersTable.getInstance().clear();
        }
    }

    public void readLogs(long fromTime, long toTime, long duration, boolean noRampUp, boolean fromTimeRel, boolean toTimeRel) {
        long testStartTime = this.config.getLongProperty("com.xceptance.xlt.loadtest.start", 0L);
        long elapsedTime = this.config.getLongProperty("com.xceptance.xlt.loadtest.elapsed", 0L);
        long[] timeBoundaries = this.getTimeBoundaries(fromTime, toTime, duration, noRampUp, fromTimeRel, toTimeRel, testStartTime, elapsedTime);
        fromTime = timeBoundaries[0];
        toTime = timeBoundaries[1];
        this.printStartAndEndTime(fromTime, toTime);
        if (toTime <= fromTime) {
            throw new IllegalArgumentException("Specified start must not be after specified end.");
        }
        this.read(fromTime, toTime);
    }

    private long[] getTimeBoundaries(long fromTime, long toTime, long duration, boolean noRampUp, boolean fromTimeRel, boolean toTimeRel, long testStartDate, long elapsedTime) {
        if (fromTimeRel) {
            fromTime = this.recalculateOffsetTimeValue(fromTime, testStartDate, elapsedTime);
        }
        if (toTimeRel && (toTime = this.recalculateOffsetTimeValue(toTime, testStartDate, elapsedTime)) == 0L) {
            toTime = Long.MAX_VALUE;
        }
        if (duration >= 0L) {
            if (toTime == Long.MAX_VALUE) {
                toTime = fromTime + duration;
            } else {
                fromTime = toTime - duration;
            }
        }
        if (noRampUp) {
            fromTime = this.excludeRampup(fromTime);
        }
        long[] boundaries = new long[]{fromTime, toTime};
        return boundaries;
    }

    private long excludeRampup(long fromTime) {
        long startTime = this.config.getLongProperty("com.xceptance.xlt.loadtest.start", 0L);
        if (startTime > 0L) {
            File configDir = new File(this.inputDir.getName().getPath(), "config");
            TestLoadProfileConfiguration loadProfileConfig = new TestLoadProfileConfiguration(configDir.getParentFile(), configDir);
            long endOfRampUpTime = startTime + loadProfileConfig.getTotalRampUpPeriod() * 1000L;
            fromTime = Math.max(fromTime, endOfRampUpTime);
        } else {
            System.out.printf("PLEASE NOTE: Ramp-up could not be excluded since no value could be found for property '%s'.\n", "com.xceptance.xlt.loadtest.start");
        }
        return fromTime;
    }

    private void read(long fromTime, long toTime) {
        DataRecordFactory statsFactory = new DataRecordFactory();
        Map<String, Class<? extends Data>> dataRecordClasses = this.config.getDataRecordClasses();
        for (Map.Entry<String, Class<? extends Data>> entry : dataRecordClasses.entrySet()) {
            String typeCode = entry.getKey();
            Class<? extends Data> c = entry.getValue();
            statsFactory.registerStatisticsClass(c, typeCode);
        }
        LogReader logReader = new LogReader(this.inputDir, statsFactory, fromTime, toTime, this.reportProviders, this.config.getRequestProcessingRules(), this.config.getThreadCount(), this.testCaseIncludePatternList, this.testCaseExcludePatternList, this.agentIncludePatternList, this.agentExcludePatternList, this.config.getRemoveIndexesFromRequestNames());
        logReader.readDataRecords();
        long minTime = logReader.getMinimumTime();
        long maxTime = logReader.getMaximumTime();
        this.config.setChartStartTime(minTime);
        this.config.setChartEndTime(maxTime);
        try {
            System.out.println("\nProcessing external data files ...");
            File externalChartsDir = new File(this.config.getChartDirectory(), "external");
            externalChartsDir.mkdirs();
            this.repGen.init(minTime, maxTime, this.inputDir.getName().getPath(), externalChartsDir, this.config.shouldChartsGenerated());
            this.repGen.parse();
        }
        catch (Exception e) {
            XltLogger.runTimeLogger.error((Object)"Failed to process external data", (Throwable)e);
            System.out.println("Failed to process external data: " + e.getMessage());
        }
    }

    private long recalculateOffsetTimeValue(long offsetTimeValue, long testStartDate, long elapsedTime) {
        long timeValue = 0L;
        long endTime = testStartDate + elapsedTime;
        if (offsetTimeValue < 0L) {
            if (testStartDate == 0L || elapsedTime == 0L) {
                System.out.printf("PLEASE NOTE: The specified offset '" + offsetTimeValue + "' could not be used since no value could be found for properties '%1$s' and '%2$s'.\n", "com.xceptance.xlt.loadtest.start", "com.xceptance.xlt.loadtest.elapsed");
            } else {
                timeValue = endTime + offsetTimeValue;
            }
        } else if (testStartDate == 0L) {
            System.out.printf("PLEASE NOTE: The specified offset '" + offsetTimeValue + "' could not be used since no value could be found for property '%s' .\n", "com.xceptance.xlt.loadtest.start");
        } else {
            timeValue = testStartDate + offsetTimeValue;
        }
        return timeValue;
    }

    private void printStartAndEndTime(long fromTime, long toTime) {
        if (fromTime > 0L && toTime == Long.MAX_VALUE) {
            System.out.printf("The test report will be based on results generated after '%s'.\n", new Date(fromTime));
        } else if (fromTime == 0L && toTime != Long.MAX_VALUE) {
            System.out.printf("The test report will be based on results generated before '%s'.\n", new Date(toTime));
        } else if (fromTime > 0L && toTime != Long.MAX_VALUE) {
            System.out.printf("The test report will be based on results generated between '%s' and '%s'.\n", new Date(fromTime), new Date(toTime));
        }
    }

    public File createReport(File outputDir) throws Exception {
        this.copyConfiguration(outputDir);
        XmlReportGenerator xmlReportGenerator = new XmlReportGenerator();
        xmlReportGenerator.registerStatisticsProviders(this.reportProviders);
        xmlReportGenerator.registerStatisticsProviders(this.repGen.getReportCreators());
        TaskManager.getInstance().startProgress("Creating");
        long start = TimerUtils.getTime();
        File xmlReport = new File(outputDir, "testreport.xml");
        xmlReportGenerator.createReport(xmlReport);
        TaskManager.getInstance().waitForAllTasksToComplete();
        TaskManager.getInstance().stopProgress();
        System.out.printf("Report artifacts created successfully (%,d ms)\n\n", TimerUtils.getTime() - start);
        return xmlReport;
    }

    private void copyConfiguration(File outputDir) throws FileSystemException {
        FileSelector fileSelector;
        FileObject reportConfigDir = VFS.getManager().resolveFile(outputDir, "config");
        FileObject resultsConfigDir = this.inputDir.getChild("config");
        if (resultsConfigDir == null) {
            resultsConfigDir = this.inputDir;
            FileFilter filter = new FileFilter(){

                public boolean accept(FileSelectInfo arg0) {
                    String baseName = arg0.getFile().getName().getBaseName();
                    return baseName.endsWith(".properties") || baseName.endsWith(".cfg");
                }
            };
            fileSelector = new FileFilterSelector(filter);
        } else {
            fileSelector = Selectors.SELECT_ALL;
        }
        reportConfigDir.copyFrom(resultsConfigDir, fileSelector);
        for (String path : this.resolvedPropertyFiles) {
            try {
                FileObject fo = reportConfigDir.resolveFile(path);
                if (fo.exists()) continue;
                FileObject source = resultsConfigDir.resolveFile(path);
                fo.copyFrom(source, Selectors.SELECT_SELF);
            }
            catch (FileSystemException fileSystemException) {}
        }
    }

    public void transformReport(File inputXmlFile, File outputDir) throws Exception {
        FileUtils.forceMkdir((File)outputDir);
        File resourcesDir = new File(this.config.getConfigDirectory(), "testreport");
        FileUtils.copyDirectory((File)resourcesDir, (File)outputDir, (java.io.FileFilter)FileFilterUtils.makeSVNAware(null), (boolean)false);
        ArrayList<File> outputFiles = new ArrayList<File>();
        ArrayList<File> styleSheetFiles = new ArrayList<File>();
        List<String> styleSheetFileNames = this.config.getStyleSheetFileNames();
        List<String> outputFileNames = this.config.getOutputFileNames();
        for (int i = 0; i < styleSheetFileNames.size(); ++i) {
            File outputFile = new File(outputDir, outputFileNames.get(i));
            outputFiles.add(outputFile);
            File styleSheetFile = new File(new File(this.config.getConfigDirectory(), "xsl/loadreport"), styleSheetFileNames.get(i));
            styleSheetFiles.add(styleSheetFile);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("productName", ProductInformation.getProductInformation().getProductName());
        parameters.put("productVersion", ProductInformation.getProductInformation().getVersion());
        parameters.put("productUrl", ProductInformation.getProductInformation().getProductURL());
        ReportTransformer reportTransformer = new ReportTransformer(outputFiles, styleSheetFiles, parameters);
        TaskManager.getInstance().startProgress("Transforming");
        long start = TimerUtils.getTime();
        reportTransformer.run(inputXmlFile, outputDir);
        TaskManager.getInstance().waitForAllTasksToComplete();
        TaskManager.getInstance().stopProgress();
        System.out.printf("Transformation completed successfully (%,d ms)\n", TimerUtils.getTime() - start);
    }

    private String getResultsDirName(FileObject input) {
        String inputDirName;
        FileName inputName = input.getName();
        boolean isPlainDirectory = inputName.getScheme().equals("file");
        if (isPlainDirectory) {
            inputDirName = inputName.getBaseName();
        } else if (inputName.getPath().equals("/")) {
            String archivePathName = StringUtils.substringBefore((String)inputName.getRoot().toString(), (String)"!");
            inputDirName = FilenameUtils.getBaseName((String)archivePathName);
        } else {
            inputDirName = inputName.getBaseName();
        }
        return inputDirName;
    }
}

