/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.criteria;

import com.xceptance.xlt.report.criteria.CriterionResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class CriteriaResult {
    private final List<CriterionResult> _results = new ArrayList<CriterionResult>();
    private final String documentName;

    public CriteriaResult(String name) {
        this.documentName = name;
    }

    public void add(CriterionResult result) {
        this._results.add(result);
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public List<CriterionResult> getResults() {
        return this._results;
    }

    public boolean hasPassed() {
        return this._results.stream().allMatch(CriterionResult::hasPassed);
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("document", (Object)this.getDocumentName());
        JSONObject details = new JSONObject();
        HashMap<CriterionResult.Status, Integer> totalMap = new HashMap<CriterionResult.Status, Integer>();
        for (CriterionResult crit : this.getResults()) {
            CriterionResult.Status status = crit.getStatus();
            String message = crit.getMessage();
            Integer i = totalMap.getOrDefault((Object)status, 0);
            totalMap.put(status, new Integer(i + 1));
            JSONObject obj = new JSONObject();
            obj.put("status", (Object)status.name().toLowerCase());
            if (message != null) {
                obj.put("message", (Object)message);
            }
            details.put(crit.getId(), (Object)obj);
        }
        JSONObject totals = new JSONObject();
        for (CriterionResult.Status s : CriterionResult.Status.values()) {
            totals.put(s.name().toLowerCase(), (Object)totalMap.getOrDefault((Object)s, 0));
        }
        json.put("totals", (Object)totals);
        json.put("details", (Object)details);
        return json;
    }
}

