/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.diffreport;

import com.xceptance.common.util.ProductInformation;
import com.xceptance.common.xml.DomUtils;
import com.xceptance.common.xml.XSLTUtils;
import com.xceptance.xlt.report.diffreport.DiffReportGeneratorConfiguration;
import com.xceptance.xlt.report.util.ElementSpecification;
import com.xceptance.xlt.report.util.ReportUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DiffReportGeneratorMain {
    private static final Log log = LogFactory.getLog(DiffReportGeneratorMain.class);

    public static void main(String[] args) {
        Locale.setDefault(Locale.US);
        DiffReportGeneratorMain main = new DiffReportGeneratorMain();
        main.run(args);
    }

    public void run(String[] args) {
        Options options = this.createCommandLineOptions();
        try {
            File outputDir;
            DiffReportGeneratorConfiguration config = new DiffReportGeneratorConfiguration();
            CommandLine commandLine = new DefaultParser().parse(options, args);
            String outputDirName = commandLine.getOptionValue("o");
            String[] remainingArgs = commandLine.getArgs();
            if (remainingArgs.length != 2) {
                this.printUsageInfoAndExit(options);
            }
            File oldReportDir = new File(remainingArgs[0]);
            Document oldTestReport = this.readTestReport(oldReportDir);
            File newReportDir = new File(remainingArgs[1]);
            Document newTestReport = this.readTestReport(newReportDir);
            if (outputDirName == null) {
                File reportsDir = config.getReportsRootDirectory();
                outputDir = new File(reportsDir, oldReportDir.getName() + "-vs-" + newReportDir.getName());
            } else {
                outputDir = new File(outputDirName);
            }
            FileUtils.forceMkdir((File)outputDir);
            String outputDirPath = outputDir.getCanonicalPath();
            System.out.println("Writing difference report to directory: " + outputDirPath);
            Document diffReport = this.createDiffReport(oldTestReport, oldReportDir.getName(), newTestReport, newReportDir.getName(), config.getDiffElementSpecifications(), config.getCopyElementSpecifications());
            File xmlFile = new File(outputDir, "diffreport.xml");
            this.writeDiffReport(diffReport, xmlFile);
            System.out.println("Rendering the HTML difference report ...");
            File htmlFile = new File(outputDir, "index.html");
            File styleSheetFile = new File(config.getConfigDirectory(), "xsl/diffreport" + File.separator + "index.xsl");
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("productName", ProductInformation.getProductInformation().getProductName());
            parameters.put("productVersion", ProductInformation.getProductInformation().getVersion());
            parameters.put("productUrl", ProductInformation.getProductInformation().getProductURL());
            parameters.put("projectName", ReportUtils.obtainProjectName(Arrays.asList(oldTestReport, newTestReport)));
            XSLTUtils.transform(xmlFile, htmlFile, styleSheetFile, parameters);
            File resourcesDir = new File(config.getConfigDirectory(), "testreport");
            FileUtils.copyDirectory((File)resourcesDir, (File)outputDir, (FileFilter)FileFilterUtils.makeSVNAware(null), (boolean)true);
            File reportFile = new File(outputDir, "index.html");
            String reportPath = ReportUtils.toString(reportFile);
            System.out.println("\nReport: " + reportPath);
            System.exit(0);
        }
        catch (ParseException pex) {
            this.printUsageInfoAndExit(options);
        }
        catch (Exception ex) {
            log.fatal((Object)"Failed to run diff report generator.", (Throwable)ex);
            System.exit(1);
        }
    }

    private Element copyElements(Document sourceDocument, String tagName, String reportName, Document document, List<ElementSpecification> copyElementSpecs) {
        Element rootElement = this.createElement(tagName, null, document);
        Element nameElement = this.createElement("name", reportName, document);
        rootElement.appendChild(nameElement);
        for (ElementSpecification elementSpec : copyElementSpecs) {
            Map<String, Element> elementsById = ReportUtils.filterElements(sourceDocument, elementSpec);
            for (Element element : elementsById.values()) {
                Element copiedElement = (Element)DomUtils.cloneNode(element, document);
                rootElement.appendChild(copiedElement);
            }
        }
        return rootElement;
    }

    private Element createChangeElement(Element oldElement, Element newElement, Document document) {
        Element element = null;
        try {
            double newValue;
            String tagName = oldElement != null ? oldElement.getTagName() : newElement.getTagName();
            element = document.createElement(tagName);
            double oldValue = oldElement == null ? Double.NaN : Double.parseDouble(oldElement.getTextContent());
            double d = newValue = newElement == null ? Double.NaN : Double.parseDouble(newElement.getTextContent());
            if (Double.isNaN(oldValue)) {
                ReportUtils.addTextElement("newValue", ReportUtils.formatValue(newValue), element);
            } else if (Double.isNaN(newValue)) {
                ReportUtils.addTextElement("oldValue", ReportUtils.formatValue(oldValue), element);
            } else {
                ReportUtils.addTextElement("oldValue", ReportUtils.formatValue(oldValue), element);
                ReportUtils.addTextElement("newValue", ReportUtils.formatValue(newValue), element);
                double absoluteDifference = newValue - oldValue;
                double relativeDifference = oldValue == 0.0 ? (newValue == 0.0 ? 0.0 : Double.POSITIVE_INFINITY) : (newValue / oldValue - 1.0) * 100.0;
                ReportUtils.addTextElement("absoluteDifference", ReportUtils.formatValue(absoluteDifference), element);
                ReportUtils.addTextElement("relativeDifference", ReportUtils.formatValue(relativeDifference), element);
            }
        }
        catch (NumberFormatException e) {
            element = oldElement == null ? this.createElement(newElement.getTagName(), newElement.getTextContent(), document) : this.createElement(oldElement.getTagName(), oldElement.getTextContent(), document);
        }
        return element;
    }

    private Map<String, Element> createChildElementMap(Element rootElement) {
        LinkedHashMap<String, Element> elementsByName = new LinkedHashMap<String, Element>();
        NodeList childNodes = rootElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            elementsByName.put(element.getTagName(), element);
        }
        return elementsByName;
    }

    private Options createCommandLineOptions() {
        Options options = new Options();
        Option targetDir = new Option("o", true, "the difference report target directory");
        targetDir.setArgName("dir");
        options.addOption(targetDir);
        return options;
    }

    private Document createDiffReport(Document oldTestReport, String oldTestReportName, Document newTestReport, String newTestReportName, List<ElementSpecification> diffElementSpecs, List<ElementSpecification> copyElementSpecs) throws ParserConfigurationException {
        System.out.println("Creating the XML difference report ...");
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document diffReport = builder.getDOMImplementation().createDocument(null, "testreport", null);
        Element root = diffReport.getDocumentElement();
        Element tr1 = this.copyElements(oldTestReport, "testReport1", oldTestReportName, diffReport, copyElementSpecs);
        root.appendChild(tr1);
        Element tr2 = this.copyElements(newTestReport, "testReport2", newTestReportName, diffReport, copyElementSpecs);
        root.appendChild(tr2);
        for (ElementSpecification elementSpec : diffElementSpecs) {
            Map<String, Element> oldElementsById = ReportUtils.filterElements(oldTestReport, elementSpec);
            Map<String, Element> newElementsById = ReportUtils.filterElements(newTestReport, elementSpec);
            for (Map.Entry<String, Element> entry : oldElementsById.entrySet()) {
                Element oldElement = entry.getValue();
                Element newElement = newElementsById.remove(entry.getKey());
                Element diffElement = this.diffElementTree(oldElement, newElement, diffReport);
                Element parent = this.insertParentElements(oldElement, newElement, diffReport);
                parent.appendChild(diffElement);
            }
            for (Element newElement : newElementsById.values()) {
                Element diffElement = this.diffElementTree(null, newElement, diffReport);
                Element parent = this.insertParentElements(null, newElement, diffReport);
                parent.appendChild(diffElement);
            }
        }
        return diffReport;
    }

    private Element createElement(String tagName, String textContent, Document document) {
        Element element = document.createElement(tagName);
        if (textContent != null) {
            element.setTextContent(textContent);
        }
        return element;
    }

    private Element diffElementTree(Element oldElement, Element newElement, Document document) {
        Element diffElement;
        if (oldElement == null) {
            diffElement = document.createElement(newElement.getTagName());
            Map<String, Element> childElements = this.createChildElementMap(newElement);
            if (!childElements.isEmpty()) {
                for (Element childElement : childElements.values()) {
                    diffElement.appendChild(this.diffElementTree(null, childElement, document));
                }
            } else {
                diffElement = this.createChangeElement(null, newElement, document);
            }
        } else if (newElement == null) {
            diffElement = document.createElement(oldElement.getTagName());
            Map<String, Element> childElements = this.createChildElementMap(oldElement);
            if (!childElements.isEmpty()) {
                for (Element childElement : childElements.values()) {
                    diffElement.appendChild(this.diffElementTree(childElement, null, document));
                }
            } else {
                diffElement = this.createChangeElement(oldElement, null, document);
            }
        } else {
            diffElement = document.createElement(oldElement.getTagName());
            Map<String, Element> oldChildElements = this.createChildElementMap(oldElement);
            Map<String, Element> newChildElements = this.createChildElementMap(newElement);
            boolean isOldElementLeaf = oldChildElements.isEmpty();
            boolean isNewElementLeaf = newChildElements.isEmpty();
            if (isOldElementLeaf && isNewElementLeaf) {
                diffElement = this.createChangeElement(oldElement, newElement, document);
            } else if (!isOldElementLeaf && !isNewElementLeaf) {
                for (Map.Entry<String, Element> entry : oldChildElements.entrySet()) {
                    Element oldChildElement = entry.getValue();
                    Element newChildElement = newChildElements.remove(entry.getKey());
                    diffElement.appendChild(this.diffElementTree(oldChildElement, newChildElement, document));
                }
                for (Element childElement : newChildElements.values()) {
                    diffElement.appendChild(this.diffElementTree(childElement, null, document));
                }
            } else {
                System.err.println("Difference in structure - cannot compare!");
            }
        }
        return diffElement;
    }

    private Element insertParentElements(Element element, Document document) {
        if (element.getTagName().equals("testreport")) {
            return document.getDocumentElement();
        }
        Element e = this.insertParentElements((Element)element.getParentNode(), document);
        Element e2 = null;
        NodeList elements = e.getElementsByTagName(element.getTagName());
        e2 = elements.getLength() == 0 ? document.createElement(element.getTagName()) : (Element)elements.item(0);
        e.appendChild(e2);
        return e2;
    }

    private Element insertParentElements(Element oldElement, Element newElement, Document document) {
        Element sourceElement = oldElement != null ? oldElement : newElement;
        return this.insertParentElements((Element)sourceElement.getParentNode(), document);
    }

    private void printUsageInfoAndExit(Options options) {
        System.out.println("\nCreates a difference report from two test reports.");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("Usage: ");
        formatter.setWidth(79);
        System.out.println();
        formatter.printHelp("create_diff_report [options] <testReportDir_1> <testReportDir_2>", "\nOptions:", options, null);
        System.out.println();
        System.exit(2);
    }

    private Document readTestReport(File dir) throws ParserConfigurationException, SAXException, IOException {
        System.out.println("Reading test report from directory: " + dir);
        File file = new File(dir, "testreport.xml");
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return documentBuilder.parse(file);
    }

    private void writeDiffReport(Document diffReport, File file) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            osw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            DomUtils.prettyPrintNode((Node)diffReport, osw);
        }
    }
}

