/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.external;

import com.xceptance.xlt.api.report.ReportCreator;
import com.xceptance.xlt.api.report.external.AbstractLineParser;
import com.xceptance.xlt.report.external.Reader;
import com.xceptance.xlt.report.external.config.ChartConfig;
import com.xceptance.xlt.report.external.config.Config;
import com.xceptance.xlt.report.external.config.DataFileConfig;
import com.xceptance.xlt.report.external.config.ExternalDataConfigProvider;
import com.xceptance.xlt.report.external.config.Property;
import com.xceptance.xlt.report.external.config.SeriesConfig;
import com.xceptance.xlt.report.external.config.TableConfig;
import com.xceptance.xlt.report.external.config.ValueConfig;
import com.xceptance.xlt.report.external.converter.ConverterConfiguration;
import com.xceptance.xlt.report.external.converter.CustomReportProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class ExternalReportGenerator {
    private static final Log LOG = LogFactory.getLog(ExternalReportGenerator.class);
    private static final String ERROR_MSG = "Failed to process external data file '%s'\n-> Configured parser class '%s' cannot be instantiated.";
    protected final List<ReportCreator> reportProviders = new ArrayList<ReportCreator>();
    protected long minTime;
    protected long maxTime;
    protected String inputDir;
    protected File chartDir;
    protected List<ConverterConfiguration> resources = new ArrayList<ConverterConfiguration>();
    private boolean generateCharts;

    public void init(long minTime, long maxTime, String inputDir, File chartDir, boolean generateCharts) {
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.inputDir = inputDir;
        this.chartDir = chartDir;
        this.generateCharts = generateCharts;
    }

    public void parse() throws IOException, JAXBException, SAXException {
        Config config = ExternalDataConfigProvider.getConfig(this.inputDir);
        for (DataFileConfig dataFile : config.getFiles()) {
            String fileName = dataFile.getFileName();
            if (StringUtils.isNotEmpty((CharSequence)fileName)) {
                fileName = this.normalizeFileName(fileName);
                ConverterConfiguration converterConfig = this.configureConverterConfig(dataFile);
                CustomReportProvider reportProvider = new CustomReportProvider();
                reportProvider.setConfiguration(converterConfig);
                String parserClassName = dataFile.getParserClassName();
                AbstractLineParser abstractParser = this.initializeParserImplementation(fileName, parserClassName);
                if (abstractParser == null) continue;
                this.reportProviders.add(reportProvider);
                abstractParser.setValueNames(this.getValueNames(dataFile));
                abstractParser.setProperties(this.getProperties(dataFile));
                Reader reader = new Reader(fileName, dataFile.getEncoding(), abstractParser);
                reader.setConverter(reportProvider);
                reader.readData();
                continue;
            }
            String msg = "External data file not specified in configuration.";
            LOG.error((Object)"External data file not specified in configuration.");
            System.out.println("External data file not specified in configuration.");
        }
    }

    private String normalizeFileName(String fileName) throws IOException {
        if (!new File(fileName).isAbsolute() && !fileName.startsWith("/")) {
            fileName = new File(this.inputDir, fileName).getCanonicalFile().toString();
        }
        return fileName;
    }

    private ConverterConfiguration configureConverterConfig(DataFileConfig dataFile) throws IOException {
        ConverterConfiguration converterConfig = new ConverterConfiguration();
        converterConfig.setChartStartTime(this.minTime);
        converterConfig.setChartEndTime(this.maxTime);
        converterConfig.setChartsDir(this.chartDir);
        converterConfig.setDataFile(dataFile);
        if (!this.generateCharts) {
            converterConfig.disableChartGeneration();
        }
        return converterConfig;
    }

    private Properties getProperties(DataFileConfig dataFile) {
        Properties properties = new Properties();
        List<Property> fileProperties = dataFile.getProperties();
        if (fileProperties != null) {
            for (Property property : fileProperties) {
                String key = property.getKey();
                String value = property.getValue();
                if (key == null || value == null) continue;
                properties.put(key, value);
            }
        }
        return properties;
    }

    private Set<String> getValueNames(DataFileConfig dataFile) {
        HashSet<String> valueNames = new HashSet<String>();
        for (TableConfig table : dataFile.getTables()) {
            List<ValueConfig> valueConfigs = table.getRows();
            if (valueConfigs.isEmpty()) {
                valueConfigs = table.getColumns();
            }
            for (ValueConfig row : valueConfigs) {
                valueNames.add(row.getValueName());
            }
        }
        for (ChartConfig chart : dataFile.getCharts()) {
            for (SeriesConfig series : chart.getSeriesCollection()) {
                valueNames.add(series.getValueName());
            }
        }
        return valueNames;
    }

    private AbstractLineParser initializeParserImplementation(String fileName, String parserClassName) {
        ClassLoader classLoader = null;
        Class<?> parserClass = null;
        AbstractLineParser abstractParser = null;
        try {
            classLoader = ClassLoader.getSystemClassLoader();
            parserClass = classLoader.loadClass(parserClassName);
            abstractParser = (AbstractLineParser)parserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = String.format(ERROR_MSG, fileName, parserClassName);
            LOG.error((Object)msg, (Throwable)cnfe);
            System.out.println(msg);
        }
        catch (NoSuchMethodException nsme) {
            String msg = String.format("Failed to process external data file '%s'\n-> Configured parser class '%s' cannot be instantiated. Did you provide a public no arg constructor?", fileName, parserClassName);
            LOG.error((Object)msg, (Throwable)nsme);
            System.out.println(msg);
        }
        catch (SecurityException se) {
            String msg = String.format(ERROR_MSG, fileName, parserClassName);
            LOG.error((Object)msg, (Throwable)se);
            System.out.println(msg);
        }
        catch (Throwable t) {
            String msg = String.format(ERROR_MSG, fileName, parserClassName);
            LOG.error((Object)msg, t);
            System.out.println(msg);
        }
        return abstractParser;
    }

    public List<ReportCreator> getReportCreators() {
        return this.reportProviders;
    }
}

