/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.external.converter;

import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.report.external.config.ChartConfig;
import com.xceptance.xlt.report.external.config.SeriesConfig;
import com.xceptance.xlt.report.external.config.TableConfig;
import com.xceptance.xlt.report.external.config.ValueConfig;
import com.xceptance.xlt.report.external.converter.AbstractDataConverter;
import com.xceptance.xlt.report.external.reportObject.GenericReport;
import com.xceptance.xlt.report.external.reportObject.Row;
import com.xceptance.xlt.report.external.reportObject.Table;
import com.xceptance.xlt.report.external.util.StatsValueSet;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.TaskManager;
import com.xceptance.xlt.report.util.TimeSeriesConfiguration;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfree.data.time.TimeSeries;

public class CustomReportProvider
extends AbstractDataConverter {
    protected static final Color DEFAULT_COLOR_BLUE = Color.BLUE;
    protected static final Color DEFAULT_COLOR_GRAY = Color.DARK_GRAY;
    protected static final String NA = "n/a";
    protected static final String SHARP = "#";
    protected Map<String, StatsValueSet> vSets = new HashMap<String, StatsValueSet>();
    private List<Map<String, Object>> plainValueSets = new ArrayList<Map<String, Object>>();

    @Override
    public Object createReportFragment() {
        GenericReport report = new GenericReport();
        report.headline = this.getConfiguration().getDataFile().getHeadline();
        report.description = this.getConfiguration().getDataFile().getDescription();
        List<TableConfig> tableConfigs = this.getConfiguration().getDataFile().getTables();
        for (TableConfig tableConfig : tableConfigs) {
            TableConfig.TableType tableType = tableConfig.getType();
            String tableTitle = tableConfig.getTitle();
            boolean transposeTable = false;
            List<ValueConfig> valueConfigs = tableConfig.getColumns();
            if (valueConfigs.isEmpty()) {
                valueConfigs = tableConfig.getRows();
                transposeTable = true;
            }
            Table table = null;
            if (tableType.equals((Object)TableConfig.TableType.minmaxavg)) {
                table = this.createMinMaxAvgTable(tableTitle, valueConfigs, this.vSets);
            } else if (tableType.equals((Object)TableConfig.TableType.plain)) {
                table = this.createPlainTable(tableTitle, valueConfigs, this.plainValueSets);
            } else {
                String message = String.format("Table '%s' specifies the unknown table type '%s'. Only '%s' and '%s' are supported types.", new Object[]{tableConfig.getTitle(), tableType, TableConfig.TableType.minmaxavg, TableConfig.TableType.plain});
                XltLogger.runTimeLogger.error((Object)message);
            }
            if (table == null) continue;
            if (transposeTable) {
                table = this.transposeTable(table);
            }
            report.tables.add(table);
        }
        if (this.getConfiguration().shouldChartsGenerated()) {
            List<ChartConfig> chartConfigs = this.getConfiguration().getDataFile().getCharts();
            TaskManager manager = TaskManager.getInstance();
            for (final ChartConfig chartConfig : chartConfigs) {
                final String fileName = chartConfig.getTitle();
                report.chartFileNames.add(fileName);
                manager.addTask(new Runnable(){

                    @Override
                    public void run() {
                        CustomReportProvider.this.createChart(chartConfig, fileName);
                    }
                });
            }
        }
        return report;
    }

    private Table createMinMaxAvgTable(String tableTitle, List<ValueConfig> valueConfigs, Map<String, StatsValueSet> valueSets) {
        Table table = new Table();
        table.setTitle(tableTitle);
        Row headRow = new Row();
        Row meanRow = new Row();
        Row minRow = new Row();
        Row maxRow = new Row();
        table.setHeadRow(headRow);
        table.addRow(meanRow);
        table.addRow(minRow);
        table.addRow(maxRow);
        headRow.addCell("Value Name");
        meanRow.addCell("Mean");
        minRow.addCell("Minimum");
        maxRow.addCell("Maximum");
        for (ValueConfig valueConfig : valueConfigs) {
            String title = valueConfig.getTitle();
            if (StringUtils.isNotBlank((CharSequence)valueConfig.getUnit())) {
                title = title + " [" + valueConfig.getUnit() + "]";
            }
            headRow.addCell(title);
            StatsValueSet vSet = valueSets.get(valueConfig.getValueName());
            if (vSet != null) {
                meanRow.addCell(vSet.getAvg());
                minRow.addCell(vSet.getMin());
                maxRow.addCell(vSet.getMax());
                continue;
            }
            meanRow.addCell(NA);
            minRow.addCell(NA);
            maxRow.addCell(NA);
        }
        table.finish();
        return table;
    }

    private Table createPlainTable(String tableTitle, List<ValueConfig> valueConfigs, List<Map<String, Object>> valueSets) {
        Table table = new Table();
        table.setTitle(tableTitle);
        Row row = new Row();
        for (ValueConfig valueConfig : valueConfigs) {
            String title = valueConfig.getTitle();
            if (StringUtils.isNotBlank((CharSequence)valueConfig.getUnit())) {
                title = title + " [" + valueConfig.getUnit() + "]";
            }
            row.addCell(title);
        }
        table.setHeadRow(row);
        ArrayList<Row> rows = new ArrayList<Row>();
        if (valueSets.isEmpty()) {
            HashMap<String, String> dummyValueSet = new HashMap<String, String>();
            valueSets.add(dummyValueSet);
            for (ValueConfig valueConfig : valueConfigs) {
                dummyValueSet.put(valueConfig.getValueName(), NA);
            }
        }
        for (Map map : valueSets) {
            Row row2 = new Row();
            for (ValueConfig valueConfig : valueConfigs) {
                Object value = map.get(valueConfig.getValueName());
                row2.addCell(value);
            }
            rows.add(row2);
        }
        table.setBodyRows(rows);
        table.finish();
        return table;
    }

    private Table transposeTable(Table table) {
        Table newTable = new Table();
        newTable.setTitle(table.getTitle());
        Row headRow = table.getHeadRow();
        List<Row> bodyRows = table.getBodyRows();
        for (int c = 0; c < table.getMaxCols(); ++c) {
            Row newRow = new Row();
            newRow.addCell(headRow.getCells().get(c));
            for (int r = 0; r < bodyRows.size(); ++r) {
                newRow.addCell(bodyRows.get(r).getCells().get(c));
            }
            if (c == 0) {
                newTable.setHeadRow(newRow);
                continue;
            }
            newTable.addRow(newRow);
        }
        newTable.finish();
        return newTable;
    }

    @Override
    public void parse(long time, Map<String, Object> input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("Input must not be NULL");
        }
        if (time == -1L) {
            this.plainValueSets.add(input);
        } else if (this.getConfiguration().getChartStartTime() <= time && time <= this.getConfiguration().getChartEndTime()) {
            for (Map.Entry<String, Object> entry : input.entrySet()) {
                String name = entry.getKey();
                Double value = (Double)entry.getValue();
                StatsValueSet vSet = this.vSets.get(name);
                if (vSet == null) {
                    vSet = new StatsValueSet();
                    this.vSets.put(name, vSet);
                }
                vSet.addOrUpdate(time, value);
            }
        }
    }

    protected Color getColor(String color) {
        Color resultColor;
        block4: {
            resultColor = null;
            if (color != null) {
                if ((color = color.trim()).startsWith(SHARP)) {
                    color = color.substring(1);
                }
                try {
                    int colorValue = Integer.valueOf(color, 16);
                    resultColor = new Color(colorValue);
                }
                catch (Exception e) {
                    if (!XltLogger.runTimeLogger.isInfoEnabled()) break block4;
                    XltLogger.runTimeLogger.info((Object)("Color '" + color + "' is not valid."));
                }
            }
        }
        return resultColor;
    }

    private void createChart(ChartConfig config, String fileName) {
        ArrayList<List<TimeSeriesConfiguration>> axisCollections = new ArrayList<List<TimeSeriesConfiguration>>(2);
        axisCollections.add(new ArrayList());
        axisCollections.add(new ArrayList());
        for (SeriesConfig seriesConfig : config.getSeriesCollection()) {
            String valueName = seriesConfig.getValueName();
            StatsValueSet vSet = this.vSets.get(valueName);
            if (vSet != null) {
                String seriesTitle = seriesConfig.getTitle() != null ? seriesConfig.getTitle() : valueName;
                TimeSeries timeSeries = vSet.toTimeSeries(seriesTitle);
                Color color = this.getColor(seriesConfig.getColor());
                TimeSeriesConfiguration tsConfig = new TimeSeriesConfiguration(timeSeries, color, TimeSeriesConfiguration.Style.LINE);
                if (seriesConfig.getAverage() != null) {
                    try {
                        int percentage = Integer.parseInt(seriesConfig.getAverage());
                        TimeSeries avgTimeSeries = JFreeChartUtils.createMovingAverageTimeSeries(timeSeries, percentage);
                        Color avgColor = this.getColor(seriesConfig.getAverageColor());
                        TimeSeriesConfiguration avgTsConfig = new TimeSeriesConfiguration(avgTimeSeries, avgColor, TimeSeriesConfiguration.Style.LINE);
                        ((List)axisCollections.get(seriesConfig.getAxis() - 1)).add(avgTsConfig);
                    }
                    catch (NumberFormatException e) {
                        XltLogger.runTimeLogger.warn((Object)("Skip moving average for series " + valueName + ". Can not parse average '" + seriesConfig.getAverage() + "' to integer value"));
                    }
                }
                ((List)axisCollections.get(seriesConfig.getAxis() - 1)).add(tsConfig);
                continue;
            }
            if (!XltLogger.runTimeLogger.isInfoEnabled()) continue;
            XltLogger.runTimeLogger.info((Object)("no data for series " + valueName));
        }
        this.createFloatingChart(axisCollections, config, fileName);
        System.out.printf("Creating chart '%s' ...\n", fileName);
    }
}

