/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.mergerules;

import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.report.mergerules.AbstractPatternRequestFilter;
import com.xceptance.xlt.report.mergerules.AbstractRequestFilter;
import com.xceptance.xlt.report.mergerules.AgentNameRequestFilter;
import com.xceptance.xlt.report.mergerules.ContentTypeRequestFilter;
import com.xceptance.xlt.report.mergerules.InvalidRequestProcessingRuleException;
import com.xceptance.xlt.report.mergerules.PlaceholderPosition;
import com.xceptance.xlt.report.mergerules.RequestNameRequestFilter;
import com.xceptance.xlt.report.mergerules.RequestProcessingRuleResult;
import com.xceptance.xlt.report.mergerules.ResponseTimeRequestFilter;
import com.xceptance.xlt.report.mergerules.StatusCodeRequestFilter;
import com.xceptance.xlt.report.mergerules.TransactionNameRequestFilter;
import com.xceptance.xlt.report.mergerules.UrlRequestFilter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class RequestProcessingRule {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{([acnrstu])(?::([0-9]+))?\\}");
    private final String newName;
    private final boolean stopOnMatch;
    private final boolean dropOnMatch;
    private final AbstractRequestFilter[] requestFilters;
    private final PlaceholderPosition[] newNamePlaceholders;

    public RequestProcessingRule(String newName, String requestNamePattern, String urlPattern, String contentTypePattern, String statusCodePattern, String agentNamePattern, String transactionNamePattern, String responseTimeRanges, boolean stopOnMatch, String requestNameExcludePattern, String urlExcludePattern, String contentTypeExcludePattern, String statusCodeExcludePattern, String agentNameExcludePattern, String transactionNameExcludePattern, boolean dropOnMatch) throws InvalidRequestProcessingRuleException {
        this.newName = newName;
        this.stopOnMatch = stopOnMatch;
        this.dropOnMatch = dropOnMatch;
        ArrayList<AbstractRequestFilter> requestFilters = new ArrayList<AbstractRequestFilter>(20);
        try {
            requestFilters.add(new RequestNameRequestFilter(requestNamePattern));
            requestFilters.add(new UrlRequestFilter(urlPattern));
            requestFilters.add(new ContentTypeRequestFilter(contentTypePattern));
            requestFilters.add(new StatusCodeRequestFilter(statusCodePattern));
            requestFilters.add(new AgentNameRequestFilter(agentNamePattern));
            requestFilters.add(new TransactionNameRequestFilter(transactionNamePattern));
            requestFilters.add(new ResponseTimeRequestFilter(responseTimeRanges));
            if (StringUtils.isNotBlank((CharSequence)requestNameExcludePattern)) {
                requestFilters.add(new RequestNameRequestFilter(requestNameExcludePattern, true));
            }
            if (StringUtils.isNotBlank((CharSequence)urlExcludePattern)) {
                requestFilters.add(new UrlRequestFilter(urlExcludePattern, true));
            }
            if (StringUtils.isNotBlank((CharSequence)contentTypeExcludePattern)) {
                requestFilters.add(new ContentTypeRequestFilter(contentTypeExcludePattern, true));
            }
            if (StringUtils.isNotBlank((CharSequence)statusCodeExcludePattern)) {
                requestFilters.add(new StatusCodeRequestFilter(statusCodeExcludePattern, true));
            }
            if (StringUtils.isNotBlank((CharSequence)agentNameExcludePattern)) {
                requestFilters.add(new AgentNameRequestFilter(agentNameExcludePattern, true));
            }
            if (StringUtils.isNotBlank((CharSequence)transactionNameExcludePattern)) {
                requestFilters.add(new TransactionNameRequestFilter(transactionNameExcludePattern, true));
            }
        }
        catch (PatternSyntaxException pse) {
            throw new InvalidRequestProcessingRuleException("Invalid regular expression: " + pse.getPattern());
        }
        this.requestFilters = requestFilters.toArray(new AbstractRequestFilter[requestFilters.size()]);
        this.newNamePlaceholders = RequestProcessingRule.parsePlaceholderPositions(newName);
        this.validateRule();
    }

    private static PlaceholderPosition[] parsePlaceholderPositions(String newNameWithPlaceholders) throws InvalidRequestProcessingRuleException {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(newNameWithPlaceholders);
        ArrayList<PlaceholderPosition> positions = new ArrayList<PlaceholderPosition>();
        while (matcher.find()) {
            int matchingGroupIndex = -1;
            String matchingGroupIndexString = matcher.group(2);
            if (matchingGroupIndexString != null) {
                try {
                    matchingGroupIndex = Integer.valueOf(matchingGroupIndexString);
                }
                catch (NumberFormatException e) {
                    throw new InvalidRequestProcessingRuleException("Failed to parse the matching group index '" + matchingGroupIndexString + "' as integer");
                }
            }
            PlaceholderPosition position = new PlaceholderPosition(matcher.group(1), matchingGroupIndex, matcher.start(), matcher.end(), matcher.group().length());
            positions.add(position);
        }
        return positions.toArray(new PlaceholderPosition[positions.size()]);
    }

    public RequestProcessingRuleResult process(RequestData requestData) {
        int requestFiltersSize = this.requestFilters.length;
        Object[] filterStates = new Object[requestFiltersSize];
        for (int i = 0; i < requestFiltersSize; ++i) {
            AbstractRequestFilter filter = this.requestFilters[i];
            filterStates[i] = filter.appliesTo(requestData);
            if (filterStates[i] != null) continue;
            return new RequestProcessingRuleResult(requestData, false);
        }
        if (this.dropOnMatch) {
            return new RequestProcessingRuleResult(null, true);
        }
        if (this.newNamePlaceholders.length > 0) {
            StringBuilder result = new StringBuilder(this.newName);
            int displacement = 0;
            block1: for (PlaceholderPosition placeholder : this.newNamePlaceholders) {
                for (int i = 0; i < requestFiltersSize; ++i) {
                    AbstractRequestFilter requestFilter = this.requestFilters[i];
                    if (!requestFilter.isSameTypeCode(placeholder.typeCode, placeholder.typeCodeHashCode)) continue;
                    int capturingGroupIndex = placeholder.index;
                    Object filterState = filterStates[i];
                    String replacement = requestFilter.getReplacementText(requestData, capturingGroupIndex, filterState);
                    result.replace(placeholder.start + displacement, placeholder.end + displacement, replacement);
                    displacement += replacement.length() - placeholder.length;
                    continue block1;
                }
            }
            requestData.setName(result.toString());
        } else {
            requestData.setName(this.newName);
        }
        return new RequestProcessingRuleResult(requestData, this.stopOnMatch);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Naming rule: '").append(this.newName).append("', filters:  [");
        boolean appendComma = false;
        for (AbstractRequestFilter requestFilter : this.requestFilters) {
            String typeCode = requestFilter.getTypeCode();
            if (appendComma) {
                sb.append(", ");
            }
            if ("a".equals(typeCode)) {
                sb.append("agentName: ").append(requestFilter.toString());
            } else if ("c".equals(typeCode)) {
                sb.append("contentType: ").append(requestFilter.toString());
            } else if ("n".equals(typeCode)) {
                sb.append("requestName: ").append(requestFilter.toString());
            } else if ("r".equals(typeCode)) {
                sb.append("responseTime:").append(requestFilter.toString());
            } else if ("s".equals(typeCode)) {
                sb.append("statusCode:").append(requestFilter.toString());
            } else if ("t".equals(typeCode)) {
                sb.append("txnName: ").append(requestFilter.toString());
            } else if ("u".equals(typeCode)) {
                sb.append("requestURL: ").append(requestFilter.toString());
            } else {
                sb.append("unknown");
            }
            appendComma = true;
        }
        sb.append("]");
        return sb.toString();
    }

    private void validateRule() throws InvalidRequestProcessingRuleException {
        block0: for (PlaceholderPosition placeholderPosition : this.newNamePlaceholders) {
            for (AbstractRequestFilter filter : this.requestFilters) {
                String pattern;
                int nbCaptureGroups;
                if (!filter.getTypeCode().equals(placeholderPosition.typeCode)) continue;
                if (!(filter instanceof AbstractPatternRequestFilter)) continue block0;
                AbstractPatternRequestFilter patternFilter = (AbstractPatternRequestFilter)filter;
                if (placeholderPosition.index <= 0 || placeholderPosition.index <= (nbCaptureGroups = RegExUtils.getCaptureGroupCount(pattern = patternFilter.getPattern()))) continue block0;
                throw new InvalidRequestProcessingRuleException(String.format("Pattern '%s' has no matching group '%d'", pattern, placeholderPosition.index));
            }
        }
    }
}

