/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.report.ReportProviderConfiguration;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.BasicTimerReportProvider;
import com.xceptance.xlt.report.providers.RequestDataProcessor;
import com.xceptance.xlt.report.providers.RequestTableColorization;
import com.xceptance.xlt.report.providers.RequestsReport;
import com.xceptance.xlt.report.providers.TimerReport;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestsReportProvider
extends BasicTimerReportProvider<RequestDataProcessor> {
    private static final Log LOG = LogFactory.getLog(RequestsReportProvider.class);

    public RequestsReportProvider() {
        super(RequestDataProcessor.class);
    }

    @Override
    public Object createReportFragment() {
        RequestsReport report = new RequestsReport();
        report.requests = this.createTimerReports(true);
        ReportProviderConfiguration configuration = this.getConfiguration();
        if (configuration instanceof ReportGeneratorConfiguration) {
            this.processTableColorizations(report.requests, (ReportGeneratorConfiguration)configuration);
        }
        return report;
    }

    private void processTableColorizations(List<TimerReport> requests, ReportGeneratorConfiguration reportGeneratorConfig) {
        String defaultGroupName = reportGeneratorConfig.getRequestTableColorizationDefaultGroupName();
        ArrayList<RequestTableColorization> colorizationConfigs = new ArrayList<RequestTableColorization>(reportGeneratorConfig.getRequestTableColorizations());
        RequestTableColorization defaultColorizationConfig = null;
        for (TimerReport eachRequest : requests) {
            RequestTableColorization resolvedColorizationConfig = null;
            RequestTableColorization multipleMatch = null;
            for (RequestTableColorization eachColorizationConfig : colorizationConfigs) {
                if (defaultGroupName.equals(eachColorizationConfig.getGroupName())) {
                    if (defaultColorizationConfig != null) continue;
                    defaultColorizationConfig = eachColorizationConfig;
                    continue;
                }
                if (!RegExUtils.isMatching(eachRequest.name, eachColorizationConfig.getPattern())) continue;
                if (resolvedColorizationConfig != null) {
                    multipleMatch = eachColorizationConfig;
                    break;
                }
                resolvedColorizationConfig = eachColorizationConfig;
            }
            if (multipleMatch == null) {
                if (resolvedColorizationConfig == null && defaultColorizationConfig != null && RegExUtils.isMatching(eachRequest.name, defaultColorizationConfig.getPattern())) {
                    resolvedColorizationConfig = defaultColorizationConfig;
                }
                if (resolvedColorizationConfig == null) continue;
                eachRequest.colorizationGroupName = resolvedColorizationConfig.getGroupName();
                continue;
            }
            LOG.warn((Object)("Skipping request table colorization rule. Found multiple matching rules for \"" + eachRequest.name + "\" and rules [" + multipleMatch.getGroupName() + ", " + resolvedColorizationConfig.getGroupName() + "]"));
        }
    }

    @Override
    public void processDataRecord(Data data) {
        if (data instanceof RequestData) {
            super.processDataRecord(data);
        }
    }
}

