/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.trendreport;

import com.xceptance.common.util.ProductInformation;
import com.xceptance.common.xml.DomUtils;
import com.xceptance.xlt.report.ReportTransformer;
import com.xceptance.xlt.report.trendreport.TestReportByName;
import com.xceptance.xlt.report.trendreport.TrendReportGeneratorConfiguration;
import com.xceptance.xlt.report.trendreport.TrendValue;
import com.xceptance.xlt.report.util.ElementSpecification;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.NoOverlapCategoryAxis;
import com.xceptance.xlt.report.util.ReportUtils;
import com.xceptance.xlt.report.util.TaskManager;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.util.ShapeUtils;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TrendReportGeneratorMain {
    private static final Log log = LogFactory.getLog(TrendReportGeneratorMain.class);
    private TrendReportGeneratorConfiguration config;
    private boolean noCharts;
    private boolean noSorting;
    private Set<TrendValue> initialTrendValues;

    public static void main(String[] args) {
        Locale.setDefault(Locale.US);
        TrendReportGeneratorMain main = new TrendReportGeneratorMain();
        main.run(args);
    }

    private JFreeChart createBasicTrendChart(String chartTitle, String valueAxisTitle, CategoryDataset dataset) {
        com.xceptance.xlt.report.util.CategoryItemRenderer renderer = new com.xceptance.xlt.report.util.CategoryItemRenderer();
        renderer.setSeriesPaint(0, new Color(0xAAAAAA));
        renderer.setSeriesPaint(1, Color.BLUE);
        renderer.setSeriesPaint(2, Color.MAGENTA);
        renderer.setSeriesPaint(3, new Color(43520));
        renderer.setSeriesShape(0, ShapeUtils.createDiamond((float)2.0f));
        renderer.setSeriesShape(1, ShapeUtils.createDiamond((float)2.0f));
        renderer.setSeriesShape(2, ShapeUtils.createDiamond((float)2.0f));
        renderer.setSeriesShape(3, ShapeUtils.createDiamond((float)2.0f));
        NoOverlapCategoryAxis categoryAxis = new NoOverlapCategoryAxis("Report");
        categoryAxis.setCategoryMargin(0.0);
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        categoryAxis.setMaximumCategoryLabelLines(3);
        categoryAxis.setTickMarksVisible(true);
        NumberAxis valueAxis = new NumberAxis(valueAxisTitle);
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        valueAxis.setAutoRangeIncludesZero(this.config.getChartAutoRangeIncludesZero());
        CategoryPlot plot = new CategoryPlot(dataset, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setDomainGridlinesVisible(true);
        JFreeChart jfreechart = JFreeChartUtils.createChart(chartTitle, (Plot)plot);
        return jfreechart;
    }

    private Options createCommandLineOptions() {
        Options options = new Options();
        Option targetDir = new Option("o", true, "the trend report target directory");
        targetDir.setArgName("dir");
        options.addOption(targetDir);
        Option noSorting = new Option("noSorting", false, "disable sorting the input reports by their test start time");
        options.addOption(noSorting);
        Option noCharts = new Option("noCharts", false, "disables generation of charts");
        options.addOption(noCharts);
        return options;
    }

    private void createErrorTrendChart(String timerName, CategoryDataset dataset, File outputDir, int chartWidth, int chartHeight) {
        System.out.printf("Creating errors trend chart for timer '%s' ...\n", timerName);
        JFreeChart jfreeChart = this.createBasicTrendChart(timerName, "Errors", dataset);
        jfreeChart.getCategoryPlot().getRenderer().setSeriesPaint(0, (Paint)Color.RED);
        JFreeChartUtils.saveChart(jfreeChart, timerName + "_Errors", outputDir, chartWidth, chartHeight);
    }

    private void createInitialTrendValues(String[] directoryPathNames) throws ParseException, IOException {
        HashSet<String> reportDirs = new HashSet<String>();
        HashSet<String> reportNames = new HashSet<String>();
        for (String directoryPathName : directoryPathNames) {
            File reportDir = new File(directoryPathName);
            String reportPath = reportDir.getAbsolutePath();
            if (reportDirs.contains(reportPath)) continue;
            reportDirs.add(reportPath);
            String key = reportDir.getName();
            if (reportNames.contains(key)) {
                key = TrendReportGeneratorMain.computeNewKey(reportNames, key);
            }
            reportNames.add(key);
            Map<String, String> reportDateAndComment = this.getReportDateAndCommentFromFile(reportDir);
            if (reportDateAndComment == null) continue;
            Date reportDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z", Locale.ENGLISH).parse(reportDateAndComment.get("reportDate"));
            String reportComment = reportDateAndComment.get("reportComment");
            this.initialTrendValues.add(new TrendValue(null, null, null, null, key, reportDate, reportComment, null, null));
        }
    }

    private Map<String, String> getReportDateAndCommentFromFile(File dir) throws IOException, ParseException {
        HashMap<String, String> testReportData = new HashMap<String, String>();
        File file = new File(dir, "testreport.xml");
        if (file.isFile()) {
            String fileContent = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            testReportData.put("reportDate", fileContent.substring(fileContent.indexOf("<startTime>") + 11, fileContent.indexOf("</startTime>")));
            testReportData.put("reportComment", this.parseCommentFromFileContent(fileContent));
            return testReportData;
        }
        log.warn((Object)("The specified directory '" + dir + "' does not seem to be a valid test report directory. Skipping it."));
        return null;
    }

    private String parseCommentFromFileContent(String fileContent) {
        if (fileContent.contains("<comments/>")) {
            return null;
        }
        String subStringComment = fileContent.substring(fileContent.indexOf("<comments>"), fileContent.indexOf("</comments>"));
        return subStringComment.substring(subStringComment.indexOf("<string>") + 8, subStringComment.indexOf("</string>"));
    }

    private void createRunTimeTrendChart(String timerName, CategoryDataset dataset, File outputDir, int chartWidth, int chartHeight) {
        System.out.printf("Creating run time trend chart for timer '%s' ...\n", timerName);
        JFreeChart jfreeChart = this.createBasicTrendChart(timerName, "Run Time [ms]", dataset);
        JFreeChartUtils.saveChart(jfreeChart, timerName + "_RunTime", outputDir, chartWidth, chartHeight);
    }

    private void createThroughputTrendChart(String timerName, CategoryDataset dataset, File outputDir, int chartWidth, int chartHeight) {
        System.out.printf("Creating throughput trend chart for timer '%s' ...\n", timerName);
        JFreeChart jfreeChart = this.createBasicTrendChart(timerName, "Throughput", dataset);
        jfreeChart.getCategoryPlot().getRenderer().setSeriesPaint(0, (Paint)Color.BLUE);
        jfreeChart.getCategoryPlot().getRangeAxis().setStandardTickUnits(NumberAxis.createStandardTickUnits());
        JFreeChartUtils.saveChart(jfreeChart, timerName + "_Throughput", outputDir, chartWidth, chartHeight);
    }

    private void createTrendCharts(Map<String, Set<TrendValue>> trendValuesByTimerName, final File outputDir) throws IOException, InterruptedException {
        if (this.noCharts) {
            return;
        }
        final int chartWidth = this.config.getChartWidth();
        final int chartHeight = this.config.getChartHeight();
        FileUtils.forceMkdir((File)outputDir);
        TaskManager taskManager = TaskManager.getInstance();
        for (Map.Entry<String, Set<TrendValue>> entry : trendValuesByTimerName.entrySet()) {
            final String name = entry.getKey();
            Set<TrendValue> trendValues = entry.getValue();
            final DefaultCategoryDataset runTimeDataSet = new DefaultCategoryDataset();
            final DefaultCategoryDataset errorDataSet = new DefaultCategoryDataset();
            final DefaultCategoryDataset throughputDataSet = new DefaultCategoryDataset();
            for (TrendValue value : trendValues) {
                runTimeDataSet.setValue((Number)value.maximum, (Comparable)((Object)"Maximum"), (Comparable)((Object)value.reportName));
                runTimeDataSet.setValue((Number)value.mean, (Comparable)((Object)"Mean"), (Comparable)((Object)value.reportName));
                runTimeDataSet.setValue((Number)value.median, (Comparable)((Object)"Median"), (Comparable)((Object)value.reportName));
                runTimeDataSet.setValue((Number)value.minimum, (Comparable)((Object)"Minimum"), (Comparable)((Object)value.reportName));
                errorDataSet.setValue((Number)value.errors, (Comparable)((Object)"Errors"), (Comparable)((Object)value.reportName));
                throughputDataSet.setValue((Number)value.countPerSecond, (Comparable)((Object)"Count/s"), (Comparable)((Object)value.reportName));
            }
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    TrendReportGeneratorMain.this.createRunTimeTrendChart(name, (CategoryDataset)runTimeDataSet, outputDir, chartWidth, chartHeight);
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    TrendReportGeneratorMain.this.createErrorTrendChart(name, (CategoryDataset)errorDataSet, outputDir, chartWidth, chartHeight);
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    TrendReportGeneratorMain.this.createThroughputTrendChart(name, (CategoryDataset)throughputDataSet, outputDir, chartWidth, chartHeight);
                }
            });
        }
        taskManager.waitForAllTasksToComplete();
    }

    private void createTrendElements(Map<String, Set<TrendValue>> trendValuesByTimerName, String tagName, Element parentElement) {
        for (Map.Entry<String, Set<TrendValue>> entry : trendValuesByTimerName.entrySet()) {
            String timerName = entry.getKey();
            Set<TrendValue> trendValues = entry.getValue();
            Element element = ReportUtils.addTextElement(tagName, null, parentElement);
            ReportUtils.addTextElement("name", timerName, element);
            Element trendValuesElement = ReportUtils.addTextElement("trendValues", null, element);
            for (TrendValue trendValue : trendValues) {
                Element trendValueElement = ReportUtils.addTextElement("trendValue", null, trendValuesElement);
                ReportUtils.addTextElement("median", ReportUtils.formatValue(trendValue.median), trendValueElement);
                ReportUtils.addTextElement("mean", ReportUtils.formatValue(trendValue.mean), trendValueElement);
                ReportUtils.addTextElement("min", String.valueOf(trendValue.minimum), trendValueElement);
                ReportUtils.addTextElement("max", String.valueOf(trendValue.maximum), trendValueElement);
                ReportUtils.addTextElement("errors", String.valueOf(trendValue.errors), trendValueElement);
                ReportUtils.addTextElement("throughput", ReportUtils.formatValue(trendValue.countPerSecond), trendValueElement);
                ReportUtils.addTextElement("reportName", String.valueOf(trendValue.reportName), trendValueElement);
                ReportUtils.addTextElement("reportDate", String.valueOf(trendValue.reportDate), trendValueElement);
                ReportUtils.addTextElement("reportComments", trendValue.reportComment, trendValueElement);
            }
        }
    }

    private void readDataFromTestReport(Map<String, Set<TrendValue>> trendValuesByTimerName, TestReportByName testReportByName, String currentTagName, ElementSpecification elementSpec) throws IOException, InterruptedException, ParseException {
        String reportName = testReportByName.getReportName();
        Document testReport = testReportByName.getTestReport();
        Map<String, Element> elementsByTimerName = ReportUtils.filterElements(testReport, elementSpec);
        block0: for (Map.Entry<String, Element> elementEntry : elementsByTimerName.entrySet()) {
            String timerName = elementEntry.getKey();
            Element element = elementEntry.getValue();
            Set<TrendValue> trendValues = trendValuesByTimerName.get(timerName);
            if (trendValues == null) {
                trendValues = this.noSorting ? new LinkedHashSet() : new TreeSet();
                for (TrendValue value : this.initialTrendValues) {
                    trendValues.add(new TrendValue(null, null, null, null, value.reportName, value.reportDate, value.reportComment, null, null));
                }
                trendValuesByTimerName.put(timerName, trendValues);
            }
            int min = ReportUtils.getChildElementTextAsInt(element, "min");
            int max = ReportUtils.getChildElementTextAsInt(element, "max");
            double median = ReportUtils.getChildElementTextAsDouble(element, "median");
            double mean = ReportUtils.getChildElementTextAsDouble(element, "mean");
            int errors = ReportUtils.getChildElementTextAsInt(element, "errors");
            double countPerSecond = ReportUtils.getChildElementTextAsDouble(element, "countPerSecond");
            for (TrendValue trendValue : trendValues) {
                if (!trendValue.reportName.equals(reportName)) continue;
                trendValue.minimum = min;
                trendValue.maximum = max;
                trendValue.median = median;
                trendValue.mean = mean;
                trendValue.errors = errors;
                trendValue.countPerSecond = countPerSecond;
                continue block0;
            }
        }
    }

    private Document createTrendReport(File outputDir, Map<String, Map<String, Set<TrendValue>>> trendValuesByTimerNameByTagName) throws IOException, ParserConfigurationException, InterruptedException {
        File chartsDir = new File(outputDir, "charts");
        if (!this.noCharts) {
            FileUtils.forceMkdir((File)chartsDir);
            JFreeChartUtils.createPlaceholderChart(chartsDir, this.config.getChartWidth(), this.config.getChartHeight());
        }
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document trendReport = builder.getDOMImplementation().createDocument(null, "trendreport", null);
        Element rootElement = trendReport.getDocumentElement();
        Element transactionsElement = ReportUtils.addTextElement("transactions", null, rootElement);
        Element actionsElement = ReportUtils.addTextElement("actions", null, rootElement);
        Element requestsElement = ReportUtils.addTextElement("requests", null, rootElement);
        Element pageLoadTimingsElement = ReportUtils.addTextElement("pageLoadTimings", null, rootElement);
        Element customTimersElement = ReportUtils.addTextElement("customTimers", null, rootElement);
        Element summaryElement = ReportUtils.addTextElement("summary", null, rootElement);
        Map<String, Set<TrendValue>> trendValuesByTimerName = trendValuesByTimerNameByTagName.get("transaction");
        this.createTrendElements(trendValuesByTimerName, "transaction", transactionsElement);
        this.createTrendCharts(trendValuesByTimerName, new File(chartsDir, "transactions"));
        trendValuesByTimerName = trendValuesByTimerNameByTagName.get("action");
        this.createTrendElements(trendValuesByTimerName, "action", actionsElement);
        this.createTrendCharts(trendValuesByTimerName, new File(chartsDir, "actions"));
        trendValuesByTimerName = trendValuesByTimerNameByTagName.get("request");
        this.createTrendElements(trendValuesByTimerName, "request", requestsElement);
        this.createTrendCharts(trendValuesByTimerName, new File(chartsDir, "requests"));
        trendValuesByTimerName = trendValuesByTimerNameByTagName.get("pageLoadTiming");
        this.createTrendElements(trendValuesByTimerName, "pageLoadTiming", pageLoadTimingsElement);
        this.createTrendCharts(trendValuesByTimerName, new File(chartsDir, "pageLoadTimings"));
        trendValuesByTimerName = trendValuesByTimerNameByTagName.get("customTimer");
        this.createTrendElements(trendValuesByTimerName, "customTimer", customTimersElement);
        this.createTrendCharts(trendValuesByTimerName, new File(chartsDir, "custom"));
        trendValuesByTimerName = trendValuesByTimerNameByTagName.get("transactions");
        this.createTrendElements(trendValuesByTimerName, "transactions", summaryElement);
        this.createTrendCharts(trendValuesByTimerName, new File(chartsDir, "summary"));
        trendValuesByTimerName = trendValuesByTimerNameByTagName.get("actions");
        this.createTrendElements(trendValuesByTimerName, "actions", summaryElement);
        this.createTrendCharts(trendValuesByTimerName, new File(chartsDir, "summary"));
        trendValuesByTimerName = trendValuesByTimerNameByTagName.get("requests");
        this.createTrendElements(trendValuesByTimerName, "requests", summaryElement);
        this.createTrendCharts(trendValuesByTimerName, new File(chartsDir, "summary"));
        trendValuesByTimerName = trendValuesByTimerNameByTagName.get("pageLoadTimings");
        this.createTrendElements(trendValuesByTimerName, "pageLoadTimings", summaryElement);
        this.createTrendCharts(trendValuesByTimerName, new File(chartsDir, "summary"));
        trendValuesByTimerName = trendValuesByTimerNameByTagName.get("customTimers");
        this.createTrendElements(trendValuesByTimerName, "customTimers", summaryElement);
        this.createTrendCharts(trendValuesByTimerName, new File(chartsDir, "summary"));
        return trendReport;
    }

    private void printUsageInfoAndExit(Options options) {
        System.out.println("\nCreates a trend report from multiple test reports.");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("Usage: ");
        formatter.setWidth(79);
        System.out.println();
        formatter.printHelp("create_trend_report [options] <testReportDir_1> ... <testReportDir_n>", "\nOptions:", options, null);
        System.out.println();
        System.exit(2);
    }

    private Document readTestReport(File dir) throws ParserConfigurationException, SAXException, IOException {
        System.out.println("Reading report from directory: " + dir);
        File file = new File(dir, "testreport.xml");
        if (file.isFile()) {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.parse(file);
        }
        log.warn((Object)("The specified directory '" + dir + "' does not seem to be a valid test report directory. Skipping it."));
        return null;
    }

    private TestReportByName readTestReport(String directoryPathName, HashSet<String> reportDirs, HashSet<String> reportNames) throws ParserConfigurationException, SAXException, IOException {
        Document testReport;
        File reportDir = new File(directoryPathName);
        String reportPath = reportDir.getAbsolutePath();
        if (reportDirs.contains(reportPath)) {
            return null;
        }
        reportDirs.add(reportPath);
        String key = reportDir.getName();
        if (reportNames.contains(key)) {
            key = TrendReportGeneratorMain.computeNewKey(reportNames, key);
            reportNames.add(key);
        }
        if ((testReport = this.readTestReport(reportDir)) == null) {
            return null;
        }
        return new TestReportByName(key, testReport);
    }

    private void readDataFromTestReport(Map<String, Map<String, Set<TrendValue>>> trendValuesByTimerNameByTagName, TestReportByName testReportByName) throws IOException, InterruptedException, ParseException {
        String currentTagName = "transaction";
        this.readDataFromTestReport(this.getTrendValuesByTimerNameByTagName(trendValuesByTimerNameByTagName, currentTagName), testReportByName, currentTagName, new ElementSpecification("/testreport/transactions/transaction", "name"));
        currentTagName = "action";
        this.readDataFromTestReport(this.getTrendValuesByTimerNameByTagName(trendValuesByTimerNameByTagName, currentTagName), testReportByName, currentTagName, new ElementSpecification("/testreport/actions/action", "name"));
        currentTagName = "request";
        this.readDataFromTestReport(this.getTrendValuesByTimerNameByTagName(trendValuesByTimerNameByTagName, currentTagName), testReportByName, currentTagName, new ElementSpecification("/testreport/requests/request", "name"));
        currentTagName = "pageLoadTiming";
        this.readDataFromTestReport(this.getTrendValuesByTimerNameByTagName(trendValuesByTimerNameByTagName, currentTagName), testReportByName, currentTagName, new ElementSpecification("/testreport/pageLoadTimings/pageLoadTiming", "name"));
        currentTagName = "customTimer";
        this.readDataFromTestReport(this.getTrendValuesByTimerNameByTagName(trendValuesByTimerNameByTagName, currentTagName), testReportByName, currentTagName, new ElementSpecification("/testreport/customTimers/customTimer", "name"));
        currentTagName = "transactions";
        this.readDataFromTestReport(this.getTrendValuesByTimerNameByTagName(trendValuesByTimerNameByTagName, currentTagName), testReportByName, currentTagName, new ElementSpecification("/testreport/summary/transactions", "name"));
        currentTagName = "actions";
        this.readDataFromTestReport(this.getTrendValuesByTimerNameByTagName(trendValuesByTimerNameByTagName, currentTagName), testReportByName, currentTagName, new ElementSpecification("/testreport/summary/actions", "name"));
        currentTagName = "requests";
        this.readDataFromTestReport(this.getTrendValuesByTimerNameByTagName(trendValuesByTimerNameByTagName, currentTagName), testReportByName, currentTagName, new ElementSpecification("/testreport/summary/requests", "name"));
        currentTagName = "pageLoadTimings";
        this.readDataFromTestReport(this.getTrendValuesByTimerNameByTagName(trendValuesByTimerNameByTagName, currentTagName), testReportByName, currentTagName, new ElementSpecification("/testreport/summary/pageLoadTimings", "name"));
        currentTagName = "customTimers";
        this.readDataFromTestReport(this.getTrendValuesByTimerNameByTagName(trendValuesByTimerNameByTagName, currentTagName), testReportByName, currentTagName, new ElementSpecification("/testreport/summary/customTimers", "name"));
    }

    private Map<String, Set<TrendValue>> getTrendValuesByTimerNameByTagName(Map<String, Map<String, Set<TrendValue>>> trendValuesByTimerNameByTagName, String tagName) {
        Map<String, Set<TrendValue>> trendValuesByTimerName = trendValuesByTimerNameByTagName.get(tagName);
        if (trendValuesByTimerName == null) {
            trendValuesByTimerName = new TreeMap<String, Set<TrendValue>>();
            trendValuesByTimerNameByTagName.put(tagName, trendValuesByTimerName);
        }
        return trendValuesByTimerName;
    }

    private void run(String[] args) {
        Options options = this.createCommandLineOptions();
        try {
            File outputDir;
            this.config = new TrendReportGeneratorConfiguration();
            CommandLine commandLine = new DefaultParser().parse(options, args);
            this.noCharts = commandLine.hasOption("noCharts");
            this.noSorting = commandLine.hasOption("noSorting");
            String outputDirName = commandLine.getOptionValue("o");
            if (outputDirName == null) {
                String defaultOutputDirName = "trendreport-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
                File reportsDir = this.config.getReportsRootDirectory();
                outputDir = new File(reportsDir, defaultOutputDirName);
            } else {
                outputDir = new File(outputDirName);
            }
            String[] remainingArgs = commandLine.getArgs();
            if (remainingArgs.length < 2) {
                this.printUsageInfoAndExit(options);
            }
            TaskManager.getInstance().setMaximumThreadCount(this.config.getThreadCount());
            FileUtils.forceMkdir((File)outputDir);
            this.initialTrendValues = this.noSorting ? new LinkedHashSet() : new TreeSet();
            this.createInitialTrendValues(remainingArgs);
            HashMap<String, Map<String, Set<TrendValue>>> trendValuesByTimerNameByTagName = new HashMap<String, Map<String, Set<TrendValue>>>();
            HashSet<String> reportDirs = new HashSet<String>();
            HashSet<String> reportNames = new HashSet<String>();
            LinkedList<Document> documents = new LinkedList<Document>();
            for (String remainingArg : remainingArgs) {
                TestReportByName testReportByName = this.readTestReport(remainingArg, reportDirs, reportNames);
                if (testReportByName == null) continue;
                this.readDataFromTestReport(trendValuesByTimerNameByTagName, testReportByName);
                documents.add(testReportByName.getTestReport());
            }
            System.out.println("Creating the XML trend report ...");
            Document trendReport = this.createTrendReport(outputDir, trendValuesByTimerNameByTagName);
            File xmlFile = new File(outputDir, "trendreport.xml");
            this.writeTrendReport(trendReport, xmlFile);
            System.out.println("Rendering the HTML trend report ...");
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("productName", ProductInformation.getProductInformation().getProductName());
            parameters.put("productVersion", ProductInformation.getProductInformation().getVersion());
            parameters.put("productUrl", ProductInformation.getProductInformation().getProductURL());
            parameters.put("projectName", ReportUtils.obtainProjectName(documents));
            ArrayList<File> outputFiles = new ArrayList<File>();
            ArrayList<File> styleSheetFiles = new ArrayList<File>();
            List<String> styleSheetFileNames = this.config.getStyleSheetFileNames();
            List<String> outputFileNames = this.config.getOutputFileNames();
            for (int i = 0; i < styleSheetFileNames.size(); ++i) {
                File outputFile = new File(outputDir, outputFileNames.get(i));
                outputFiles.add(outputFile);
                File styleSheetFile = new File(new File(this.config.getConfigDirectory(), "xsl/trendreport"), styleSheetFileNames.get(i));
                styleSheetFiles.add(styleSheetFile);
            }
            ReportTransformer reportTransformer = new ReportTransformer(outputFiles, styleSheetFiles, parameters);
            reportTransformer.run(xmlFile, outputDir);
            File resourcesDir = new File(this.config.getConfigDirectory(), "testreport");
            FileUtils.copyDirectory((File)resourcesDir, (File)outputDir, (FileFilter)FileFilterUtils.makeSVNAware(null), (boolean)true);
            File reportFile = new File(outputDir, "index.html");
            String reportPath = ReportUtils.toString(reportFile);
            TaskManager.getInstance().waitForAllTasksToComplete();
            System.out.println("\nReport: " + reportPath);
            System.exit(0);
        }
        catch (org.apache.commons.cli.ParseException ex) {
            this.printUsageInfoAndExit(options);
        }
        catch (Exception ex) {
            log.fatal((Object)"Failed to run trend report generator.", (Throwable)ex);
            System.exit(1);
        }
    }

    private void writeTrendReport(Document trendReport, File file) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            osw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            DomUtils.prettyPrintNode((Node)trendReport, osw);
        }
    }

    private static String computeNewKey(Set<String> knownKeys, String key) {
        String format = key.concat("(%d)");
        int i = 2;
        String newKey = String.format(format, i);
        while (knownKeys.contains(newKey)) {
            newKey = String.format(format, ++i);
        }
        return newKey;
    }
}

