/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.xlt.report.util.Apdex;
import com.xceptance.xlt.report.util.ReportUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class ApdexCalculator {
    private final BigDecimal threshold;
    private final long satisfyingThresholdInMsecs;
    private final long toleratedThresholdInMsecs;
    private long satisfyingSamplesCount;
    private long toleratedSamplesCount;
    private long totalSamplesCount;

    public ApdexCalculator(double thresholdInSecs) {
        BigDecimal temp = new BigDecimal(thresholdInSecs, new MathContext(2, RoundingMode.HALF_EVEN));
        int newScale = 2 - temp.precision() + temp.scale();
        this.threshold = temp.setScale(newScale, RoundingMode.HALF_EVEN);
        this.satisfyingThresholdInMsecs = (long)(this.threshold.doubleValue() * 1000.0);
        this.toleratedThresholdInMsecs = 4L * this.satisfyingThresholdInMsecs;
    }

    public void addSample(long runtime, boolean failed) {
        ++this.totalSamplesCount;
        if (!failed) {
            if (runtime <= this.satisfyingThresholdInMsecs) {
                ++this.satisfyingSamplesCount;
            } else if (runtime <= this.toleratedThresholdInMsecs) {
                ++this.toleratedSamplesCount;
            }
        }
    }

    public Apdex getApdex() {
        double tempApdex = this.totalSamplesCount == 0L ? 0.0 : ((double)this.satisfyingSamplesCount + (double)this.toleratedSamplesCount / 2.0) / (double)this.totalSamplesCount;
        BigDecimal apdex = ReportUtils.convertToBigDecimal(tempApdex, 2);
        return new Apdex(apdex, this.threshold, this.totalSamplesCount);
    }
}

