/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.xlt.report.util.LowPrecisionDoubleValueSet;

public class DoubleMinMaxValue {
    private double accumulatedValue;
    private double maximum;
    private double minimum;
    private int valueCount;
    private final LowPrecisionDoubleValueSet valueSet = new LowPrecisionDoubleValueSet();

    public DoubleMinMaxValue(double value) {
        this.accumulatedValue = value;
        this.maximum = value;
        this.minimum = value;
        this.valueCount = 1;
        this.valueSet.addValue(value);
    }

    public double getAccumulatedValue() {
        return this.accumulatedValue;
    }

    public double getAverageValue() {
        if (this.valueCount > 0) {
            return this.accumulatedValue / (double)this.valueCount;
        }
        return 0.0;
    }

    public double getMaximumValue() {
        return this.maximum;
    }

    public double getMinimumValue() {
        return this.minimum;
    }

    public double getValue() {
        return this.getAverageValue();
    }

    public double[] getValues() {
        return this.valueSet.getValues();
    }

    public int getValueCount() {
        return this.valueCount;
    }

    DoubleMinMaxValue merge(DoubleMinMaxValue item) {
        if (item != null && item.getValueCount() > 0) {
            if (this.valueCount > 0) {
                this.maximum = Math.max(this.maximum, item.maximum);
                this.minimum = Math.min(this.minimum, item.minimum);
            } else {
                this.maximum = item.maximum;
                this.minimum = item.minimum;
            }
            this.accumulatedValue += item.accumulatedValue;
            this.valueCount += item.valueCount;
            this.valueSet.merge(item.valueSet);
        }
        return this;
    }

    public String toString() {
        return "" + this.getValue() + "/" + this.getAccumulatedValue() + "/" + this.getMinimumValue() + "/" + this.getMaximumValue() + "/" + this.getValueCount();
    }

    public void updateValue(double sample) {
        if (this.valueCount > 0) {
            if (sample > this.maximum) {
                this.maximum = sample;
            } else if (sample < this.minimum) {
                this.minimum = sample;
            }
        } else {
            this.maximum = sample;
            this.minimum = sample;
        }
        this.accumulatedValue += sample;
        ++this.valueCount;
        this.valueSet.addValue(sample);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.accumulatedValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maximum);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minimum);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.valueCount;
        result = 31 * result + (this.valueSet == null ? 0 : this.valueSet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleMinMaxValue other = (DoubleMinMaxValue)obj;
        if (Double.doubleToLongBits(this.accumulatedValue) != Double.doubleToLongBits(other.accumulatedValue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maximum) != Double.doubleToLongBits(other.maximum)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minimum) != Double.doubleToLongBits(other.minimum)) {
            return false;
        }
        if (this.valueCount != other.valueCount) {
            return false;
        }
        return !(this.valueSet == null ? other.valueSet != null : !this.valueSet.equals(other.valueSet));
    }
}

