/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.keypoint.PngEncoder;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.util.DotsRenderer;
import com.xceptance.xlt.report.util.DoubleMinMaxTimeSeriesDataItem;
import com.xceptance.xlt.report.util.DoubleMinMaxValue;
import com.xceptance.xlt.report.util.DoubleMinMaxValueSet;
import com.xceptance.xlt.report.util.MinMaxRenderer;
import com.xceptance.xlt.report.util.MinMaxTimeSeriesCollection;
import com.xceptance.xlt.report.util.MinMaxTimeSeriesDataItem;
import com.xceptance.xlt.report.util.MinMaxValue;
import com.xceptance.xlt.report.util.MinMaxValueSet;
import com.xceptance.xlt.report.util.TimeSeriesConfiguration;
import com.xceptance.xlt.report.util.ValueSet;
import com.xceptance.xlt.report.util.XltChartTheme;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalDataItem;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;

public final class JFreeChartUtils {
    public static final Color COLOR_CAP = new Color(0xAA0000);
    public static final Color COLOR_ERROR = Color.RED;
    public static final Color COLOR_EVENT = new Color(16753920);
    public static final Color COLOR_HISTOGRAM = new Color(8569213);
    public static final Color COLOR_LINE = new Color(0xAAAAAA);
    public static final Color COLOR_LINE_DIMMED = new Color(0xDDDDDD);
    public static final Color COLOR_MEAN = new Color(0xCD3333);
    public static final Color COLOR_MEDIAN = new Color(6471904);
    public static final Color COLOR_MOVING_AVERAGE = new Color(1842367);
    private static final XltChartTheme DEFAULT_CHART_THEME = new XltChartTheme();
    private static final String DEFAULT_DATE_AXIS_TITLE = "Time";
    private static final String DEFAULT_VALUE_AXIS_TITLE = "Values";
    private static final Rectangle2D.Double LEGEND_LINE_SHAPE = new Rectangle2D.Double(-7.0, 0.0, 14.0, 1.0);
    private static final Log log = LogFactory.getLog(JFreeChartUtils.class);
    private static final Map<Long, Second> secondsCache = new HashMap<Long, Second>();
    private static final Color WATERMARK_COLOR = new Color(0xABABAB);
    private static final String WATERMARK_TEXT = "Xceptance LoadTest";
    private static int pngCompressionLevel = 6;
    private static final double MIN_VALUE_FOR_LOGARITHMIC_AXES = 1.0E-8;

    public static void addLinePlotToCombinedPlotChart(JFreeChart chart, String rangeAxisTitle, XYDataset dataset) {
        CombinedDomainXYPlot combinedPlot = (CombinedDomainXYPlot)chart.getPlot();
        int subPlotCount = combinedPlot.getSubplots().size();
        int decider = subPlotCount % 3;
        ColorSet colorSet = decider == 0 ? ColorSet.A : (decider == 1 ? ColorSet.B : ColorSet.C);
        XYPlot plot = JFreeChartUtils.createLinePlot(dataset, null, rangeAxisTitle, colorSet);
        combinedPlot.add(plot, 1);
    }

    public static void capPlot(XYPlot plot, int cappingValue, boolean addLegendItem) {
        if (cappingValue > 0) {
            plot.getRangeAxis().setUpperBound((double)cappingValue);
            ValueMarker capMarker = new ValueMarker((double)cappingValue);
            capMarker.setAlpha(1.0f);
            capMarker.setPaint((Paint)COLOR_CAP);
            capMarker.setStroke((Stroke)new BasicStroke(4.0f));
            plot.addRangeMarker((Marker)capMarker);
            if (addLegendItem) {
                LegendItemCollection legendItems = plot.getLegendItems();
                LegendItem capLegendItem = new LegendItem("Cap", (Paint)COLOR_CAP);
                capLegendItem.setShape((Shape)new Rectangle2D.Double(-7.0, 0.0, 14.0, 2.0));
                legendItems.add(capLegendItem);
                plot.setFixedLegendItems(legendItems);
            }
        }
    }

    public static JFreeChart createAverageLineChart(String seriesName, String chartTitle, String yAxisTitle, TimeSeries valueSeries, TimeSeries averageValueSeries, double median, double mean, long startTime, long endTime) {
        TimeSeries medianSeries = new TimeSeries((Comparable)((Object)(seriesName + " (Median)")));
        TimeSeries meanSeries = new TimeSeries((Comparable)((Object)(seriesName + " (Mean)")));
        TimeSeriesCollection seriesCollection = new TimeSeriesCollection();
        seriesCollection.addSeries(averageValueSeries);
        seriesCollection.addSeries(medianSeries);
        seriesCollection.addSeries(meanSeries);
        int count = valueSeries.getItemCount();
        if (count > 1) {
            TimeSeriesDataItem firstItem = valueSeries.getDataItem(0);
            TimeSeriesDataItem lastItem = valueSeries.getDataItem(count - 1);
            medianSeries.add(firstItem.getPeriod(), median);
            medianSeries.add(lastItem.getPeriod(), median);
            meanSeries.add(firstItem.getPeriod(), mean);
            meanSeries.add(lastItem.getPeriod(), mean);
        }
        JFreeChart chart = JFreeChartUtils.createLineChart(chartTitle, yAxisTitle, seriesCollection, startTime, endTime, ColorSet.AVERAGES);
        NumberAxis axis = (NumberAxis)chart.getXYPlot().getRangeAxis();
        axis.setAutoRangeIncludesZero(false);
        axis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        return chart;
    }

    public static JFreeChart createBarChart(String chartTitle, XYDataset dataset, String rangeAxisTitle, Color barColor, long startTime, long endTime) {
        DateAxis timeAxis = JFreeChartUtils.createTimeAxis(startTime, endTime);
        XYPlot barPlot = JFreeChartUtils.createBarPlot(dataset, (ValueAxis)timeAxis, rangeAxisTitle, barColor);
        return JFreeChartUtils.createChart(chartTitle, (Plot)barPlot);
    }

    public static JFreeChart createBarChart(String chartTitle, XYDataset dataset, String rangeAxisTitle, Color barColor, long startTime, long endTime, boolean createLegend, boolean createTimeAxis) {
        DateAxis timeAxis = new DateAxis();
        if (createTimeAxis) {
            timeAxis = JFreeChartUtils.createTimeAxis(startTime, endTime);
        }
        JFreeChartUtils.updateDateAxisMinMaxTime(timeAxis, startTime, endTime);
        NumberAxis rangeAxis = new NumberAxis();
        if (rangeAxisTitle != null) {
            rangeAxis = new NumberAxis(rangeAxisTitle);
        }
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYPlot barPlot = JFreeChartUtils.createBarPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)rangeAxis, barColor);
        return new JFreeChart(chartTitle, JFreeChart.DEFAULT_TITLE_FONT, (Plot)barPlot, createLegend);
    }

    public static XYPlot createBarPlot(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, Color barColor) {
        return new XYPlot(dataset, domainAxis, rangeAxis, (XYItemRenderer)JFreeChartUtils.createBarRenderer(barColor));
    }

    public static XYPlot createBarPlot(XYDataset dataset, ValueAxis domainAxis, String rangeAxisTitle, Color barColor) {
        return new XYPlot(dataset, domainAxis, (ValueAxis)JFreeChartUtils.createNumberAxis(rangeAxisTitle), (XYItemRenderer)JFreeChartUtils.createBarRenderer(barColor));
    }

    public static XYBarRenderer createBarRenderer(Color barColor) {
        XYBarRenderer barRenderer = new XYBarRenderer();
        barRenderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        barRenderer.setSeriesPaint(0, (Paint)barColor);
        barRenderer.setShadowVisible(false);
        return barRenderer;
    }

    public static JFreeChart createBasicLineChart(String chartTitle, String timeAxisTitle, long startTime, long endTime) {
        DateAxis timeAxis = JFreeChartUtils.createTimeAxis(timeAxisTitle, startTime, endTime);
        XYLineAndShapeRenderer lineRenderer = JFreeChartUtils.createLineRenderer(ColorSet.A);
        XYPlot plot = new XYPlot(null, (ValueAxis)timeAxis, null, (XYItemRenderer)lineRenderer);
        return JFreeChartUtils.createChart(chartTitle, (Plot)plot);
    }

    public static JFreeChart createChart(String chartTitle, Plot plot) {
        JFreeChart jfreechart = new JFreeChart(chartTitle, plot);
        return jfreechart;
    }

    public static CombinedDomainXYPlot createCombinedPlot(long startTime, long endTime) {
        CombinedDomainXYPlot combinedPlot = new CombinedDomainXYPlot((ValueAxis)JFreeChartUtils.createTimeAxis(startTime, endTime));
        combinedPlot.setGap(16.0);
        return combinedPlot;
    }

    public static JFreeChart createCombinedPlotChart(String chartTitle, long startTime, long endTime) {
        return JFreeChartUtils.createChart(chartTitle, (Plot)JFreeChartUtils.createCombinedPlot(startTime, endTime));
    }

    public static XYPlot createHistogramPlot(XYIntervalSeries histogramSeries, Range range, ReportGeneratorConfiguration.ChartScale chartScale, int plotCappingValue) {
        if (chartScale == ReportGeneratorConfiguration.ChartScale.LOGARITHMIC) {
            JFreeChartUtils.adjustSeriesForLogarithmicAxes(histogramSeries);
        }
        XYIntervalSeriesCollection dataset = new XYIntervalSeriesCollection();
        dataset.addSeries(histogramSeries);
        NumberAxis domainAxis = new NumberAxis();
        domainAxis.setVisible(false);
        LogarithmicAxis rangeAxis = chartScale == ReportGeneratorConfiguration.ChartScale.LOGARITHMIC ? new LogarithmicAxis(null) : new NumberAxis();
        rangeAxis.setVisible(false);
        rangeAxis.setRange(range);
        XYBarRenderer barRenderer = JFreeChartUtils.createBarRenderer(COLOR_HISTOGRAM);
        barRenderer.setUseYInterval(true);
        XYPlot histogramPlot = new XYPlot((XYDataset)dataset, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)barRenderer);
        histogramPlot.setDomainGridlinesVisible(false);
        JFreeChartUtils.capPlot(histogramPlot, plotCappingValue, true);
        return histogramPlot;
    }

    public static JFreeChart createLineChart(String chartTitle, String rangeAxisTitle, TimeSeries series, long startTime, long endTime, boolean includeMovingAverage, int percentage) {
        return JFreeChartUtils.createLineChart(chartTitle, rangeAxisTitle, series, startTime, endTime, includeMovingAverage, percentage, true);
    }

    public static JFreeChart createLineChart(String chartTitle, String rangeAxisTitle, TimeSeries series, long startTime, long endTime, boolean includeMovingAverage, int percentage, boolean showDots) {
        TimeSeries movingAverageSeries = includeMovingAverage ? JFreeChartUtils.createMovingAverageTimeSeries(series, percentage) : null;
        return JFreeChartUtils.createLineChart(chartTitle, rangeAxisTitle, series, movingAverageSeries, startTime, endTime, showDots, ReportGeneratorConfiguration.ChartScale.LINEAR, -1);
    }

    public static JFreeChart createLineChart(String chartTitle, String rangeAxisTitle, TimeSeries timeSeries, TimeSeries movingAverageTimeSeries, long startTime, long endTime, boolean showDots, ReportGeneratorConfiguration.ChartScale chartScale, int cappingValue) {
        DateAxis timeAxis = JFreeChartUtils.createTimeAxis(startTime, endTime);
        XYPlot linePlot = JFreeChartUtils.createLinePlot(timeSeries, movingAverageTimeSeries, (ValueAxis)timeAxis, rangeAxisTitle, showDots, chartScale, cappingValue);
        return JFreeChartUtils.createChart(chartTitle, (Plot)linePlot);
    }

    public static XYPlot createLinePlot(TimeSeries series, TimeSeries movingAverageSeries, ValueAxis domainAxis, String rangeAxisTitle, boolean showDots, ReportGeneratorConfiguration.ChartScale chartScale, int cappingValue) {
        if (chartScale == ReportGeneratorConfiguration.ChartScale.LOGARITHMIC) {
            JFreeChartUtils.adjustSeriesForLogarithmicAxes(series);
            JFreeChartUtils.adjustSeriesForLogarithmicAxes(movingAverageSeries);
        }
        LogarithmicAxis rangeAxis = chartScale == ReportGeneratorConfiguration.ChartScale.LOGARITHMIC ? new LogarithmicAxis(rangeAxisTitle) : new NumberAxis(rangeAxisTitle);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYPlot plot = new XYPlot(null, domainAxis, (ValueAxis)rangeAxis, null);
        if (movingAverageSeries != null) {
            XYLineAndShapeRenderer movingAverageLineRenderer = JFreeChartUtils.createLineRenderer(COLOR_MOVING_AVERAGE);
            plot.setRenderer(0, (XYItemRenderer)movingAverageLineRenderer);
            plot.setDataset(0, (XYDataset)new TimeSeriesCollection(movingAverageSeries));
        }
        if (showDots) {
            DotsRenderer dotsRenderer = new DotsRenderer();
            dotsRenderer.setSeriesPaint(0, COLOR_LINE);
            dotsRenderer.setDotWidth(2);
            dotsRenderer.setDotHeight(2);
            plot.setRenderer(1, (XYItemRenderer)dotsRenderer);
            plot.setDataset(1, (XYDataset)new MinMaxTimeSeriesCollection(series));
        }
        Color lineColor = showDots ? COLOR_LINE_DIMMED : COLOR_LINE;
        XYLineAndShapeRenderer lineRenderer = JFreeChartUtils.createLineRenderer(lineColor);
        lineRenderer.setSeriesVisibleInLegend(0, Boolean.valueOf(!showDots));
        plot.setRenderer(2, (XYItemRenderer)lineRenderer);
        plot.setDataset(2, (XYDataset)new MinMaxTimeSeriesCollection(series));
        JFreeChartUtils.capPlot(plot, cappingValue, false);
        return plot;
    }

    public static JFreeChart createLineChart(String chartTitle, String rangeAxisTitle, TimeSeriesCollection collection, long startTime, long endTime) {
        return JFreeChartUtils.createLineChart(chartTitle, rangeAxisTitle, collection, startTime, endTime, ColorSet.A);
    }

    public static JFreeChart createLineChart(String chartTitle, String rangeAxisTitle, TimeSeriesCollection dataset, long startTime, long endTime, ColorSet colorSet) {
        DateAxis timeAxis = JFreeChartUtils.createTimeAxis(startTime, endTime);
        XYPlot linePlot = JFreeChartUtils.createLinePlot((XYDataset)dataset, (ValueAxis)timeAxis, rangeAxisTitle, colorSet);
        return JFreeChartUtils.createChart(chartTitle, (Plot)linePlot);
    }

    public static XYPlot createLinePlot(XYDataset dataset, ValueAxis domainAxis, String rangeAxisTitle, ColorSet colorSet) {
        return new XYPlot(dataset, domainAxis, (ValueAxis)JFreeChartUtils.createNumberAxis(rangeAxisTitle), (XYItemRenderer)JFreeChartUtils.createLineRenderer(colorSet));
    }

    public static XYLineAndShapeRenderer createLineRenderer(ColorSet colorSet) {
        MinMaxRenderer renderer = new MinMaxRenderer(true, false);
        renderer.setLegendLine(LEGEND_LINE_SHAPE);
        if (colorSet != null) {
            int index = 0;
            for (Color color : colorSet.getColors()) {
                renderer.setSeriesPaint(index++, color);
            }
        }
        return renderer;
    }

    public static XYLineAndShapeRenderer createLineRenderer(Color color) {
        return JFreeChartUtils.createLineRenderer(new ColorSet(color));
    }

    public static TimeSeries createMovingAverageTimeSeries(TimeSeries series, int percentage) {
        int samples = Math.max(2, series.getItemCount() * percentage / 100);
        String avgSeriesName = series.getKey() + " (Moving Average)";
        return MovingAverage.createPointMovingAverage((TimeSeries)series, (String)avgSeriesName, (int)samples);
    }

    public static NumberAxis createNumberAxis(String axisTitle) {
        if (StringUtils.isBlank((CharSequence)axisTitle)) {
            axisTitle = DEFAULT_VALUE_AXIS_TITLE;
        }
        NumberAxis numberAxis = new NumberAxis(axisTitle);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return numberAxis;
    }

    public static void createPlaceholderChart(File outputDir, int width, int height) {
        File outputFile = new File(outputDir, "placeholder.png");
        try {
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            Graphics2D graphics = bufferedImage.createGraphics();
            graphics.setBackground((Color)DEFAULT_CHART_THEME.getChartBackgroundPaint());
            graphics.clearRect(0, 0, width, height);
            Font font = new Font("SansSerif", 1, 32);
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int stringWidth = fontMetrics.stringWidth("Loading chart...");
            int stringHeight = fontMetrics.getAscent();
            graphics.setPaint(new Color(0xCCCCCC));
            graphics.drawString("Loading chart...", (width - stringWidth) / 2, height / 2 + stringHeight / 4);
            graphics.dispose();
            byte[] bytes = new PngEncoder((Image)bufferedImage, false, 0, pngCompressionLevel).pngEncode();
            FileUtils.writeByteArrayToFile((File)outputFile, (byte[])bytes);
        }
        catch (IOException e) {
            log.error((Object)("Failed to save placeholder chart to file: " + outputFile), (Throwable)e);
        }
    }

    public static XYPlot createSpacerPlot() {
        XYPlot spacerPlot = new XYPlot();
        spacerPlot.setForegroundAlpha(0.0f);
        spacerPlot.setBackgroundAlpha(0.0f);
        spacerPlot.setOutlineVisible(false);
        return spacerPlot;
    }

    public static DateAxis createTimeAxis(long startTime, long endTime) {
        return JFreeChartUtils.createTimeAxis(DEFAULT_DATE_AXIS_TITLE, startTime, endTime);
    }

    public static DateAxis createTimeAxis(String axisTitle, long startTime, long endTime) {
        Date startDate = new Date(startTime);
        TimeZone tz = TimeZone.getDefault();
        if (StringUtils.isBlank((CharSequence)axisTitle)) {
            axisTitle = DEFAULT_DATE_AXIS_TITLE;
        }
        axisTitle = axisTitle + " [" + tz.getDisplayName(tz.inDaylightTime(startDate), 0, Locale.US) + "]";
        DateAxis timeAxis = new DateAxis(axisTitle);
        JFreeChartUtils.updateDateAxisMinMaxTime(timeAxis, startTime, endTime);
        return timeAxis;
    }

    private static void updateDateAxisMinMaxTime(DateAxis timeAxis, long startTime, long endTime) {
        if (startTime > 0L && endTime < Long.MAX_VALUE) {
            long margin = (endTime - startTime) / 100L;
            timeAxis.setMinimumDate(new Date(startTime));
            timeAxis.setMaximumDate(new Date(endTime + margin));
        }
    }

    public static int getChartCappingValue(ReportGeneratorConfiguration.ChartCappingInfo cappingInfo, double averageValue, int maxValue) {
        int effectiveCappingValue;
        switch (cappingInfo.method) {
            case ABSOLUTE: {
                effectiveCappingValue = (int)cappingInfo.parameter;
                break;
            }
            case NFOLD_OF_AVERAGE: {
                effectiveCappingValue = (int)(averageValue * cappingInfo.parameter);
                break;
            }
            default: {
                effectiveCappingValue = -1;
            }
        }
        if (effectiveCappingValue >= maxValue && cappingInfo.mode == ReportGeneratorConfiguration.ChartCappingInfo.ChartCappingMode.SMART) {
            effectiveCappingValue = -1;
        }
        return effectiveCappingValue;
    }

    public static synchronized Second getSecond(long time) {
        Second second = secondsCache.get(time = time / 1000L * 1000L);
        if (second == null) {
            second = new Second(new Date(time));
            secondsCache.put(time, second);
        }
        return second;
    }

    public static void saveChart(JFreeChart chart, File outputFile, int chartWidth, int chartHeight) {
        DEFAULT_CHART_THEME.apply(chart);
        try {
            BufferedImage bufferedImage = chart.createBufferedImage(chartWidth, chartHeight);
            Graphics2D g2d = bufferedImage.createGraphics();
            g2d.setFont(DEFAULT_CHART_THEME.getSmallFont());
            g2d.setColor(WATERMARK_COLOR);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            FontMetrics fontMetrics = g2d.getFontMetrics();
            int textWidth = (int)fontMetrics.getStringBounds(WATERMARK_TEXT, g2d).getWidth();
            int x = chartWidth - (9 + textWidth);
            int y = 9 + fontMetrics.getAscent();
            g2d.drawString(WATERMARK_TEXT, x, y);
            g2d.dispose();
            PngEncoder encoder = new PngEncoder((Image)bufferedImage, true, 0, pngCompressionLevel);
            byte[] imageData = encoder.pngEncode();
            FileUtils.writeByteArrayToFile((File)outputFile, (byte[])imageData);
        }
        catch (IOException e) {
            log.error((Object)("Failed to save chart to file: " + outputFile), (Throwable)e);
        }
    }

    public static void saveChart(JFreeChart chart, String name, File outputDir, int chartWidth, int chartHeight) {
        File outputFile = new File(outputDir, com.xceptance.common.io.FileUtils.convertIllegalCharsInFileName(name) + ".png");
        JFreeChartUtils.saveChart(chart, outputFile, chartWidth, chartHeight);
    }

    public static void setAxisTimeSeriesCollection(JFreeChart chart, int axisIndex, String rangeAxisTitle, List<TimeSeriesConfiguration> seriesConfigurations) {
        XYPlot plot = (XYPlot)chart.getPlot();
        int dsCount = plot.getDatasetCount();
        XYLineAndShapeRenderer renderer = JFreeChartUtils.createLineRenderer((ColorSet)null);
        TimeSeriesCollection seriesCollection = new TimeSeriesCollection();
        for (int index = 0; index < seriesConfigurations.size(); ++index) {
            TimeSeriesConfiguration seriesConfig = seriesConfigurations.get(index);
            seriesCollection.addSeries(seriesConfig.getTimeSeries());
            TimeSeriesConfiguration.Style style = seriesConfig.getStyle();
            if (style != TimeSeriesConfiguration.Style.LINE) {
                BasicStroke stroke;
                float lineWidth = 0.5f;
                float[] dash = new float[]{5.0f};
                float[] dot = new float[]{0.5f};
                switch (style) {
                    case DASH: {
                        stroke = new BasicStroke(0.5f, 0, 0, 10.0f, dash, 0.0f);
                        break;
                    }
                    case DOT: {
                        stroke = new BasicStroke(0.5f, 0, 0, 2.0f, dot, 0.0f);
                        break;
                    }
                    default: {
                        log.warn((Object)("unknown line style '" + (Object)((Object)style) + "'. Use LINE style by default."));
                        stroke = new BasicStroke(0.5f);
                    }
                }
                renderer.setSeriesStroke(index, (Stroke)stroke);
            }
            ColorSet colorSet = axisIndex < 1 ? ColorSet.A : ColorSet.B;
            Color color = seriesConfig.getColor() != null ? seriesConfig.getColor() : colorSet.get((index + colorSet.size()) % colorSet.size());
            renderer.setSeriesPaint(index, (Paint)color);
        }
        NumberAxis yAxis = JFreeChartUtils.createNumberAxis(rangeAxisTitle != null ? rangeAxisTitle : DEFAULT_VALUE_AXIS_TITLE);
        plot.setDataset(dsCount, (XYDataset)seriesCollection);
        plot.setRangeAxis(axisIndex == 1 ? 1 : 0, (ValueAxis)yAxis);
        plot.mapDatasetToRangeAxis(dsCount, axisIndex == 1 ? 1 : 0);
        plot.setRenderer(dsCount, (XYItemRenderer)renderer);
    }

    public static TimeSeries toMinMaxTimeSeries(DoubleMinMaxValueSet valueSet, String timeSeriesName) {
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)timeSeriesName));
        if (valueSet.getValueCount() > 0L) {
            DoubleMinMaxValue[] values = valueSet.getValues();
            long time = valueSet.getMinimumTime();
            int timeIncrement = valueSet.getScale() * 1000;
            for (int i = 0; i < values.length; ++i) {
                DoubleMinMaxValue value = values[i];
                if (value != null) {
                    Second second = JFreeChartUtils.getSecond(time);
                    timeSeries.add((TimeSeriesDataItem)new DoubleMinMaxTimeSeriesDataItem((RegularTimePeriod)second, value));
                }
                time += (long)timeIncrement;
            }
        }
        return timeSeries;
    }

    public static TimeSeries toMinMaxTimeSeries(MinMaxValueSet minMaxValueSet, String timeSeriesName) {
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)timeSeriesName));
        if (minMaxValueSet.getValueCount() > 0L) {
            MinMaxValue[] values = minMaxValueSet.getValues();
            long time = minMaxValueSet.getMinimumTime();
            int scale = minMaxValueSet.getScale();
            for (int i = 0; i < values.length; ++i) {
                MinMaxValue value = values[i];
                if (value != null) {
                    Second second = JFreeChartUtils.getSecond(time);
                    timeSeries.add((TimeSeriesDataItem)new MinMaxTimeSeriesDataItem((RegularTimePeriod)second, value));
                }
                time += (long)(scale * 1000);
            }
        }
        return timeSeries;
    }

    public static TimeSeries toStandardTimeSeries(MinMaxValueSet minMaxValueSet, String timeSeriesName) {
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)timeSeriesName));
        if (minMaxValueSet.getValueCount() > 0L) {
            MinMaxValue[] values = minMaxValueSet.getValues();
            long time = minMaxValueSet.getMinimumTime();
            int scale = minMaxValueSet.getScale();
            for (int i = 0; i < values.length; ++i) {
                MinMaxValue value = values[i];
                if (value != null) {
                    Second second = JFreeChartUtils.getSecond(time);
                    timeSeries.add((RegularTimePeriod)second, (double)value.getMaximumValue());
                }
                time += (long)(scale * 1000);
            }
        }
        return timeSeries;
    }

    public static TimeSeries calculateRateTimeSeries(ValueSet countValueSet, ValueSet totalCountValueSet, int minMaxValueSetSize, String seriesName) {
        TimeSeries rateTimeSeries = new TimeSeries((Comparable)((Object)seriesName));
        if (totalCountValueSet.getValueCount() == 0L) {
            return rateTimeSeries;
        }
        countValueSet.addOrUpdateValue(totalCountValueSet.getMinimumTime(), 0);
        countValueSet.addOrUpdateValue(totalCountValueSet.getMaximumTime(), 0);
        long time = totalCountValueSet.getMinimumTime();
        int[] counts = countValueSet.getValues();
        int[] totalCounts = totalCountValueSet.getValues();
        for (int i = 0; i < counts.length; ++i) {
            if (totalCounts[i] > 0) {
                double rate = 100.0 * (double)counts[i] / (double)totalCounts[i];
                rateTimeSeries.add((RegularTimePeriod)JFreeChartUtils.getSecond(time), rate);
            }
            time += 1000L;
        }
        return rateTimeSeries;
    }

    public static void adjustSeriesForLogarithmicAxes(TimeSeries timeSeries) {
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            TimeSeriesDataItem dataItem = timeSeries.getDataItem(i);
            if (!((Double)dataItem.getValue() <= 0.0)) continue;
            dataItem.setValue((Number)1.0E-8);
        }
    }

    public static void adjustSeriesForLogarithmicAxes(XYIntervalSeries intervalSeries) {
        for (int i = 0; i < intervalSeries.getItemCount(); ++i) {
            XYIntervalDataItem dataItem = (XYIntervalDataItem)intervalSeries.getDataItem(i);
            Double x = dataItem.getX();
            double yLow = dataItem.getYLowValue();
            double y = dataItem.getYLowValue();
            double yHigh = dataItem.getYLowValue();
            if (!(yLow <= 0.0) && !(y <= 0.0) && !(yHigh <= 0.0)) continue;
            intervalSeries.remove((Comparable)x);
            yLow = yLow <= 0.0 ? 1.0E-8 : yLow;
            y = y <= 0.0 ? 1.0E-8 : y;
            yHigh = yHigh <= 0.0 ? 1.0E-8 : yHigh;
            intervalSeries.add(x.doubleValue(), dataItem.getXLowValue(), dataItem.getXHighValue(), y, yLow, yHigh);
        }
    }

    public static void setPngCompressionLevel(int level) {
        if (0 > level || level > 9) {
            throw new IllegalArgumentException("The PNG compression level must be between 0...9");
        }
        pngCompressionLevel = level;
    }

    public static int getPngCompressionLevel() {
        return pngCompressionLevel;
    }

    private JFreeChartUtils() {
    }

    public static enum MoreColors {
        BROWN(12155479),
        GRAY(0xAAAAAA),
        GREEN(43520),
        LIGHT_GRAY(0x757575),
        LIGHT_GREEN(11920925),
        LILAC(13156327),
        ORANGE(0xFF9900),
        STEEL_BLUE(7377598);

        private final Color color;

        private MoreColors(int color) {
            this.color = new Color(color);
        }

        public Color getColor() {
            return this.color;
        }
    }

    public static class ColorSet {
        public static final ColorSet AVERAGES = new ColorSet(COLOR_MOVING_AVERAGE, COLOR_MEDIAN, COLOR_MEAN);
        public static final ColorSet A = new ColorSet(Color.BLUE, MoreColors.GRAY.getColor(), Color.MAGENTA, MoreColors.GREEN.getColor(), Color.RED);
        public static final ColorSet B = new ColorSet(Color.BLACK, MoreColors.LIGHT_GREEN.getColor(), MoreColors.BROWN.getColor(), MoreColors.STEEL_BLUE.getColor(), MoreColors.LIGHT_GRAY.getColor());
        public static final ColorSet C = new ColorSet(MoreColors.ORANGE.getColor(), Color.CYAN, Color.PINK, MoreColors.LILAC.getColor(), Color.YELLOW);
        private final List<Color> colors = new ArrayList<Color>(5);

        public ColorSet(Color ... colors) {
            int count = colors.length;
            for (int i = 0; i < count; ++i) {
                this.colors.add(colors[i]);
            }
        }

        public Color get(int index) throws IndexOutOfBoundsException {
            return this.colors.get(index);
        }

        public List<Color> getColors() {
            return Collections.unmodifiableList(this.colors);
        }

        public int size() {
            return this.colors.size();
        }
    }
}

