/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.util;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LineProvider {
    private static final Map<Key, LineProvider> LINE_PROVIDERS = new ConcurrentHashMap<Key, LineProvider>();
    private final List<String> lines;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LineProvider getInstance(String fileName, String encoding, boolean ignoreLineComments) throws FileNotFoundException, IOException {
        Key key = new Key(fileName, encoding, ignoreLineComments);
        LineProvider lineProvider = LINE_PROVIDERS.get(key);
        if (lineProvider == null) {
            Map<Key, LineProvider> map = LINE_PROVIDERS;
            synchronized (map) {
                lineProvider = LINE_PROVIDERS.get(key);
                if (lineProvider == null) {
                    lineProvider = new LineProvider(key);
                    LINE_PROVIDERS.put(key, lineProvider);
                }
            }
        }
        return lineProvider;
    }

    private LineProvider(Key key) throws IOException, FileNotFoundException {
        ParameterCheckUtils.isNotNull(key, "key");
        ParameterCheckUtils.isNotNullOrEmpty(key.fileName, "fileName");
        ParameterCheckUtils.isNotNullOrEmpty(key.encoding, "encoding");
        String dataDirectory = XltProperties.getInstance().getProperty("com.xceptance.xlt.data.directory", "config" + File.separatorChar + "data");
        File file = new File(dataDirectory, key.fileName);
        this.lines = new ArrayList<String>();
        if (XltLogger.runTimeLogger.isDebugEnabled()) {
            XltLogger.runTimeLogger.debug((Object)("Loading data from " + file.getAbsolutePath()));
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), key.encoding));){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") && key.ignoreLineComments) continue;
                this.lines.add(line);
            }
        }
    }

    public List<String> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    private static class Key {
        private final String fileName;
        private final String encoding;
        private final boolean ignoreLineComments;

        private Key(String fileName, String encoding, boolean ignoreLineComments) {
            this.fileName = fileName;
            this.encoding = encoding;
            this.ignoreLineComments = ignoreLineComments;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                if (this.fileName.equals(k.fileName) && this.encoding.equals(k.encoding) && this.ignoreLineComments == k.ignoreLineComments) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int prime = 17;
            int hash = this.fileName.hashCode();
            hash = hash * 17 + this.encoding.hashCode();
            hash = hash * 17 + (this.ignoreLineComments ? 37 : 31);
            return hash;
        }
    }
}

