/**
 * Inspired by the json-view library (https://github.com/pgrabovets/json-view)
 * created by Pavel Grabovets and published under ISC license.
 *
 * ISC License
 *
 * Copyright (c) 2018, Pavel Grabovets
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
!function(){"use strict";function TreeNode(){function findAndMarkMatches(value,elem,searchPhrase,searchState){var empty=0==searchPhrase.length,escapedSearchPhrase=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}(searchPhrase),regex=searchState.ignoreCase?new RegExp(escapedSearchPhrase,"i"):new RegExp(escapedSearchPhrase),found=!empty&&-1!=value.search(regex),index=0;if(found){for(;elem.firstChild;)elem.removeChild(elem.lastChild);value.split(regex).forEach(function(part,i){if(0!=i){var span=createElement("span",{className:"json-match",content:value.substr(index,searchPhrase.length)});elem.appendChild(span),searchState.matches.push(span),index+=searchPhrase.length}var text=document.createTextNode(part);elem.appendChild(text),index+=part.length})}else elem.textContent=value;return empty||found}this.parent=null,this.key=null,this.value=null,this.type=null,this.expanded=!1,this.children=null,this.elem=null,this.depth=0,this.isLeaf=function(){return null!==this.value},this.hasChildren=function(){return null!==this.children&&0<this.children.length},this.forEachChildNode=function(callback){this.hasChildren()&&this.children.forEach(callback)},this.hide=function(){this.expanded&&this.forEachChildNode(function(child){child.hide()}),this.setVisible(!1)},this.show=function(){this.setVisible(!0),this.expanded&&this.forEachChildNode(function(child){child.show()})},this.setVisible=function(visible){visible?this.elem.classList.remove("json-hide"):this.elem.classList.add("json-hide")},this.setExpanded=function(expanded){if(this.hasChildren()){this.expanded=expanded;var icon=this.elem.querySelector(".json-caret");expanded?icon.classList.add("json-caret-expanded"):icon.classList.remove("json-caret-expanded")}},this.toggle=function(){this.expanded?this.collapse():this.expand()},this.expand=function(){this.hasChildren()&&(this.setExpanded(!0),this.forEachChildNode(function(child){child.show()}))},this.expandAll=function(){this.expand(),this.forEachChildNode(function(child){child.expandAll()})},this.collapse=function(){this.hasChildren()&&(this.setExpanded(!1),this.forEachChildNode(function(child){child.hide()}))},this.collapseAll=function(){this.forEachChildNode(function(child){child.collapseAll()}),this.collapse()},this.getJsonPath=function(){for(var p,path="",node=this;p=node.parent&&"array"===node.parent.type?"["+node.key+"]":node.key,path=""===path?p:"array"===node.type?p+path:p+"."+path,null!=(node=node.parent););document.querySelector("#jsonPath").textContent=path},this.render=function(targetElem){targetElem.appendChild(this.elem),this.forEachChildNode(function(child){child.render(targetElem)})},this.search=function(searchPhrase,searchState){var found=!1;return findAndMarkMatches(this.key,this.elem.childNodes.item(1),searchPhrase,searchState)&&(found=!0),this.isLeaf()&&findAndMarkMatches(this.value,this.elem.childNodes.item(3),searchPhrase,searchState)&&(found=!0),this.forEachChildNode(function(child){found=child.search(searchPhrase,searchState)||found}),this.setVisible(found||!searchState.filter),found?this.setExpanded(!0):this.collapse(),found}}function createTree(data){return function createTreeNode(key,value,parentNode){var node=new TreeNode;node.parent=parentNode;node.key=key;node.type=getType(value);node.depth=parentNode?parentNode.depth+1:0;if("object"!==node.type&&"array"!==node.type||null===value)"string"===node.type?node.value=JSON.stringify(value):node.value=String(value);else for(var key in node.children=[],value)node.children.push(createTreeNode(key,value[key],node));node.elem=createLineElement(node);return node}("$",data,null)}function getType(value){return null===value?"null":Array.isArray(value)?"array":typeof value}function createLineElement(node){var childElements=[],caretElement=createElement("div",{className:node.hasChildren()?"json-caret":"json-caret json-caret-empty"});childElements.push(caretElement);var keyOrIndexElement=createElement("div",{className:node.parent&&"array"===node.parent.type?"json-index":"json-key",content:node.key});if(childElements.push(keyOrIndexElement),"object"===node.type||"array"===node.type){var sizeElement=createElement("div",{className:"json-size",content:"array"===node.type?"["+node.children.length+"]":"{"+node.children.length+"}"});childElements.push(sizeElement)}else{var separatorElement=createElement("div",{className:"json-separator",content:":"});childElements.push(separatorElement);var valueElement=createElement("div",{className:"json-value json-"+node.type,content:node.value});childElements.push(valueElement)}var lineElement=createElement("div",{className:"json-line",children:childElements});return lineElement.style="margin-left: "+24*node.depth+"px;",lineElement.addEventListener("click",node.toggle.bind(node)),lineElement.addEventListener("click",node.getJsonPath.bind(node)),lineElement}function createElement(type,config){var htmlElement=document.createElement(type);return config&&(config.className&&(htmlElement.className=config.className),config.content&&(htmlElement.textContent=config.content),config.children&&config.children.forEach(function(el){htmlElement.appendChild(el)})),htmlElement}var tree=null,searchState=null;window.jsonView={format:function(jsonData,targetElementSelector){var targetElement=document.querySelector(targetElementSelector)||document.body;try{(tree=createTree(JSON.parse(jsonData))).render(targetElement),tree.collapseAll(),tree.expand()}catch(error){targetElement.textContent=error}},collapseAll:function(){tree&&tree.collapseAll()},expandAll:function(){tree&&tree.expandAll()},matchesElementSelector:"#matches",search:function(searchPhrase,ignoreCase,filter){tree&&(searchPhrase=searchPhrase||"",searchState={matches:[],currentMatch:void 0,ignoreCase:ignoreCase,filter:filter},tree.search(searchPhrase,searchState),this.highlightNextMatch(!0),document.querySelector(this.matchesElementSelector).textContent=searchState.matches.length)},highlightNextMatch:function(forward){searchState&&0<searchState.matches.length&&(void 0===searchState.currentMatch?searchState.currentMatch=0:(searchState.matches[searchState.currentMatch].classList.remove("json-match-current"),searchState.currentMatch=forward?searchState.currentMatch==searchState.matches.length-1?0:searchState.currentMatch+1:0==searchState.currentMatch?searchState.matches.length-1:searchState.currentMatch-1),searchState.matches[searchState.currentMatch].scrollIntoView(!forward),searchState.matches[searchState.currentMatch].classList.add("json-match-current"))}}}();
