/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocumentFragment;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNode;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLSerializer;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.util.XmlUtils;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JsxClass(value={SupportedBrowser.IE})
public class XSLProcessor
extends MSXMLScriptable {
    private XMLDOMNode style_;
    private XMLDOMNode input_;
    private Object output_;
    private final Map<String, Object> parameters_ = new HashMap<String, Object>();

    @JsxSetter
    public void setInput(XMLDOMNode input) {
        this.input_ = input;
    }

    @JsxGetter
    public XMLDOMNode getInput() {
        return this.input_;
    }

    @JsxSetter
    public void setOutput(Object output) {
        this.output_ = output;
    }

    @JsxGetter
    public Object getOutput() {
        return this.output_;
    }

    @JsxFunction
    public void addParameter(String baseName, Object parameter, Object namespaceURI) {
        String nsString = namespaceURI instanceof String ? (String)namespaceURI : null;
        this.parameters_.put(XSLProcessor.getQualifiedName(nsString, baseName), parameter);
    }

    private static String getQualifiedName(String namespaceURI, String localName) {
        Object qualifiedName = namespaceURI != null && !namespaceURI.isEmpty() && !"null".equals(namespaceURI) ? "{" + namespaceURI + "}" + localName : localName;
        return qualifiedName;
    }

    @JsxFunction
    public void transform() {
        XMLDOMNode input = this.input_;
        SgmlPage page = input.getDomNodeOrDie().getPage();
        if (this.output_ == null || !(this.output_ instanceof XMLDOMNode)) {
            DomDocumentFragment fragment = page.createDocumentFragment();
            XMLDOMDocumentFragment node = new XMLDOMDocumentFragment();
            node.setParentScope(this.getParentScope());
            node.setPrototype(this.getPrototype(node.getClass()));
            node.setDomNode(fragment);
            this.output_ = fragment.getScriptableObject();
        }
        this.transform(this.input_, ((XMLDOMNode)this.output_).getDomNodeOrDie());
        XMLSerializer serializer = new XMLSerializer(false);
        StringBuilder output = new StringBuilder();
        for (DomNode child : ((XMLDOMNode)this.output_).getDomNodeOrDie().getChildren()) {
            if (child instanceof DomText) {
                if (!StringUtils.isNotBlank((CharSequence)((DomText)child).getData())) continue;
                output.append(((DomText)child).getData());
                continue;
            }
            String serializedString = serializer.serializeToString((XMLDOMNode)child.getScriptableObject());
            output.append(serializedString, 0, serializedString.length() - 2);
        }
        this.output_ = output.toString();
    }

    private Object transform(XMLDOMNode source) {
        try {
            DOMSource xmlSource = new DOMSource(source.getDomNodeOrDie());
            DOMSource xsltSource = new DOMSource(this.style_.getDomNodeOrDie());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document containerDocument = factory.newDocumentBuilder().newDocument();
            Element containerElement = containerDocument.createElement("container");
            containerDocument.appendChild(containerElement);
            DOMResult result = new DOMResult(containerElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            for (Map.Entry<String, Object> entry : this.parameters_.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
            transformer.transform(xmlSource, result);
            Node transformedNode = result.getNode();
            if (transformedNode.getFirstChild().getNodeType() == 1) {
                return transformedNode;
            }
            xmlSource = new DOMSource(source.getDomNodeOrDie());
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(xmlSource, streamResult);
            return writer.toString();
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("Exception: " + e));
        }
    }

    private void transform(XMLDOMNode source, DomNode parent) {
        Object result = this.transform(source);
        if (result instanceof Node) {
            SgmlPage parentPage = parent.getPage();
            NodeList children = ((Node)result).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                XmlUtils.appendChild(parentPage, parent, children.item(i), false);
            }
        } else {
            DomText text = new DomText(parent.getPage(), (String)result);
            parent.appendChild(text);
        }
    }

    public void importStylesheet(XMLDOMNode style) {
        this.style_ = style;
    }
}

