/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSerializer;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class HtmlOption
extends HtmlElement
implements DisabledElement {
    public static final String TAG_NAME = "option";
    private boolean selected_;

    HtmlOption(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.reset();
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public Page setSelected(boolean selected) {
        this.setSelected(selected, true, false, false, false);
        return this.getPage();
    }

    public void setSelectedFromJavaScript(boolean selected) {
        this.setSelected(selected, false, false, true, false);
    }

    private void setSelected(boolean selected, boolean invokeOnFocus, boolean isClick, boolean shiftKey, boolean ctrlKey) {
        if (selected == this.isSelected()) {
            return;
        }
        HtmlSelect select = this.getEnclosingSelect();
        if (select != null) {
            select.setSelectedAttribute(this, selected, invokeOnFocus, shiftKey, ctrlKey, isClick);
            return;
        }
        this.setSelectedInternal(selected);
    }

    @Override
    public void insertBefore(DomNode newNode) {
        HtmlOption option;
        super.insertBefore(newNode);
        if (newNode instanceof HtmlOption && (option = (HtmlOption)newNode).isSelected()) {
            this.getEnclosingSelect().setSelectedAttribute(option, true);
        }
    }

    public HtmlSelect getEnclosingSelect() {
        return (HtmlSelect)this.getEnclosingElement("select");
    }

    public void reset() {
        this.setSelectedInternal(this.hasAttribute("selected"));
    }

    public final String getSelectedAttribute() {
        return this.getAttributeDirect("selected");
    }

    public final boolean isDefaultSelected() {
        return this.hasAttribute("selected");
    }

    @Override
    public final boolean isDisabled() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLOPTION_PREVENT_DISABLED)) {
            return false;
        }
        return this.hasAttribute("disabled");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeDirect("disabled");
    }

    public final String getLabelAttribute() {
        return this.getAttributeDirect("label");
    }

    public final void setLabelAttribute(String newLabel) {
        this.setAttribute("label", newLabel);
    }

    public final String getValueAttribute() {
        String value = this.getAttributeDirect("value");
        if (value == ATTRIBUTE_NOT_DEFINED) {
            value = this.getText();
        }
        return value;
    }

    public final void setValueAttribute(String newValue) {
        this.setAttribute("value", newValue);
    }

    @Override
    public Page mouseDown(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        Page page = null;
        if (this.hasFeature(BrowserVersionFeatures.EVENT_ONMOUSEDOWN_FOR_SELECT_OPTION_TRIGGERS_ADDITIONAL_DOWN_FOR_SELECT)) {
            page = this.getEnclosingSelect().mouseDown(shiftKey, ctrlKey, altKey, button);
        }
        if (this.hasFeature(BrowserVersionFeatures.EVENT_ONMOUSEDOWN_NOT_FOR_SELECT_OPTION)) {
            return page;
        }
        return super.mouseDown(shiftKey, ctrlKey, altKey, button);
    }

    @Override
    public Page mouseUp(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        Page page = null;
        if (this.hasFeature(BrowserVersionFeatures.EVENT_ONMOUSEUP_FOR_SELECT_OPTION_TRIGGERS_ADDITIONAL_UP_FOR_SELECT)) {
            page = this.getEnclosingSelect().mouseUp(shiftKey, ctrlKey, altKey, button);
        }
        if (this.hasFeature(BrowserVersionFeatures.EVENT_ONMOUSEUP_NOT_FOR_SELECT_OPTION)) {
            return page;
        }
        return super.mouseUp(shiftKey, ctrlKey, altKey, button);
    }

    @Override
    public <P extends Page> P click(Event event, boolean shiftKey, boolean ctrlKey, boolean altKey, boolean ignoreVisibility) throws IOException {
        if (this.hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_FOR_SELECT_ONLY)) {
            SgmlPage page = this.getPage();
            if (this.isDisabled()) {
                return (P)page;
            }
            if (this.isStateUpdateFirst()) {
                this.doClickStateUpdate(event.isShiftKey(), event.isCtrlKey());
            }
            return this.getEnclosingSelect().click(event, shiftKey, ctrlKey, altKey, ignoreVisibility);
        }
        return super.click(event, shiftKey, ctrlKey, altKey, ignoreVisibility);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        boolean changed = false;
        if (!this.isSelected()) {
            this.setSelected(true, true, true, shiftKey, ctrlKey);
            changed = true;
        } else if (this.getEnclosingSelect().isMultipleSelectEnabled()) {
            if (ctrlKey) {
                this.setSelected(false, true, true, shiftKey, ctrlKey);
                changed = true;
            } else {
                this.getEnclosingSelect().setOnlySelected(this, true);
            }
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return changed;
    }

    @Override
    protected DomNode getEventTargetElement() {
        HtmlSelect select;
        if (this.hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_FOR_SELECT_ONLY) && (select = this.getEnclosingSelect()) != null) {
            return select;
        }
        return super.getEventTargetElement();
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return true;
    }

    @Override
    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        super.printOpeningTagContentAsXml(printWriter);
        if (this.selected_ && this.getAttributeDirect("selected") == ATTRIBUTE_NOT_DEFINED) {
            printWriter.print(" selected=\"selected\"");
        }
    }

    void setSelectedInternal(boolean selected) {
        this.selected_ = selected;
    }

    @Override
    @Deprecated
    public String asText() {
        return super.asText();
    }

    public void setText(String text) {
        if (text == null || text.isEmpty()) {
            this.removeAllChildren();
        } else {
            DomNode child = this.getFirstChild();
            if (child == null) {
                this.appendChild(new DomText(this.getPage(), text));
            } else {
                child.setNodeValue(text);
            }
        }
    }

    public String getText() {
        HtmlSerializer ser = new HtmlSerializer();
        ser.setIgnoreMaskedElements(false);
        return ser.asText(this);
    }

    @Override
    public Page mouseOver(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        SgmlPage page = this.getPage();
        if (page.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONMOUSEOVER_NEVER_FOR_SELECT_OPTION)) {
            return page;
        }
        if (this.hasFeature(BrowserVersionFeatures.EVENT_ONMOUSEOVER_FOR_DISABLED_OPTION) && this.isDisabled()) {
            this.getEnclosingSelect().mouseOver(shiftKey, ctrlKey, altKey, button);
        }
        return super.mouseOver(shiftKey, ctrlKey, altKey, button);
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        if (this.hasFeature(BrowserVersionFeatures.CSS_DISPLAY_BLOCK2)) {
            return HtmlElement.DisplayStyle.BLOCK;
        }
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean handles(Event event) {
        if ("mouseover".equals(event.getType()) && this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONMOUSEOVER_FOR_DISABLED_OPTION)) {
            return true;
        }
        return super.handles(event);
    }
}

