/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class HtmlRadioButtonInput
extends HtmlInput
implements LabelableElement {
    private static final String DEFAULT_VALUE = "on";
    private boolean defaultCheckedState_;
    private boolean checkedState_;

    HtmlRadioButtonInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, HtmlRadioButtonInput.addValueIfNeeded(page, attributes));
        if (this.getAttributeDirect("value") == DEFAULT_VALUE) {
            this.setDefaultValue(ATTRIBUTE_NOT_DEFINED, false);
        }
        this.checkedState_ = this.defaultCheckedState_ = this.hasAttribute("checked");
    }

    private static Map<String, DomAttr> addValueIfNeeded(SgmlPage page, Map<String, DomAttr> attributes) {
        for (String key : attributes.keySet()) {
            if (!"value".equalsIgnoreCase(key)) continue;
            return attributes;
        }
        DomAttr newAttr = new DomAttr(page, null, "value", DEFAULT_VALUE, true);
        attributes.put("value", newAttr);
        return attributes;
    }

    @Override
    public boolean isChecked() {
        return this.checkedState_;
    }

    @Override
    public void reset() {
        this.setChecked(this.defaultCheckedState_);
    }

    void setCheckedInternal(boolean isChecked) {
        this.checkedState_ = isChecked;
    }

    @Override
    public Page setChecked(boolean isChecked) {
        ScriptResult scriptResult;
        Page page = this.getPage();
        boolean changed = this.isChecked() != isChecked;
        this.checkedState_ = isChecked;
        if (isChecked) {
            HtmlForm form = this.getEnclosingForm();
            if (form != null) {
                form.setCheckedRadioButton(this);
            } else if (page != null && page.isHtmlPage()) {
                this.setCheckedForPage((HtmlPage)page);
            }
        }
        if (changed && (scriptResult = this.fireEvent("change")) != null) {
            page = page.getEnclosingWindow().getWebClient().getCurrentWindow().getEnclosedPage();
        }
        return page;
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlForm form = this.getEnclosingForm();
        boolean changed = !this.isChecked();
        SgmlPage page = this.getPage();
        if (form != null) {
            form.setCheckedRadioButton(this);
        } else if (page != null && page.isHtmlPage()) {
            this.setCheckedForPage((HtmlPage)page);
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return changed;
    }

    private void setCheckedForPage(HtmlPage htmlPage) {
        List pageInputs = htmlPage.getByXPath("//input[lower-case(@type)='radio' and @name='" + this.getNameAttribute() + "']");
        List formInputs = htmlPage.getByXPath("//form//input[lower-case(@type)='radio' and @name='" + this.getNameAttribute() + "']");
        pageInputs.removeAll(formInputs);
        boolean foundInPage = false;
        for (HtmlRadioButtonInput input : pageInputs) {
            if (input == this) {
                this.setCheckedInternal(true);
                foundInPage = true;
                continue;
            }
            input.setCheckedInternal(false);
        }
        if (!foundInPage && !formInputs.contains(this)) {
            this.setCheckedInternal(true);
        }
    }

    @Override
    protected ScriptResult doClickFireClickEvent(Event event) {
        if (!this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_AFTER_ONCLICK)) {
            HtmlRadioButtonInput.executeOnChangeHandlerIfAppropriate(this);
        }
        return super.doClickFireClickEvent(event);
    }

    @Override
    protected void doClickFireChangeEvent() {
        if (this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_AFTER_ONCLICK)) {
            HtmlRadioButtonInput.executeOnChangeHandlerIfAppropriate(this);
        }
    }

    @Override
    @Deprecated
    public String asText() {
        return super.asText();
    }

    @Override
    protected void preventDefault() {
        this.checkedState_ = !this.checkedState_;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        this.setChecked(this.isDefaultChecked());
    }

    @Override
    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return true;
    }

    @Override
    protected void onAddedToPage() {
        super.onAddedToPage();
        this.setChecked(this.isChecked());
    }

    @Override
    Object getInternalValue() {
        return this.isChecked();
    }

    @Override
    void handleFocusLostValueChanged() {
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        if ("value".equals(qualifiedName)) {
            this.setDefaultValue(attributeValue, false);
        }
        if ("checked".equals(qualifiedName)) {
            this.checkedState_ = true;
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    protected boolean propagateClickStateUpdateToParent() {
        return !this.hasFeature(BrowserVersionFeatures.HTMLINPUT_CHECKBOX_DOES_NOT_CLICK_SURROUNDING_ANCHOR) && super.propagateClickStateUpdateToParent();
    }
}

