/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.lang;

public final class ParseNumbers {
    private static final int DIGITOFFSET = 48;
    private static final int BASE = 10;

    public static long parseLong(String s) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int length = s.length();
        if (length == 0) {
            throw new NumberFormatException("empty");
        }
        try {
            long value = 0L;
            for (int i = 0; i < length; ++i) {
                int digit = s.charAt(i) - 48;
                if (digit < 0 || digit > 9) {
                    throw new NumberFormatException(s);
                }
                value = value * 10L + (long)digit;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return Long.parseLong(s);
        }
    }

    public static int parseInt(String s) {
        try {
            return (int)ParseNumbers.parseLong(s);
        }
        catch (NumberFormatException e) {
            return Integer.parseInt(s);
        }
    }

    private ParseNumbers() {
    }
}

