/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.lang;

import com.xceptance.common.util.RegExUtils;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.zip.CRC32;

public final class StringUtils {
    private static final Map<String, WeakReference<String>> CACHE = Collections.synchronizedMap(new WeakHashMap(1001));

    public static String crc32(String s) {
        CRC32 hasher = new CRC32();
        hasher.update(s.getBytes());
        return Long.toString(hasher.getValue());
    }

    public static String internString(String str) {
        String result = null;
        WeakReference<String> ref = CACHE.get(str);
        if (ref != null) {
            result = (String)ref.get();
        }
        if (result == null) {
            CACHE.put(str, new WeakReference<String>(str));
            result = str;
        }
        return result;
    }

    public static String replaceFirst(String str, String regex, String replacement) {
        return RegExUtils.getPattern(regex, 0).matcher(str).replaceFirst(replacement);
    }

    public static String replaceAll(String str, String regex, String replacement) {
        return RegExUtils.getPattern(regex, 0).matcher(str).replaceAll(replacement);
    }

    public static String replace(String str, CharSequence target, CharSequence replacement) {
        return RegExUtils.getPattern(target.toString(), 16).matcher(str).replaceAll(Matcher.quoteReplacement(replacement.toString()));
    }

    public static String[] split(String str, String regex, int limit) {
        return RegExUtils.getPattern(regex, 0).split(str, limit);
    }

    public static String[] split(String str, String regex) {
        return StringUtils.split(str, regex, 0);
    }

    private StringUtils() {
    }
}

