/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.common.lang.ThreadUtils;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.agentcontroller.AgentStatus;
import com.xceptance.xlt.agentcontroller.TestUserStatus;
import com.xceptance.xlt.api.engine.GlobalClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentStatusPusher
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(AgentStatusPusher.class);
    private static final int PUSH_INTERVAL = 1000;
    private final AgentController agentController;
    private final AgentStatus agentStatus;
    private final int maxErrors;
    private int stackOverflowErrorLogAttempts;

    public AgentStatusPusher(AgentController agentController, AgentStatus agentStatus, int maxErrors) {
        super("AgentStatusPusher");
        this.agentStatus = agentStatus;
        this.agentController = agentController;
        this.maxErrors = maxErrors;
    }

    public void pushStatus() {
        try {
            this.agentController.setAgentStatus(this.agentStatus);
        }
        catch (Throwable t) {
            if (t instanceof StackOverflowError && ++this.stackOverflowErrorLogAttempts > 5) {
                return;
            }
            log.error("Failed to push agent status to agent controller:", t);
        }
    }

    @Override
    public void run() {
        log.debug("Agent status pusher thread started.");
        while (true) {
            this.updateElapsedTimeAndProgress();
            this.pushStatus();
            this.checkMaxErrors();
            ThreadUtils.sleep(1000L);
        }
    }

    private void checkMaxErrors() {
        int errors = 0;
        for (TestUserStatus status : this.agentStatus.getTestUserStatusList()) {
            errors += status.getErrors();
        }
        if (errors >= this.maxErrors) {
            log.error("Agent will terminate because the maximum error limit (" + this.maxErrors + ") is reached.");
            System.exit(3);
        }
    }

    private void updateElapsedTimeAndProgress() {
        long now = GlobalClock.getInstance().getTime();
        for (TestUserStatus status : this.agentStatus.getTestUserStatusList()) {
            int progress;
            long elapsedTime = now - status.getStartDate();
            long duration = status.getEndDate() - status.getStartDate();
            TestUserStatus.State state = status.getState();
            if (state == TestUserStatus.State.Running || state == TestUserStatus.State.Waiting) {
                status.setElapsedTime(elapsedTime);
            }
            if (duration <= 0L || (progress = Math.min((int)(elapsedTime * 100L / duration), 99)) <= status.getPercentageComplete()) continue;
            status.setPercentageComplete(progress);
        }
    }
}

