/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.xlt.api.engine.AbstractCustomSampler;
import com.xceptance.xlt.api.engine.CustomValue;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltLogger;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSamplerRunner
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(CustomSamplerRunner.class);
    private final AbstractCustomSampler sampler;
    private boolean isClosed = false;

    public CustomSamplerRunner(AbstractCustomSampler sampler, ThreadGroup threadGroup) {
        super(threadGroup, threadGroup.getName() + "_" + sampler.getName());
        this.sampler = sampler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Timer t = new Timer();
        t.schedule((TimerTask)new WakeUpService(this), 0L, this.sampler.getInterval());
        this.sampler.initialize();
        ShutdownHook shutdownHook = new ShutdownHook();
        shutdownHook.setPriority(10);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        while (!this.isClosed()) {
            try {
                CustomValue sample = new CustomValue(this.sampler.getName());
                sample.setTime();
                sample.setValue(this.sampler.execute());
                Session.getCurrent().getDataManager().logDataRecord(sample);
            }
            catch (Exception e) {
                LOG.error("Failed to invoke custom sampler", (Throwable)e);
            }
            try {
                CustomSamplerRunner e = this;
                synchronized (e) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                XltLogger.runTimeLogger.error("I can't get no sleep.", (Throwable)e);
            }
        }
    }

    private synchronized void setClosed() {
        this.isClosed = true;
    }

    private synchronized boolean isClosed() {
        return this.isClosed;
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            CustomSamplerRunner.this.setClosed();
            CustomSamplerRunner.this.sampler.shutdown();
        }
    }

    protected class WakeUpService
    extends TimerTask {
        private final Thread samplerThread;

        public WakeUpService(Thread samplerThread) {
            this.samplerThread = samplerThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thread = this.samplerThread;
            synchronized (thread) {
                this.samplerThread.notify();
            }
        }
    }
}

