/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.common.lang.ParseNumbers;
import com.xceptance.xlt.api.engine.AbstractData;
import java.util.List;

public class JvmResourceUsageData
extends AbstractData {
    private int blockedThreadCount;
    private long committedMemorySize;
    private double cpuUsage;
    private long fullGcCount;
    private int fullGcCountDiff;
    private double fullGcCpuUsage;
    private long fullGcTime;
    private int fullGcTimeDiff;
    private double heapUsage;
    private double memoryUsage;
    private long minorGcCount;
    private int minorGcCountDiff;
    private double minorGcCpuUsage;
    private long minorGcTime;
    private int minorGcTimeDiff;
    private int runnableThreadCount;
    private double totalCpuUsage;
    private long totalHeapSize;
    private long usedHeapSize;
    private int waitingThreadCount;

    public JvmResourceUsageData() {
        super("J");
    }

    public JvmResourceUsageData(String name) {
        super(name, "J");
    }

    public int getBlockedThreadCount() {
        return this.blockedThreadCount;
    }

    public long getCommittedMemorySize() {
        return this.committedMemorySize;
    }

    public double getCpuUsage() {
        return this.cpuUsage;
    }

    public long getFullGcCount() {
        return this.fullGcCount;
    }

    public int getFullGcCountDiff() {
        return this.fullGcCountDiff;
    }

    public double getFullGcCpuUsage() {
        return this.fullGcCpuUsage;
    }

    public long getFullGcTime() {
        return this.fullGcTime;
    }

    public int getFullGcTimeDiff() {
        return this.fullGcTimeDiff;
    }

    public double getHeapUsage() {
        return this.heapUsage;
    }

    public double getMemoryUsage() {
        return this.memoryUsage;
    }

    public long getMinorGcCount() {
        return this.minorGcCount;
    }

    public int getMinorGcCountDiff() {
        return this.minorGcCountDiff;
    }

    public double getMinorGcCpuUsage() {
        return this.minorGcCpuUsage;
    }

    public long getMinorGcTime() {
        return this.minorGcTime;
    }

    public int getMinorGcTimeDiff() {
        return this.minorGcTimeDiff;
    }

    public int getRunnableThreadCount() {
        return this.runnableThreadCount;
    }

    public double getTotalCpuUsage() {
        return this.totalCpuUsage;
    }

    public long getTotalHeapSize() {
        return this.totalHeapSize;
    }

    public long getUsedHeapSize() {
        return this.usedHeapSize;
    }

    public int getWaitingThreadCount() {
        return this.waitingThreadCount;
    }

    public void setBlockedThreadCount(int blockedThreadCount) {
        this.blockedThreadCount = blockedThreadCount;
    }

    public void setCommittedMemorySize(long committedMemorySize) {
        this.committedMemorySize = committedMemorySize;
    }

    public void setCpuUsage(double cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public void setFullGcCount(long fullGcCount) {
        this.fullGcCount = fullGcCount;
    }

    public void setFullGcCountDiff(int fullGcCountDiff) {
        this.fullGcCountDiff = fullGcCountDiff;
    }

    public void setFullGcCpuUsage(double fullGcCpuUsage) {
        this.fullGcCpuUsage = fullGcCpuUsage;
    }

    public void setFullGcTime(long fullGcTime) {
        this.fullGcTime = fullGcTime;
    }

    public void setFullGcTimeDiff(int fullGcTimeDiff) {
        this.fullGcTimeDiff = fullGcTimeDiff;
    }

    public void setHeapUsage(double heapUsage) {
        this.heapUsage = heapUsage;
    }

    public void setMemoryUsage(double memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    public void setMinorGcCount(long minorGcCount) {
        this.minorGcCount = minorGcCount;
    }

    public void setMinorGcCountDiff(int minorGcCountDiff) {
        this.minorGcCountDiff = minorGcCountDiff;
    }

    public void setMinorGcCpuUsage(double minorGcCpuUsage) {
        this.minorGcCpuUsage = minorGcCpuUsage;
    }

    public void setMinorGcTime(long minorGcTime) {
        this.minorGcTime = minorGcTime;
    }

    public void setMinorGcTimeDiff(int minorGcTimeDiff) {
        this.minorGcTimeDiff = minorGcTimeDiff;
    }

    public void setRunnableThreadCount(int runnableThreadCount) {
        this.runnableThreadCount = runnableThreadCount;
    }

    public void setTotalCpuUsage(double totalCpuUsage) {
        this.totalCpuUsage = totalCpuUsage;
    }

    public void setTotalHeapSize(long totalHeapSize) {
        this.totalHeapSize = totalHeapSize;
    }

    public void setUsedHeapSize(long usedHeapSize) {
        this.usedHeapSize = usedHeapSize;
    }

    public void setWaitingThreadCount(int waitingThreadCount) {
        this.waitingThreadCount = waitingThreadCount;
    }

    @Override
    protected List<String> addValues() {
        List<String> fields = super.addValues();
        fields.add(Double.toString(this.cpuUsage));
        fields.add(Long.toString(this.committedMemorySize));
        fields.add(Double.toString(this.memoryUsage));
        fields.add(Long.toString(this.usedHeapSize));
        fields.add(Long.toString(this.totalHeapSize));
        fields.add(Double.toString(this.heapUsage));
        fields.add(Integer.toString(this.runnableThreadCount));
        fields.add(Integer.toString(this.blockedThreadCount));
        fields.add(Integer.toString(this.waitingThreadCount));
        fields.add(Long.toString(this.minorGcCount));
        fields.add(Long.toString(this.minorGcTime));
        fields.add(Double.toString(this.minorGcCpuUsage));
        fields.add(Long.toString(this.fullGcCount));
        fields.add(Long.toString(this.fullGcTime));
        fields.add(Double.toString(this.fullGcCpuUsage));
        fields.add(Integer.toString(this.minorGcTimeDiff));
        fields.add(Integer.toString(this.fullGcTimeDiff));
        fields.add(Integer.toString(this.minorGcCountDiff));
        fields.add(Integer.toString(this.fullGcCountDiff));
        fields.add(Double.toString(this.totalCpuUsage));
        return fields;
    }

    @Override
    protected void parseValues(String[] values) {
        super.parseValues(values);
        this.cpuUsage = Double.parseDouble(values[3]);
        this.committedMemorySize = Long.parseLong(values[4]);
        this.memoryUsage = Double.parseDouble(values[5]);
        this.usedHeapSize = Long.parseLong(values[6]);
        this.totalHeapSize = Long.parseLong(values[7]);
        this.heapUsage = Double.parseDouble(values[8]);
        if (values.length >= 12) {
            this.runnableThreadCount = Integer.parseInt(values[9]);
            this.blockedThreadCount = Integer.parseInt(values[10]);
            this.waitingThreadCount = Integer.parseInt(values[11]);
        }
        if (values.length >= 18) {
            this.minorGcCount = ParseNumbers.parseLong(values[12]);
            this.minorGcTime = ParseNumbers.parseLong(values[13]);
            this.minorGcCpuUsage = Double.parseDouble(values[14]);
            this.fullGcCount = ParseNumbers.parseLong(values[15]);
            this.fullGcTime = ParseNumbers.parseLong(values[16]);
            this.fullGcCpuUsage = Double.parseDouble(values[17]);
        }
        if (values.length >= 20) {
            this.minorGcTimeDiff = ParseNumbers.parseInt(values[18]);
            this.fullGcTimeDiff = ParseNumbers.parseInt(values[19]);
        }
        if (values.length >= 22) {
            this.minorGcCountDiff = ParseNumbers.parseInt(values[20]);
            this.fullGcCountDiff = ParseNumbers.parseInt(values[21]);
        }
        if (values.length >= 23) {
            this.totalCpuUsage = Double.parseDouble(values[22]);
        }
    }
}

