/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.xceptance.xlt.agentcontroller.AgentControllerImpl;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final String OPTION_PROPERTY_DEFINITION = "D";

    public static void main(String[] args) {
        CommandLine commandLine = Main.parseCommandLine(args);
        Properties commandLineProps = commandLine.getOptionProperties(OPTION_PROPERTY_DEFINITION);
        try {
            new AgentControllerImpl(commandLineProps);
        }
        catch (Exception ex) {
            log.error("Error while starting agent controller", (Throwable)ex);
            System.exit(1);
        }
    }

    private static CommandLine parseCommandLine(String[] args) {
        Options options = Main.createCommandLineOptions();
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(options, args);
        }
        catch (ParseException ex) {
            Main.printUsageInfoAndExit(options);
            return null;
        }
    }

    private static Options createCommandLineOptions() {
        Options options = new Options();
        Option propertyDefinition = new Option(OPTION_PROPERTY_DEFINITION, true, "override a property in file 'agentcontroller.properties'");
        propertyDefinition.setValueSeparator('=');
        propertyDefinition.setArgName("property=value");
        propertyDefinition.setArgs(2);
        options.addOption(propertyDefinition);
        return options;
    }

    private static void printUsageInfoAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("Usage: ");
        formatter.setWidth(79);
        System.out.println();
        formatter.printHelp("agentcontroller [<options>]", "\nOptions:", options, "");
        System.out.println();
        System.exit(2);
    }
}

