/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine;

import com.xceptance.common.lang.ParseNumbers;
import com.xceptance.xlt.api.engine.TimerData;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RequestData
extends TimerData {
    private static final String TYPE_CODE = "R";
    private static final char IP_ADDRESSES_SEPARATOR = '|';
    private int bytesReceived;
    private int bytesSent;
    private int connectTime;
    private String contentType;
    private int receiveTime;
    private int responseCode;
    private int sendTime;
    private int serverBusyTime;
    private int timeToFirstBytes;
    private int timeToLastBytes;
    private int dnsTime;
    private String requestId;
    private String responseId;
    private String url;
    private String httpMethod;
    private String formDataEncoding;
    private String formData;
    private String ipAddresses;

    public RequestData() {
        this(null);
    }

    public RequestData(String name) {
        super(name, TYPE_CODE);
    }

    public int getBytesReceived() {
        return this.bytesReceived;
    }

    public int getBytesSent() {
        return this.bytesSent;
    }

    public int getConnectTime() {
        return this.connectTime;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getReceiveTime() {
        return this.receiveTime;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public int getSendTime() {
        return this.sendTime;
    }

    public int getServerBusyTime() {
        return this.serverBusyTime;
    }

    public int getTimeToFirstBytes() {
        return this.timeToFirstBytes;
    }

    public int getTimeToLastBytes() {
        return this.timeToLastBytes;
    }

    @Deprecated
    public String getId() {
        return this.getRequestId();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getResponseId() {
        return this.responseId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getFormDataEncoding() {
        return this.formDataEncoding;
    }

    public String getFormData() {
        return this.formData;
    }

    public int getDnsTime() {
        return this.dnsTime;
    }

    public String[] getIpAddresses() {
        return StringUtils.split((String)this.ipAddresses, (char)'|');
    }

    public void setBytesReceived(int responseSize) {
        if (responseSize < 0) {
            throw new IllegalArgumentException("Response size must not be negative: '" + responseSize + "'.");
        }
        this.bytesReceived = responseSize;
    }

    public void setBytesSent(int requestSize) {
        if (requestSize < 0) {
            throw new IllegalArgumentException("Request size must not be negative: '" + requestSize + "'.");
        }
        this.bytesSent = requestSize;
    }

    public void setConnectTime(int connectTime) {
        this.connectTime = connectTime;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setReceiveTime(int receiveTime) {
        this.receiveTime = receiveTime;
    }

    @Deprecated
    public void setId(String id) {
        this.setRequestId(id);
    }

    public void setRequestId(String id) {
        this.requestId = id;
    }

    public void setResponseId(String id) {
        this.responseId = id;
    }

    public void setResponseCode(int responseCode) {
        if (responseCode < 0) {
            throw new IllegalArgumentException("Response code must not be negative: " + responseCode + "'.");
        }
        this.responseCode = responseCode;
    }

    public void setSendTime(int sendTime) {
        this.sendTime = sendTime;
    }

    public void setServerBusyTime(int serverBusyTime) {
        this.serverBusyTime = serverBusyTime;
    }

    public void setTimeToFirstBytes(int timeToFirstBytes) {
        this.timeToFirstBytes = timeToFirstBytes;
    }

    public void setTimeToLastBytes(int timeToLastBytes) {
        this.timeToLastBytes = timeToLastBytes;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setFormDataEncoding(String encoding) {
        this.formDataEncoding = encoding;
    }

    public void setFormData(String formData) {
        this.formData = formData;
    }

    public void setDnsTime(int dnsTime) {
        this.dnsTime = dnsTime;
    }

    public void setIpAddresses(String[] ipAddresses) {
        this.ipAddresses = StringUtils.join((Object[])ipAddresses, (char)'|');
    }

    @Override
    protected List<String> addValues() {
        List<String> fields = super.addValues();
        fields.add(Integer.toString(this.bytesSent));
        fields.add(Integer.toString(this.bytesReceived));
        fields.add(Integer.toString(this.responseCode));
        fields.add(StringUtils.defaultString((String)this.url));
        fields.add(StringUtils.defaultString((String)this.contentType));
        fields.add(String.valueOf(this.connectTime));
        fields.add(String.valueOf(this.sendTime));
        fields.add(String.valueOf(this.serverBusyTime));
        fields.add(String.valueOf(this.receiveTime));
        fields.add(String.valueOf(this.timeToFirstBytes));
        fields.add(String.valueOf(this.timeToLastBytes));
        fields.add(StringUtils.defaultString((String)this.requestId));
        fields.add(StringUtils.defaultString((String)this.httpMethod));
        fields.add(StringUtils.defaultString((String)this.formDataEncoding));
        fields.add(StringUtils.defaultString((String)this.formData));
        fields.add(String.valueOf(this.dnsTime));
        fields.add(StringUtils.defaultString((String)this.ipAddresses));
        fields.add(StringUtils.defaultString((String)this.responseId));
        return fields;
    }

    @Override
    protected int getMinNoCSVElements() {
        return 8;
    }

    @Override
    protected void parseValues(String[] values) {
        super.parseValues(values);
        this.setBytesSent(ParseNumbers.parseInt(values[5]));
        this.setBytesReceived(ParseNumbers.parseInt(values[6]));
        this.setResponseCode(ParseNumbers.parseInt(values[7]));
        if (values.length > 22) {
            this.url = values[8];
            this.contentType = values[9];
            this.setConnectTime(ParseNumbers.parseInt(values[10]));
            this.setSendTime(ParseNumbers.parseInt(values[11]));
            this.setServerBusyTime(ParseNumbers.parseInt(values[12]));
            this.setReceiveTime(ParseNumbers.parseInt(values[13]));
            this.setTimeToFirstBytes(ParseNumbers.parseInt(values[14]));
            this.setTimeToLastBytes(ParseNumbers.parseInt(values[15]));
            this.setRequestId(values[16]);
            this.setHttpMethod(values[17]);
            this.setFormDataEncoding(values[18]);
            this.setFormData(values[19]);
            this.setDnsTime(ParseNumbers.parseInt(values[20]));
            this.ipAddresses = values[21];
            this.setResponseId(values[22]);
        } else {
            this.parseLegacyValues(values);
        }
    }

    private void parseLegacyValues(String[] values) {
        int length = values.length;
        if (length > 8) {
            this.url = values[8];
        }
        if (length > 9) {
            this.contentType = values[9];
        }
        if (length > 10) {
            this.setConnectTime(ParseNumbers.parseInt(values[10]));
            this.setSendTime(ParseNumbers.parseInt(values[11]));
            this.setServerBusyTime(ParseNumbers.parseInt(values[12]));
            this.setReceiveTime(ParseNumbers.parseInt(values[13]));
            this.setTimeToFirstBytes(ParseNumbers.parseInt(values[14]));
            this.setTimeToLastBytes(ParseNumbers.parseInt(values[15]));
        }
        if (length > 16) {
            this.setRequestId(values[16]);
        }
        if (length > 17) {
            this.setHttpMethod(values[17]);
            this.setFormDataEncoding(values[18]);
            this.setFormData(values[19]);
        }
        if (length > 20) {
            this.setDnsTime(ParseNumbers.parseInt(values[20]));
        }
    }
}

