/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.validators;

import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.Assert;

public class ContentLengthValidator {
    public void validate(HtmlPage page) {
        this.validate(page.getWebResponse());
    }

    public void validate(LightWeightPage page) {
        this.validate(page.getWebResponse());
    }

    private void validate(WebResponse response) {
        String encoding = response.getResponseHeaderValue("Content-Encoding");
        if (encoding != null && encoding.contains("gzip")) {
            return;
        }
        String contentLengthStr = response.getResponseHeaderValue("Content-Length");
        if (contentLengthStr == null || contentLengthStr.trim().length() == 0) {
            return;
        }
        int contentLength = Integer.parseInt(contentLengthStr);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream is = response.getContentAsStream();){
            if (is != null) {
                IOUtils.copy((InputStream)is, (OutputStream)out);
            }
        }
        catch (IOException ioe) {
            Assert.fail((String)("Failed to read response: " + ioe.getMessage()));
        }
        byte[] bytes = out.toByteArray();
        Assert.assertEquals((String)"Content Length of download and announced size from HTTP header do not match.", (long)contentLength, (long)bytes.length);
    }

    public static ContentLengthValidator getInstance() {
        return new ContentLengthValidator();
    }
}

