/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.webdriver;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitDriver;
import com.xceptance.xlt.engine.xltdriver.WebDriverXltWebClient;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public final class XltDriver
extends HtmlUnitDriver {
    public XltDriver() {
        this((BrowserVersion)null, (Boolean)null);
    }

    public XltDriver(boolean enableJavaScript) {
        this((BrowserVersion)null, (Boolean)enableJavaScript);
    }

    public XltDriver(BrowserVersion version) {
        this(version, null);
    }

    public XltDriver(BrowserVersion version, boolean enableJavaScript) {
        this(version, (Boolean)enableJavaScript);
    }

    private XltDriver(BrowserVersion version, Boolean enableJavaScript) {
        super(version);
        if (enableJavaScript == null) {
            enableJavaScript = XltProperties.getInstance().getProperty("com.xceptance.xlt.javaScriptEnabled", false);
        }
        this.setJavascriptEnabled(enableJavaScript);
    }

    @Override
    protected WebClient newWebClient(BrowserVersion version) {
        return new WebDriverXltWebClient(version);
    }

    @Override
    public WebClient getWebClient() {
        return super.getWebClient();
    }

    @Override
    public void quit() {
        WebDriverXltWebClient client = (WebDriverXltWebClient)this.getWebClient();
        if (client != null) {
            client.quit();
        }
    }

    @Override
    public WebElement findElement(By by) {
        return super.findElement(by);
    }

    @Override
    public List<WebElement> findElements(By by) {
        return super.findElements(by);
    }

    @Override
    public WebDriver.Navigation navigate() {
        return super.navigate();
    }

    @Override
    public WebDriver.Options manage() {
        return super.manage();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public String getPageSource() {
        return super.getPageSource();
    }

    @Override
    public String getWindowHandle() {
        return super.getWindowHandle();
    }

    @Override
    public Set<String> getWindowHandles() {
        return super.getWindowHandles();
    }

    @Override
    public String getCurrentUrl() {
        return super.getCurrentUrl();
    }

    @Override
    public void get(String url) {
        super.get(url);
    }

    @Override
    public String getTitle() {
        return super.getTitle();
    }
}

