/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.DescribeRegionsRequest;
import com.amazonaws.services.ec2.model.DescribeRegionsResult;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.ec2.model.DescribeVpcsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.Region;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagDescription;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.Vpc;
import com.amazonaws.util.Base64;
import com.xceptance.common.lang.ReflectionUtils;
import com.xceptance.xlt.ec2.AwsConfiguration;
import com.xceptance.xlt.engine.TimeoutException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEC2Client {
    private static final String DEFAULT_REGION = "us-east-1";
    private final HashMap<String, AmazonEC2> clientsByRegion = new HashMap();
    private final ClientConfiguration clientConfig;
    protected final AwsConfiguration awsConfiguration;
    public static final String STATE_RUNNING = "running";
    public static final String STATE_AVAILABLE = "available";
    private static final long INSTANCE_STATE_POLLING_INTERVAL = 1000L;
    private static final long IMAGE_STATE_POLLING_INTERVAL = 1000L;
    protected static final Logger log = LoggerFactory.getLogger(AbstractEC2Client.class);
    private static final Pattern INSTANCE_PRICING_JSON_PATTERN = Pattern.compile("callback\\(\\{vers:[\\d.]+,config:\\{.+?,regions:\\[.+\\]\\}\\}\\);");

    public AbstractEC2Client() throws Exception {
        this(null, null);
    }

    public AbstractEC2Client(String accessKey, String secretKey) throws Exception {
        try {
            this.awsConfiguration = new AwsConfiguration(accessKey, secretKey);
            this.clientConfig = new ClientConfiguration();
            this.clientConfig.setProtocol(this.awsConfiguration.getProtocol());
            this.clientConfig.setProxyHost(this.awsConfiguration.getProxyHost());
            this.clientConfig.setProxyPort(this.awsConfiguration.getProxyPort());
            this.clientConfig.setProxyUsername(this.awsConfiguration.getProxyUserName());
            this.clientConfig.setProxyPassword(this.awsConfiguration.getProxyPassword());
        }
        catch (Exception e) {
            System.err.println("Failed to initialize AWS EC2 client: " + e.getMessage());
            log.error("Failed to initialize AWS EC2 client", (Throwable)e);
            throw e;
        }
    }

    protected AmazonEC2 getClient(Region region) {
        return this.clientForRegion(region == null ? DEFAULT_REGION : region.getRegionName());
    }

    private AmazonEC2 clientForRegion(String regionName) {
        AmazonEC2 client = this.clientsByRegion.get(regionName);
        if (client == null) {
            client = (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2Client.builder().withClientConfiguration(this.clientConfig)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.awsConfiguration.getAccessKey(), this.awsConfiguration.getSecretKey())))).withRegion(regionName)).build();
            this.clientsByRegion.put(regionName, client);
        }
        return client;
    }

    protected Instance waitForInstanceState(Region region, Instance instance, String state, long timeout) throws Exception {
        long deadline = System.currentTimeMillis() + timeout;
        String instanceId = instance.getInstanceId();
        while (System.currentTimeMillis() < deadline) {
            Instance foundInstance = this.getInstance(region, instanceId, new ArrayList<TagDescription>(), state);
            if (foundInstance != null) {
                return foundInstance;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        throw new Exception("Instance didn't achieve state '" + state + "' within " + timeout / 1000L + "s. Current state is '" + instance.getState().getName() + "'");
    }

    protected Image waitForImageState(Region region, String imageID, String state, long timeout) throws Exception {
        Image image = null;
        long deadline = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < deadline) {
            image = this.getImage(region, imageID);
            if (image != null && image.getState().equals(state)) {
                return image;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (image == null) {
            throw new Exception("Image '" + imageID + "' not found in region '" + region.getRegionName() + "'.");
        }
        throw new Exception("Image didn't achieve state '" + state + "' within " + timeout / 1000L + "s. Current state is '" + image.getState() + "'");
    }

    protected List<AvailabilityZone> getAvailabilityZones(Region region) {
        return this.getClient(region).describeAvailabilityZones().getAvailabilityZones();
    }

    protected List<SecurityGroup> getSecurityGroupIDs(Region region) {
        List secGroups = this.getClient(region).describeSecurityGroups().getSecurityGroups();
        Collections.sort(secGroups, new Comparator<SecurityGroup>(){

            @Override
            public int compare(SecurityGroup i1, SecurityGroup i2) {
                String d1 = StringUtils.defaultString((String)i1.getGroupName().toLowerCase());
                String d2 = StringUtils.defaultString((String)i2.getGroupName().toLowerCase());
                return d1.compareTo(d2);
            }
        });
        return secGroups;
    }

    protected List<Image> getImages(Region region, String ... imageIds) {
        DescribeImagesRequest describeImagesRequest = new DescribeImagesRequest().withOwners(new String[]{"self", "614612213257"}).withImageIds(imageIds);
        List images = this.getClient(region).describeImages(describeImagesRequest).getImages();
        return images;
    }

    protected List<KeyPairInfo> getKeyPairs(Region region) {
        DescribeKeyPairsResult describeKeyPairsResult = this.getClient(region).describeKeyPairs();
        List keyPairInfos = describeKeyPairsResult.getKeyPairs();
        Collections.sort(keyPairInfos, new Comparator<KeyPairInfo>(){

            @Override
            public int compare(KeyPairInfo i1, KeyPairInfo i2) {
                String d1 = StringUtils.defaultString((String)i1.getKeyName());
                String d2 = StringUtils.defaultString((String)i2.getKeyName());
                return d1.compareTo(d2);
            }
        });
        return keyPairInfos;
    }

    protected Image getImage(Region region, String imageId) {
        List<Image> images = this.getImages(region, imageId);
        Image image = null;
        for (Image img : images) {
            if (!img.getImageId().equals(imageId)) continue;
            image = img;
            break;
        }
        return image;
    }

    protected List<String> getRunningInstanceIds(Region region, List<TagDescription> tags) {
        ArrayList<String> instanceIds = new ArrayList<String>();
        for (Instance instance : this.getInstances(region, tags, STATE_RUNNING)) {
            instanceIds.add(instance.getInstanceId());
        }
        return instanceIds;
    }

    protected Instance getInstance(Region region, String instanceID, List<TagDescription> tags, String state) {
        List<Instance> instances = this.getInstances(region, new ArrayList<TagDescription>(), state);
        for (Instance instance : instances) {
            if (!instance.getInstanceId().equals(instanceID)) continue;
            return instance;
        }
        return null;
    }

    protected List<Instance> getInstances(Region region, List<TagDescription> tags, String state) {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        for (TagDescription tag : tags) {
            String key = tag.getKey();
            Filter filter = (Filter)filters.get(key);
            if (filter == null) {
                filter = new Filter("tag:" + key);
                filters.put(key, filter);
            }
            filter.withValues(new String[]{tag.getValue()});
        }
        if (state != null) {
            Filter stateFilter = new Filter("instance-state-name");
            stateFilter.withValues(new String[]{state});
            filters.put("instance-state", stateFilter);
        }
        ArrayList<Instance> instances = new ArrayList<Instance>();
        DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest();
        describeInstancesRequest.setFilters(filters.values());
        DescribeInstancesResult describeInstancesResult = this.getClient(region).describeInstances(describeInstancesRequest);
        for (Reservation reservation : describeInstancesResult.getReservations()) {
            instances.addAll(reservation.getInstances());
        }
        return instances;
    }

    protected List<Instance> getInstances(Region region, List<TagDescription> tags) {
        return this.getInstances(region, tags, null);
    }

    protected List<Region> getRegions(String ... regionNames) {
        DescribeRegionsRequest describeRegionsRequest = new DescribeRegionsRequest();
        describeRegionsRequest.setRegionNames(Arrays.asList(regionNames));
        describeRegionsRequest.setAllRegions(Boolean.valueOf(true));
        DescribeRegionsResult describeRegionsResult = this.getClient(null).describeRegions(describeRegionsRequest);
        List regions = describeRegionsResult.getRegions();
        Collections.sort(regions, (r1, r2) -> {
            String s1 = StringUtils.defaultString((String)r1.getRegionName());
            String s2 = StringUtils.defaultString((String)r2.getRegionName());
            return s1.compareTo(s2);
        });
        return regions;
    }

    protected Region getRegion(String regionName) {
        List<Region> regions = this.getRegions(regionName);
        return regions.size() == 1 ? regions.get(0) : null;
    }

    protected static CommandLine parseCommandLine(Options options, String[] args) {
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(options, args);
        }
        catch (ParseException ex) {
            AbstractEC2Client.printUsageInfo(options);
            System.exit(2);
            return null;
        }
    }

    protected static void printUsageInfo(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        System.out.println("Simple front-end application to manage AWS EC2 instances.");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("    ec2_admin [<options>]");
        System.out.println("      -> Run in interactive mode.\n");
        System.out.println("    ec2_admin run <region> <ami> <type> <count> <nameTag> [<options>]");
        System.out.println("      -> Start instances non-interactively.\n");
        System.out.println("    ec2_admin terminate <region> <nameTag>");
        System.out.println("      -> Terminate instances non-interactively.");
        formatter.setSyntaxPrefix("");
        formatter.setWidth(79);
        formatter.printHelp(" ", "Options:", options, "");
        System.out.println();
    }

    protected List<Subnet> getSubnets(Region region, AvailabilityZone availabilityZone, Vpc vpc) {
        DescribeSubnetsRequest req = new DescribeSubnetsRequest();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (availabilityZone != null) {
            filters.add(new Filter("availability-zone", Arrays.asList(availabilityZone.getZoneName())));
        }
        if (vpc != null) {
            filters.add(new Filter("vpc-id", Arrays.asList(vpc.getVpcId())));
        }
        req.setFilters(filters);
        return this.getClient(region).describeSubnets(req).getSubnets();
    }

    protected List<Vpc> getVpcs(Region region, List<String> vpcIds) {
        DescribeVpcsRequest vpcReq = new DescribeVpcsRequest();
        if (vpcIds != null && !vpcIds.isEmpty()) {
            vpcReq.withFilters(new Filter[]{new Filter("vpc-id", vpcIds)});
        }
        return this.getClient(region).describeVpcs(vpcReq).getVpcs();
    }

    protected List<Instance> runInstances(Region region, Subnet subnet, Image image, String instanceType, int count, Collection<String> securityGroupIds, String keyPairName, String userData) throws Exception {
        List<Subnet> subnets;
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest();
        if (subnet == null && !(subnets = this.getSubnets(region, null, null)).isEmpty()) {
            subnet = subnets.parallelStream().filter(s -> s.isDefaultForAz()).findAny().orElse(subnets.get(0));
        }
        if (subnet == null) {
            throw new Exception("No subnet available to launch instances into");
        }
        runInstancesRequest.setPlacement(new Placement(subnet.getAvailabilityZone()));
        runInstancesRequest.setSubnetId(subnet.getSubnetId());
        runInstancesRequest.setImageId(image.getImageId());
        runInstancesRequest.setInstanceType(instanceType);
        runInstancesRequest.setMinCount(Integer.valueOf(count));
        runInstancesRequest.setMaxCount(Integer.valueOf(count));
        if (StringUtils.isNotBlank((CharSequence)userData)) {
            runInstancesRequest.setUserData(Base64.encodeAsString((byte[])userData.getBytes()));
        }
        if (securityGroupIds != null) {
            runInstancesRequest.setSecurityGroupIds(securityGroupIds);
        }
        if (StringUtils.isNotBlank((CharSequence)keyPairName)) {
            runInstancesRequest.setKeyName(keyPairName);
        }
        RunInstancesResult result = this.getClient(region).runInstances(runInstancesRequest);
        List instances = result.getReservation().getInstances();
        return instances;
    }

    protected void terminateInstances(List<Region> regions, List<TagDescription> tags) {
        System.out.println();
        for (Region region : regions) {
            try {
                System.out.printf("Terminating %s instances in region '%s' ... ", tags.isEmpty() ? "all" : "the selected", region.getRegionName());
                TerminateInstancesRequest terminateInstancesRequest = new TerminateInstancesRequest();
                terminateInstancesRequest.setInstanceIds(this.getRunningInstanceIds(region, tags));
                this.getClient(region).terminateInstances(terminateInstancesRequest);
                System.out.println("OK.");
            }
            catch (AmazonClientException e) {
                System.out.println("Failed: " + e.getMessage());
            }
        }
    }

    protected void terminateInstance(Region region, Instance instance) {
        TerminateInstancesRequest terminateInstancesRequest = new TerminateInstancesRequest();
        terminateInstancesRequest.setInstanceIds(Arrays.asList(instance.getInstanceId()));
        this.getClient(region).terminateInstances(terminateInstancesRequest);
    }

    protected void setNameTag(Region region, List<String> ids, String name) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag().withKey("Name").withValue(name));
        CreateTagsRequest createTagRequest = new CreateTagsRequest();
        createTagRequest.setResources(ids);
        createTagRequest.setTags(tags);
        this.getClient(region).createTags(createTagRequest);
    }

    protected void waitForInstancesToEventuallyExist(Region region, List<Instance> instances, long timeout) throws InterruptedException {
        List<String> instanceIds = this.getInstanceIds(instances);
        long deadline = System.currentTimeMillis() + timeout;
        while (true) {
            AmazonServiceException lastException = null;
            try {
                DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest();
                describeInstancesRequest.setInstanceIds(instanceIds);
                this.getClient(region).describeInstances(describeInstancesRequest);
                return;
            }
            catch (AmazonServiceException e) {
                if (!"InvalidInstanceID.NotFound".equals(e.getErrorCode())) {
                    throw e;
                }
                lastException = e;
                log.debug("Not all previously created instances are alive yet: " + e.getMessage());
                if (System.currentTimeMillis() < deadline) {
                    Thread.sleep(1000L);
                    continue;
                }
                throw new TimeoutException("One or more instances did not become alive within " + timeout / 1000L + " seconds", lastException);
            }
            break;
        }
    }

    protected List<String> getInstanceIds(List<Instance> instances) {
        ArrayList<String> instanceIds = new ArrayList<String>(instances.size());
        for (Instance instance : instances) {
            instanceIds.add(instance.getInstanceId());
        }
        return instanceIds;
    }

    protected String getPriceInfo() {
        String s = this.downloadPriceInfo(this.awsConfiguration.getInstancePricingUrl() + "?callback=callback&_=" + System.currentTimeMillis());
        if (s == null) {
            s = this.readSamplePriceInfo();
        }
        if (s == null) {
            return null;
        }
        return StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)s, (String)"callback("), (String)")");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readSamplePriceInfo() {
        try (InputStream is = this.getClass().getResourceAsStream("linux-od.min.js");){
            if (is == null) return null;
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
        catch (Throwable t) {
            log.error("Failed to read sample price info file", t);
        }
        return null;
    }

    private String downloadPriceInfo(String uri) {
        String errMsg = "Failed to download price info from URL '" + uri + "'";
        try {
            HttpGet request = new HttpGet(uri);
            HttpResponse resp = this.getUnderlyingHttpClient().execute((HttpUriRequest)request);
            int statusCode = resp.getStatusLine().getStatusCode();
            if (200 != statusCode) {
                log.error(errMsg + ": server responded with status code " + statusCode);
            } else {
                String responseContent = EntityUtils.toString((HttpEntity)resp.getEntity());
                Matcher m = INSTANCE_PRICING_JSON_PATTERN.matcher(responseContent);
                if (m.find()) {
                    return responseContent;
                }
                log.error(errMsg + ": response is either no valid JSON or malformed.");
            }
        }
        catch (Throwable t) {
            log.error(errMsg, t);
        }
        System.out.println("\nWARNING: Instance pricing could not be retrieved. Please check the log for details.\n         Availability of instance types and their prices might be out of date.");
        return null;
    }

    protected HttpClient getUnderlyingHttpClient() {
        AmazonEC2Client awsClient = (AmazonEC2Client)this.getClient(null);
        AmazonHttpClient ahc = (AmazonHttpClient)ReflectionUtils.readInstanceField(awsClient, "client");
        return (HttpClient)ReflectionUtils.readInstanceField(ahc, "httpClient");
    }

    public void shutdown() {
        this.clientsByRegion.values().forEach(AmazonEC2::shutdown);
    }
}

