/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.htmlunit.apache;

import com.gargoylesoftware.htmlunit.DownloadedContent;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.xceptance.common.lang.ReflectionUtils;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.dns.XltDnsResolver;
import com.xceptance.xlt.engine.htmlunit.apache.HttpDeleteWithBody;
import com.xceptance.xlt.engine.htmlunit.apache.XltDnsResolverAdapterForApache;
import com.xceptance.xlt.engine.htmlunit.apache.XltHttpRequestRetryHandler;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

public class XltApacheHttpWebConnection
extends HttpWebConnection {
    public XltApacheHttpWebConnection(WebClient webClient) {
        super(webClient);
    }

    @Override
    protected HttpClientBuilder createHttpClientBuilder() {
        HttpClientBuilder builder = super.createHttpClientBuilder();
        XltApacheHttpWebConnection.customizeHttpClientBuilderForXlt(builder);
        return builder;
    }

    @Override
    protected void configureHttpProcessorBuilder(HttpClientBuilder builder, WebRequest webRequest) {
        super.configureHttpProcessorBuilder(builder, webRequest);
        XltApacheHttpWebConnection.setXltRequestExecutor(builder, webRequest);
    }

    private static void customizeHttpClientBuilderForXlt(HttpClientBuilder httpClientBuilder) {
        XltProperties props = XltProperties.getInstance();
        boolean staleConnections = props.getProperty("com.xceptance.xlt.http.keepAlive.staleConnectionCheck", props.getProperty("com.xceptance.xlt.keepAlive.staleConnectionCheck", true));
        RequestConfig defaultRequestConfig = (RequestConfig)ReflectionUtils.readInstanceField(httpClientBuilder, "defaultRequestConfig");
        RequestConfig.Builder newRequestConfiguilder = defaultRequestConfig == null ? RequestConfig.custom() : RequestConfig.copy((RequestConfig)defaultRequestConfig);
        RequestConfig newRequestConfig = newRequestConfiguilder.setStaleConnectionCheckEnabled(staleConnections).build();
        httpClientBuilder.setDefaultRequestConfig(newRequestConfig);
        SocketConfig defaultSocketConfig = (SocketConfig)ReflectionUtils.readInstanceField(httpClientBuilder, "defaultSocketConfig");
        SocketConfig.Builder newSocketConfigBuilder = defaultSocketConfig == null ? SocketConfig.custom() : SocketConfig.copy((SocketConfig)defaultSocketConfig);
        SocketConfig newSocketConfig = newSocketConfigBuilder.setTcpNoDelay(true).build();
        httpClientBuilder.setDefaultSocketConfig(newSocketConfig);
        int threadCount = props.getProperty("com.xceptance.xlt.staticContent.downloadThreads", 4);
        if (threadCount <= 0) {
            threadCount = 1;
        }
        httpClientBuilder.setMaxConnPerRoute(threadCount);
        boolean retryEnabled = props.getProperty("com.xceptance.xlt.http.retry.enabled", true);
        int retryCount = props.getProperty("com.xceptance.xlt.http.retry.count", 3);
        boolean retryNonIdempotentRequests = props.getProperty("com.xceptance.xlt.http.retry.nonIdempotentRequests", true);
        int effectiveRetryCount = retryEnabled ? retryCount : 0;
        XltHttpRequestRetryHandler requestRetryHandler = new XltHttpRequestRetryHandler(effectiveRetryCount, retryNonIdempotentRequests);
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)requestRetryHandler);
        httpClientBuilder.disableContentCompression();
        httpClientBuilder.setDnsResolver((DnsResolver)new XltDnsResolverAdapterForApache(new XltDnsResolver()));
    }

    private static void setXltRequestExecutor(HttpClientBuilder httpClientBuilder, final WebRequest webRequest) {
        httpClientBuilder.setRequestExecutor(new HttpRequestExecutor(){

            protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
                LinkedHashMap<String, String> requestHeaders = new LinkedHashMap<String, String>();
                for (Header header : request.getAllHeaders()) {
                    requestHeaders.put(header.getName(), header.getValue());
                }
                webRequest.setAdditionalHeaders(requestHeaders);
                return super.doSendRequest(request, conn, context);
            }
        });
    }

    @Override
    protected WebResponse makeWebResponse(HttpResponse httpResponse, WebRequest webRequest, DownloadedContent responseBody, long loadTime) {
        WebResponse webResponse = super.makeWebResponse(httpResponse, webRequest, responseBody, loadTime);
        webResponse.setProtocolVersion(httpResponse.getProtocolVersion().toString());
        return webResponse;
    }

    @Override
    protected HttpRequestBase buildHttpMethod(HttpMethod submitMethod, URI uri) {
        HttpDeleteWithBody method;
        switch (submitMethod) {
            case DELETE: {
                method = new HttpDeleteWithBody(uri);
                break;
            }
            default: {
                method = super.buildHttpMethod(submitMethod, uri);
            }
        }
        return method;
    }
}

