/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import com.xceptance.common.lang.StringUtils;
import com.xceptance.common.xml.HtmlDomPrinter;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.LightWeightPageImpl;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.XltEngine;
import com.xceptance.xlt.engine.har.HarWriter;
import com.xceptance.xlt.engine.resultbrowser.CrcUrlMapping;
import com.xceptance.xlt.engine.resultbrowser.HarExporter;
import com.xceptance.xlt.engine.resultbrowser.Page;
import com.xceptance.xlt.engine.resultbrowser.PageDOMClone;
import com.xceptance.xlt.engine.resultbrowser.PageTransformer;
import com.xceptance.xlt.engine.resultbrowser.Request;
import com.xceptance.xlt.engine.resultbrowser.RequestDataMgr;
import com.xceptance.xlt.engine.resultbrowser.TransactionInfo;
import com.xceptance.xlt.engine.resultbrowser.UrlMapping;
import com.xceptance.xlt.engine.util.CssUtils;
import com.xceptance.xlt.engine.util.URLCleaner;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DumpMgr {
    private static final Logger LOG = LoggerFactory.getLogger(DumpMgr.class);
    private static final String[] HTML_CONTENT_TYPES = new String[]{"text/html", "application/xhtml+xml"};
    private static final String LAST_PAGE_FORMAT = "<!DOCTYPE html>\n<html><head><title>%s - XLT Result Browser</title></head><body style='margin:0; padding:0'><iframe src='%s/index.html' style='display:block; border:none; width:100vw; height:100vh;'></iframe></body></html>";
    private static final int FILENAME_LENGTH_LIMIT = 80;
    private File cacheDirectory;
    private File pageDirectory;
    private File responseDirectory;
    private File dumpDirectory;
    private int pageCounter = 0;
    private int responseCounter = 0;
    private RequestDataMgr dataMgr = new RequestDataMgr();
    private UrlMapping urlMapping = new CrcUrlMapping();
    private boolean harExportEnabled;

    DumpMgr() {
    }

    public RequestDataMgr getRequestDataManager() {
        return this.dataMgr;
    }

    public void setRequestDataManager(RequestDataMgr requestDataMgr) {
        if (requestDataMgr != null) {
            this.dataMgr = requestDataMgr;
        }
    }

    public UrlMapping getUrlMapping() {
        return this.urlMapping;
    }

    public void setUrlMapping(UrlMapping mapping) {
        if (mapping != null) {
            this.urlMapping = mapping;
        }
    }

    void setHarExportEnabled(boolean enabled) {
        this.harExportEnabled = enabled;
    }

    private File getDumpDirectory() {
        if (this.dumpDirectory == null) {
            SessionImpl session = (SessionImpl)Session.getCurrent();
            this.dumpDirectory = new File(new File(session.getResultsDirectory(), "output"), session.getID());
            this.dumpDirectory.mkdirs();
        }
        return this.dumpDirectory;
    }

    private File getCacheDirectory() {
        if (this.cacheDirectory == null) {
            this.cacheDirectory = new File(this.getPagesDirectory(), "cache");
            this.cacheDirectory.mkdirs();
        }
        return this.cacheDirectory;
    }

    private File getPagesDirectory() {
        if (this.pageDirectory == null) {
            this.pageDirectory = new File(this.getDumpDirectory(), "pages");
            this.pageDirectory.mkdirs();
        }
        return this.pageDirectory;
    }

    private File getResponseDirectory() {
        if (this.responseDirectory == null) {
            this.responseDirectory = new File(this.getDumpDirectory(), "responses");
            this.responseDirectory.mkdirs();
        }
        return this.responseDirectory;
    }

    public void dump(Page page) {
        if (page == null) {
            return;
        }
        String fileName = DumpMgr.getDumpFileName(page.getName(), this.pageCounter++, true);
        if (page.isScreenshotPage()) {
            fileName = fileName.replaceAll("\\.html$", ".png");
        }
        File file = new File(this.getPagesDirectory(), fileName);
        this.dumpPage(page, file);
        this.dataMgr.pageDumped(fileName, page);
    }

    private static String getDumpFileName(String fileName, int counter, boolean isHtml) {
        if (((String)(fileName = com.xceptance.common.io.FileUtils.convertIllegalCharsInFileName((String)fileName))).length() > 80) {
            fileName = ((String)fileName).substring(0, 80);
        }
        fileName = String.format("%04d-%s", counter, fileName);
        if (isHtml) {
            fileName = (String)fileName + ".html";
        }
        return fileName;
    }

    public void dump(Request request) {
        if (request == null) {
            return;
        }
        String name = request.name;
        WebRequest webRequest = request.webRequest;
        WebResponse webResponse = request.webResponse;
        String fileName = null;
        if (webResponse == null || DumpMgr.isHtmlContent(webResponse)) {
            fileName = this.dumpHtmlContent(name, webResponse);
        } else {
            fileName = this.dumpStaticContent(name, webResponse);
            this.dumpStaticContentToCache(webRequest, webResponse);
        }
        this.dataMgr.requestDumped(fileName, request);
    }

    public synchronized void dumpToDisk(List<Page> pages, List<Request> requests) {
        if (pages != null) {
            for (Page page : pages) {
                for (Request request : page.getRequests()) {
                    this.dump(request);
                }
                this.dump(page);
            }
        }
        if (requests != null) {
            for (Request request : requests) {
                this.dump(request);
            }
        }
        this.dumpJson();
        this.printAndOpenResultBrowserUrl();
    }

    private void dumpJson() {
        Session session = Session.getCurrent();
        if (!session.isLoadTest()) {
            File lastRunFile = new File(this.getDumpDirectory(), "../last.html");
            String lastRunFileContent = String.format(LAST_PAGE_FORMAT, session.getUserName(), session.getID());
            try {
                FileUtils.writeStringToFile((File)lastRunFile, (String)lastRunFileContent, (String)"UTF-8");
            }
            catch (IOException e) {
                XltLogger.runTimeLogger.error("Failed to create file: " + lastRunFile, (Throwable)e);
            }
            File shortcutFile = new File(this.getDumpDirectory(), "../../../../" + session.getUserName() + ".html");
            String path = com.xceptance.common.io.FileUtils.computeRelativeUri(shortcutFile, this.dumpDirectory, false);
            String shortcutFileContent = String.format(LAST_PAGE_FORMAT, session.getUserName(), path);
            try {
                FileUtils.writeStringToFile((File)shortcutFile, (String)shortcutFileContent, (String)"UTF-8");
            }
            catch (IOException e) {
                XltLogger.runTimeLogger.error("Failed to create file: " + shortcutFile, (Throwable)e);
            }
        }
        this.copyResources();
        this.generateJsonFile();
    }

    private void copyResources() {
        for (String resource : this.resourcesToCopy()) {
            URL url = this.getClass().getResource("assets/" + resource);
            File file = new File(this.getDumpDirectory(), resource);
            try {
                FileUtils.copyURLToFile((URL)url, (File)file);
            }
            catch (Exception e) {
                XltLogger.runTimeLogger.error("Failed to copy resource file: " + resource, (Throwable)e);
            }
        }
    }

    private String[] resourcesToCopy() {
        String[] resources = new String[]{"index.html", "css/default.css", "css/jsonview.css", "images/progress.gif", "images/arrow-bottom-right.gif", "images/arrow-right.gif", "images/xlt-logo.png", "js/jquery-2.2.4.js", "js/jsonview.js", "js/moment-2.24.0.js", "js/resultbrowser.js", "js/simple-splitter.js"};
        String[] harResources = new String[]{"harviewer.html", "js/harPreview.js", "js/require-2.3.2.js", "css/harPreview.css", "css/images/bg-button.gif", "css/images/contextMenuTarget.png", "css/images/contextMenuTargetHover.png", "css/images/loading_16.gif", "css/images/menu/tabMenuPin.png", "css/images/menu/tabMenuRadio.png", "css/images/menu/shadowAlpha.png", "css/images/menu/tabMenuCheckbox.png", "css/images/netBarCached.gif", "css/images/netBarLoaded.gif", "css/images/page-timeline.png", "css/images/splitterh.png", "css/images/tabEnabled.png", "css/images/timeline-sprites.png", "css/images/tooltipConnectorUp.png", "css/images/twisty-sprites.png"};
        if (this.harExportEnabled) {
            int resourceCount = resources.length;
            int harResourceCount = harResources.length;
            String[] r = new String[resourceCount + harResourceCount];
            System.arraycopy(resources, 0, r, 0, resourceCount);
            System.arraycopy(harResources, 0, r, resourceCount, harResourceCount);
            resources = r;
        }
        return resources;
    }

    private void generateJsonFile() {
        TransactionInfo txn = this.dataMgr.generateTransaction();
        this.generateResultBrowserData(txn);
        if (this.harExportEnabled) {
            this.generateHar(txn);
        }
    }

    private void generateResultBrowserData(TransactionInfo transaction) {
        File jsonFile = new File(this.getDumpDirectory(), "data.js");
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), "UTF-8");){
            osw.write("var jsonData = ");
            XStream xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver(){

                public HierarchicalStreamWriter createWriter(Writer writer) {
                    return new JsonWriter(writer, 1);
                }
            });
            xstream.setMode(1001);
            xstream.toXML((Object)transaction, (Writer)osw);
        }
        catch (Exception e) {
            XltLogger.runTimeLogger.error("Failed to generate file: " + jsonFile, (Throwable)e);
        }
    }

    private void generateHar(TransactionInfo transaction) {
        File harFile = new File(this.getDumpDirectory(), "data.har");
        HarWriter harWriter = new HarWriter();
        try {
            harWriter.writeHarLogToFile(new HarExporter(transaction).exportToHAR(), harFile);
        }
        catch (Exception e) {
            XltLogger.runTimeLogger.error("Failed to generate HAR file: " + harFile, (Throwable)e);
        }
    }

    private void dumpPage(Page page, File file) {
        if (page.isEmptyPage()) {
            this.dumpEmptyPage(file);
        } else if (page.isScreenshotPage()) {
            byte[] image = page.getScreenshotPage();
            this.dumpScreenshotPage(image, file);
        } else if (page.isHtmlPage()) {
            PageDOMClone hPage = page.getHtmlPage();
            if (hPage != null) {
                this.dumpHtmlPage(hPage, file);
            }
        } else {
            this.dumpLWPage(page.getLightWeightPage(), file);
        }
    }

    private void dumpHtmlPage(PageDOMClone htmlPage, File file) {
        try {
            boolean outermost = !this.getCacheDirectory().equals(file.getParentFile());
            Document document = new PageTransformer(htmlPage, outermost).transform(this.urlMapping);
            String urlPrefix = outermost ? "cache/" : "";
            for (Map.Entry<Element, PageDOMClone> frameEntry : htmlPage.getFrames().entrySet()) {
                Element frameElement = frameEntry.getKey();
                PageDOMClone framePage = frameEntry.getValue();
                String fileName = StringUtils.crc32(RandomStringUtils.randomAlphanumeric((int)32)) + ".html";
                File framePageFile = new File(this.getCacheDirectory(), fileName);
                this.dumpHtmlPage(framePage, framePageFile);
                String srcValue = urlPrefix + fileName;
                frameElement.setAttribute("src", srcValue);
            }
            String html = new HtmlDomPrinter().printNode(document);
            FileUtils.writeStringToFile((File)file, (String)html, (String)"UTF-8");
        }
        catch (IOException e) {
            XltLogger.runTimeLogger.error("Failed to write HTML page to file: " + file.getAbsolutePath(), (Throwable)e);
        }
        catch (Exception e) {
            XltLogger.runTimeLogger.error("Failed to dump HTML page", (Throwable)e);
        }
    }

    private void dumpLWPage(LightWeightPage lwPage, File file) {
        for (Map.Entry<String, LightWeightPage> frame : ((LightWeightPageImpl)lwPage).getFramePages().entrySet()) {
            this.dumpLWPage(frame.getValue(), new File(this.getCacheDirectory(), frame.getKey() + ".html"));
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)new PageTransformer(lwPage).transformLW(this.urlMapping), (String)"UTF-8");
        }
        catch (IOException ioe) {
            XltLogger.runTimeLogger.error("Cannot write page to file: " + file.getAbsolutePath(), (Throwable)ioe);
        }
    }

    private void dumpScreenshotPage(byte[] image, File file) {
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])image);
        }
        catch (IOException ioe) {
            XltLogger.runTimeLogger.error("Cannot write page to file: " + file.getAbsolutePath(), (Throwable)ioe);
        }
    }

    private void dumpEmptyPage(File file) {
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])new byte[0]);
        }
        catch (IOException ioe) {
            XltLogger.runTimeLogger.error("Cannot write page to file: " + file.getAbsolutePath(), (Throwable)ioe);
        }
    }

    private static boolean isHtmlContent(WebResponse webResponse) {
        return ArrayUtils.contains((Object[])HTML_CONTENT_TYPES, (Object)webResponse.getContentType());
    }

    private String dumpHtmlContent(String name, WebResponse webResponse) {
        File file;
        block12: {
            file = new File(this.getResponseDirectory(), DumpMgr.getDumpFileName(name.replaceAll("\\.(x)?htm(l)?$", ""), this.responseCounter++, true));
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
                if (webResponse == null) break block12;
                Charset charset = new LightWeightPage(webResponse, "dummy").getCharset();
                try (InputStreamReader in = new InputStreamReader(webResponse.getContentAsStream(), charset);){
                    IOUtils.copy((Reader)in, (Writer)out);
                }
            }
            catch (Exception e) {
                XltLogger.runTimeLogger.error("Cannot write page to file: " + file.getAbsolutePath(), (Throwable)e);
            }
        }
        return file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dumpStaticContent(String name, WebResponse webResponse) {
        File file = new File(this.getResponseDirectory(), DumpMgr.getDumpFileName(name, this.responseCounter++, false));
        InputStream content = null;
        try {
            InputStream inputStream = content = webResponse != null ? webResponse.getContentAsStream() : null;
            if (content != null) {
                FileUtils.copyInputStreamToFile((InputStream)content, (File)file);
            }
        }
        catch (Exception e) {
            XltLogger.runTimeLogger.error("Cannot write static content to file: " + file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
        return file.getName();
    }

    private void dumpStaticContentToCache(WebRequest webRequest, WebResponse webResponse) {
        File file;
        URL url = URLCleaner.removeUserInfoIfNecessaryAsURL(webRequest.isRedirected() ? webRequest.getOriginalURL() : webRequest.getUrl());
        String fileName = this.urlMapping.map(url);
        if (fileName.length() > 80) {
            fileName = fileName.substring(0, 80);
        }
        if (!(fileName == null || (file = new File(this.getCacheDirectory(), fileName)).exists() && webResponse.getStatusCode() == 304)) {
            try (InputStream content = this.rewriteResponseIfCss(url, webResponse);){
                FileUtils.copyInputStreamToFile((InputStream)content, (File)file);
            }
            catch (Exception e) {
                XltLogger.runTimeLogger.error("Cannot write static content to cache: " + file.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private InputStream rewriteResponseIfCss(URL baseURL, WebResponse response) throws IOException {
        if (CssUtils.isCssResponse(response)) {
            String responseData = response.getContentAsString();
            if (responseData != null) {
                Set<String> toBeReplaced = CssUtils.getUrlStrings(responseData);
                for (String urlString : toBeReplaced) {
                    String url = UrlUtils.resolveUrl(baseURL, urlString);
                    String urlCheckSum = this.urlMapping.map(url);
                    if (null == urlCheckSum || urlCheckSum.length() <= 0) continue;
                    responseData = responseData.replace(urlString, urlCheckSum);
                }
            }
            return IOUtils.toInputStream((String)responseData, (String)"UTF-8");
        }
        return response.getContentAsStream();
    }

    private void printAndOpenResultBrowserUrl() {
        if (XltEngine.getInstance().isDevMode()) {
            try {
                File indexFile = new File(this.getDumpDirectory(), "index.html").getCanonicalFile();
                if (indexFile.isFile()) {
                    URI indexFileUri = indexFile.toURI();
                    System.out.printf("\n\nResult Browser:\n\t%s\n\n", indexFileUri);
                    boolean openResultBrowser = XltProperties.getInstance().getProperty("com.xceptance.xlt.results.openResultBrowser", false);
                    if (openResultBrowser) {
                        Desktop.getDesktop().browse(indexFileUri);
                    }
                }
            }
            catch (Exception e) {
                LOG.debug("Failed to determine/open the result browser URL", (Throwable)e);
            }
        }
    }

    public synchronized void clear() {
        this.pageCounter = 0;
        this.responseCounter = 0;
        this.dumpDirectory = null;
        this.responseDirectory = null;
        this.pageDirectory = null;
        this.cacheDirectory = null;
        this.dataMgr.clear();
    }
}

