/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.resultbrowser.ActionInfo;
import com.xceptance.xlt.engine.resultbrowser.Page;
import com.xceptance.xlt.engine.resultbrowser.Request;
import com.xceptance.xlt.engine.resultbrowser.RequestInfo;
import com.xceptance.xlt.engine.resultbrowser.TransactionInfo;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

class RequestDataMgr {
    private final List<RequestInfo> pendingRequests = new LinkedList<RequestInfo>();
    private final List<ActionInfo> actions = new LinkedList<ActionInfo>();
    private static final int MAX_BODY_SIZE;

    RequestDataMgr() {
    }

    public TransactionInfo generateTransaction() {
        if (!this.pendingRequests.isEmpty()) {
            this.addActionInfo(new ActionInfo(), "n/a", null);
        }
        for (ActionInfo actionInfo : this.actions) {
            Collections.sort(actionInfo.requests);
        }
        TransactionInfo transactionInfo = new TransactionInfo();
        transactionInfo.user = Session.getCurrent().getUserName();
        transactionInfo.date = GlobalClock.getInstance().getTime();
        transactionInfo.actions.addAll(this.actions);
        TreeMap<String, Object> sortedValueLog = new TreeMap<String, Object>(Session.getCurrent().getValueLog());
        for (Map.Entry entry : sortedValueLog.entrySet()) {
            String value = entry.getValue() == null ? null : entry.getValue().toString();
            transactionInfo.valueLog.add(new NameValuePair((String)entry.getKey(), value));
        }
        return transactionInfo;
    }

    public void pageDumped(String fileName, Page page) {
        ActionInfo actionInfo = page.getActionInfo() != null ? page.getActionInfo() : new ActionInfo();
        this.addActionInfo(actionInfo, page.getName(), "pages/" + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addActionInfo(ActionInfo actionInfo, String actionName, String fileName) {
        actionInfo.name = actionName;
        actionInfo.fileName = fileName;
        actionInfo.requests.addAll(this.pendingRequests);
        RequestDataMgr requestDataMgr = this;
        synchronized (requestDataMgr) {
            this.actions.add(actionInfo);
            this.pendingRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDumped(String fileName, Request request) {
        RequestInfo requestInfo = this.getRequestInfo(fileName, request);
        RequestDataMgr requestDataMgr = this;
        synchronized (requestDataMgr) {
            this.pendingRequests.add(requestInfo);
        }
    }

    private RequestInfo getRequestInfo(String fileName, Request request) {
        WebRequest webRequest = request.webRequest;
        WebResponse webResponse = request.webResponse;
        HttpMethod httpMethod = webRequest.getHttpMethod();
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.name = this.getFileName(webRequest.getUrl());
        requestInfo.url = webRequest.getUrl().toString();
        requestInfo.requestMethod = httpMethod.name();
        requestInfo.requestParameters.addAll(webRequest.getRequestParameters());
        if (httpMethod == HttpMethod.POST || httpMethod == HttpMethod.PUT || httpMethod == HttpMethod.PATCH) {
            requestInfo.formDataEncoding = webRequest.getEncodingType().getName();
        }
        requestInfo.startTime = request.requestData.getTime();
        requestInfo.fileName = "responses/" + fileName;
        Map<String, String> requestHeaders = webRequest.getAdditionalHeaders();
        for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
            requestInfo.requestHeaders.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        requestInfo.requestBodyRaw = StringUtils.abbreviate((String)StringUtils.defaultString((String)webRequest.getRequestBody()), (int)MAX_BODY_SIZE);
        if (webResponse != null) {
            requestInfo.mimeType = webResponse.getContentType();
            requestInfo.responseCode = webResponse.getStatusCode();
            requestInfo.status = webResponse.getStatusCode() + " - " + webResponse.getStatusMessage();
            requestInfo.loadTime = webResponse.getLoadTime();
            requestInfo.responseHeaders.addAll(webResponse.getResponseHeaders());
            requestInfo.protocol = webResponse.getProtocolVersion();
        } else {
            requestInfo.mimeType = "text/html";
            requestInfo.responseCode = 0;
            requestInfo.status = "n/a";
            requestInfo.loadTime = 0L;
            requestInfo.protocol = "n/a";
        }
        requestInfo.setTimings(request.requestData);
        return requestInfo;
    }

    private String getFileName(URL url) {
        int l;
        String path = url.getPath();
        int i = (path = StringUtils.substringBefore((String)path, (String)";")).lastIndexOf(47, (l = path.length()) - 2);
        if (i >= 0) {
            path = path.substring(i + 1);
        }
        return path;
    }

    public synchronized void clear() {
        this.pendingRequests.clear();
        this.actions.clear();
    }

    static {
        String maxBodySizePropertyName = "com.xceptance.xlt.output2disk.maxRequestBodySize";
        int maxBodySizeDefault = 8192;
        int maxBodySize = XltProperties.getInstance().getProperty("com.xceptance.xlt.output2disk.maxRequestBodySize", 8192);
        if (maxBodySize < 4) {
            XltLogger.runTimeLogger.warn("Specified request body size limit is less than the minimum of '4' characters. Will use the minimum size.");
            maxBodySize = 4;
        }
        MAX_BODY_SIZE = maxBodySize;
    }
}

