/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.htmlunit;

import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.xceptance.xlt.engine.scripting.htmlunit.HtmlUnitElementUtils;
import com.xceptance.xlt.engine.scripting.htmlunit.HtmlUnitFinder;
import com.xceptance.xlt.engine.scripting.htmlunit.IllegalLocatorException;
import com.xceptance.xlt.engine.scripting.htmlunit.NoSuchElementException;
import com.xceptance.xlt.engine.scripting.util.TextMatchingUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

class OptionFinder {
    private final Map<String, OptionLookupStrategy> strategies = new HashMap<String, OptionLookupStrategy>();

    OptionFinder() {
        LabelStrategy labelStrategy = new LabelStrategy();
        this.strategies.put("implicit", labelStrategy);
        this.strategies.put("id", new IdStrategy());
        this.strategies.put("index", new IndexStrategy());
        this.strategies.put("label", labelStrategy);
        this.strategies.put("value", new ValueStrategy());
    }

    HtmlOption findOption(HtmlSelect select, String optionLocator) {
        return this.findOptions(select, optionLocator).get(0);
    }

    List<HtmlOption> findOptions(HtmlSelect select, String optionLocator) {
        String value;
        String strategyName;
        Matcher m = HtmlUnitFinder.STRATEGY_PATTERN.matcher(optionLocator);
        if (m.matches()) {
            strategyName = m.group(1);
            value = m.group(2);
        } else {
            strategyName = "implicit";
            value = optionLocator;
        }
        OptionLookupStrategy strategy = this.strategies.get(strategyName);
        if (strategy == null) {
            throw new IllegalLocatorException("Unsupported option locator strategy: " + strategyName);
        }
        List<HtmlOption> options = strategy.find(select, value);
        if (options.size() == 0) {
            throw new NoSuchElementException("No option found for option locator: " + optionLocator);
        }
        return options;
    }

    private static final class ValueStrategy
    extends OptionLookupStrategy {
        private ValueStrategy() {
        }

        @Override
        protected List<HtmlOption> find(HtmlSelect select, String valuePattern) {
            ArrayList<HtmlOption> options = new ArrayList<HtmlOption>();
            for (HtmlOption o : select.getOptions()) {
                if (!TextMatchingUtils.isAMatch(o.getValueAttribute(), valuePattern, true, false)) continue;
                options.add(o);
            }
            return options;
        }
    }

    private static final class LabelStrategy
    extends OptionLookupStrategy {
        private LabelStrategy() {
        }

        @Override
        protected List<HtmlOption> find(HtmlSelect select, String optionLocator) {
            ArrayList<HtmlOption> options = new ArrayList<HtmlOption>();
            for (HtmlOption o : select.getOptions()) {
                if (!TextMatchingUtils.isAMatch(HtmlUnitElementUtils.computeText(o), optionLocator, true, true)) continue;
                options.add(o);
            }
            return options;
        }
    }

    private static final class IndexStrategy
    extends OptionLookupStrategy {
        private IndexStrategy() {
        }

        @Override
        protected List<HtmlOption> find(HtmlSelect select, String optionLocator) {
            ArrayList<HtmlOption> options = new ArrayList<HtmlOption>();
            try {
                int idx = Integer.parseInt(optionLocator);
                if (idx >= 0 && idx < select.getOptionSize()) {
                    options.add(select.getOption(idx));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return options;
        }
    }

    private static final class IdStrategy
    extends OptionLookupStrategy {
        private IdStrategy() {
        }

        @Override
        protected List<HtmlOption> find(HtmlSelect select, String optionLocator) {
            ArrayList<HtmlOption> options = new ArrayList<HtmlOption>();
            for (HtmlOption o : select.getOptions()) {
                if (!optionLocator.equals(o.getId())) continue;
                options.add(o);
            }
            return options;
        }
    }

    private static abstract class OptionLookupStrategy {
        private OptionLookupStrategy() {
        }

        protected abstract List<HtmlOption> find(HtmlSelect var1, String var2);
    }
}

