/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class TimedCounter {
    private final AtomicInteger count = new AtomicInteger(0);

    public TimedCounter() {
        this(0L);
    }

    public TimedCounter(long resetInterval) {
        if (resetInterval > 0L) {
            new CounterResetTask(this, resetInterval);
        }
    }

    public int get() {
        return this.count.get();
    }

    public void increment() {
        this.count.incrementAndGet();
    }

    public void set(int value) {
        this.count.set(value);
    }

    public void reset() {
        this.set(0);
    }

    private static class CounterResetTask
    extends TimerTask {
        private static final Timer RESET_TIMER = new Timer("TimedCounter-ResetTimer");
        private final WeakReference<TimedCounter> counterRef;

        private CounterResetTask(TimedCounter counter, long aInterval) {
            this.counterRef = new WeakReference<TimedCounter>(counter);
            RESET_TIMER.schedule((TimerTask)this, aInterval, aInterval);
        }

        @Override
        public void run() {
            TimedCounter counter = (TimedCounter)this.counterRef.get();
            if (counter != null) {
                counter.reset();
            } else {
                this.cancel();
            }
        }
    }
}

